/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.security;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.InterestResultPolicy;
import org.apache.geode.cache.operations.CloseCQOperationContext;
import org.apache.geode.cache.operations.DestroyOperationContext;
import org.apache.geode.cache.operations.ExecuteCQOperationContext;
import org.apache.geode.cache.operations.ExecuteFunctionOperationContext;
import org.apache.geode.cache.operations.GetDurableCQsOperationContext;
import org.apache.geode.cache.operations.GetOperationContext;
import org.apache.geode.cache.operations.InterestType;
import org.apache.geode.cache.operations.InvalidateOperationContext;
import org.apache.geode.cache.operations.KeySetOperationContext;
import org.apache.geode.cache.operations.PutAllOperationContext;
import org.apache.geode.cache.operations.PutOperationContext;
import org.apache.geode.cache.operations.QueryOperationContext;
import org.apache.geode.cache.operations.RegionClearOperationContext;
import org.apache.geode.cache.operations.RegionCreateOperationContext;
import org.apache.geode.cache.operations.RegionDestroyOperationContext;
import org.apache.geode.cache.operations.RegisterInterestOperationContext;
import org.apache.geode.cache.operations.RemoveAllOperationContext;
import org.apache.geode.cache.operations.StopCQOperationContext;
import org.apache.geode.cache.operations.UnregisterInterestOperationContext;
import org.apache.geode.cache.operations.internal.GetOperationContextImpl;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.i18n.LogWriterI18n;
import org.apache.geode.internal.ClassLoadUtil;
import org.apache.geode.internal.cache.operations.ContainsKeyOperationContext;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.security.AccessControl;
import org.apache.geode.security.NotAuthorizedException;

public class AuthorizeRequest {
    private AccessControl authzCallback;
    private final Principal principal;
    private boolean isPrincipalSerializable;
    private ClientProxyMembershipID id;
    private final LogWriterI18n logger;

    public AuthorizeRequest(String authzFactoryName, DistributedMember dm, Principal principal, Cache cache) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, NotAuthorizedException {
        this.principal = principal;
        this.isPrincipalSerializable = this.principal instanceof Serializable;
        this.logger = cache.getSecurityLoggerI18n();
        Method authzMethod = ClassLoadUtil.methodFromName(authzFactoryName);
        this.authzCallback = (AccessControl)authzMethod.invoke(null, (Object[])null);
        this.authzCallback.init(principal, dm, cache);
        this.id = null;
    }

    public AuthorizeRequest(String authzFactoryName, ClientProxyMembershipID id, Principal principal, Cache cache) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, NotAuthorizedException {
        this(authzFactoryName, id.getDistributedMember(), principal, cache);
        this.id = id;
        if (this.logger.infoEnabled()) {
            this.logger.info(LocalizedStrings.AuthorizeRequest_AUTHORIZEREQUEST_CLIENT_0_IS_SETTING_AUTHORIZATION_CALLBACK_TO_1, new Object[]{id, authzFactoryName});
        }
    }

    public GetOperationContext getAuthorize(String regionName, Object key, Object callbackArg) throws NotAuthorizedException {
        GetOperationContextImpl getContext = new GetOperationContextImpl(key, false);
        getContext.setCallbackArg(callbackArg);
        if (!this.authzCallback.authorizeOperation(regionName, getContext)) {
            String errStr = LocalizedStrings.AuthorizeRequest_NOT_AUTHORIZED_TO_PERFORM_GET_OPERATION_ON_REGION_0.toLocalizedString(regionName);
            if (this.logger.fineEnabled()) {
                this.logger.warning(LocalizedStrings.TWO_ARG_COLON, new Object[]{this, errStr});
            }
            if (this.isPrincipalSerializable) {
                throw new NotAuthorizedException(errStr, this.principal);
            }
            throw new NotAuthorizedException(errStr);
        }
        if (this.logger.finestEnabled()) {
            this.logger.finest(this.toString() + ": Authorized to perform GET operation on region [" + regionName + ']');
        }
        return getContext;
    }

    public PutOperationContext putAuthorize(String regionName, Object key, Object value, boolean isObject, Object callbackArg) throws NotAuthorizedException {
        return this.putAuthorize(regionName, key, value, isObject, callbackArg, (byte)0);
    }

    public PutOperationContext putAuthorize(String regionName, Object key, Object value, boolean isObject, Object callbackArg, byte opType) throws NotAuthorizedException {
        PutOperationContext putContext = new PutOperationContext(key, value, isObject, opType, false);
        putContext.setCallbackArg(callbackArg);
        if (!this.authzCallback.authorizeOperation(regionName, putContext)) {
            String errStr = LocalizedStrings.AuthorizeRequest_NOT_AUTHORIZED_TO_PERFORM_PUT_OPERATION_ON_REGION_0.toLocalizedString(regionName);
            this.logger.warning(LocalizedStrings.TWO_ARG_COLON, new Object[]{this, errStr});
            if (this.isPrincipalSerializable) {
                throw new NotAuthorizedException(errStr, this.principal);
            }
            throw new NotAuthorizedException(errStr);
        }
        if (this.logger.finestEnabled()) {
            this.logger.finest(this.toString() + ": Authorized to perform PUT operation on region [" + regionName + ']');
        }
        return putContext;
    }

    public PutAllOperationContext putAllAuthorize(String regionName, Map map, Object callbackArg) throws NotAuthorizedException {
        PutAllOperationContext putAllContext = new PutAllOperationContext(map);
        putAllContext.setCallbackArg(callbackArg);
        if (!this.authzCallback.authorizeOperation(regionName, putAllContext)) {
            String errStr = LocalizedStrings.AuthorizeRequest_NOT_AUTHORIZED_TO_PERFORM_PUTALL_OPERATION_ON_REGION_0.toLocalizedString(regionName);
            if (this.logger.warningEnabled()) {
                this.logger.warning(LocalizedStrings.TWO_ARG_COLON, new Object[]{this, errStr});
            }
            if (this.isPrincipalSerializable) {
                throw new NotAuthorizedException(errStr, this.principal);
            }
            throw new NotAuthorizedException(errStr);
        }
        if (this.logger.finestEnabled()) {
            this.logger.finest(this.toString() + ": Authorized to perform PUTALL operation on region [" + regionName + ']');
        }
        return putAllContext;
    }

    public RemoveAllOperationContext removeAllAuthorize(String regionName, Collection<?> keys, Object callbackArg) throws NotAuthorizedException {
        RemoveAllOperationContext removeAllContext = new RemoveAllOperationContext(keys);
        removeAllContext.setCallbackArg(callbackArg);
        if (!this.authzCallback.authorizeOperation(regionName, removeAllContext)) {
            String errStr = LocalizedStrings.AuthorizeRequest_NOT_AUTHORIZED_TO_PERFORM_REMOVEALL_OPERATION_ON_REGION_0.toLocalizedString(regionName);
            if (this.logger.warningEnabled()) {
                this.logger.warning(LocalizedStrings.TWO_ARG_COLON, new Object[]{this, errStr});
            }
            if (this.isPrincipalSerializable) {
                throw new NotAuthorizedException(errStr, this.principal);
            }
            throw new NotAuthorizedException(errStr);
        }
        if (this.logger.finestEnabled()) {
            this.logger.finest(this.toString() + ": Authorized to perform removeAll operation on region [" + regionName + ']');
        }
        return removeAllContext;
    }

    public DestroyOperationContext destroyAuthorize(String regionName, Object key, Object callbackArg) throws NotAuthorizedException {
        DestroyOperationContext destroyEntryContext = new DestroyOperationContext(key);
        destroyEntryContext.setCallbackArg(callbackArg);
        if (!this.authzCallback.authorizeOperation(regionName, destroyEntryContext)) {
            String errStr = LocalizedStrings.AuthorizeRequest_NOT_AUTHORIZED_TO_PERFORM_DESTROY_OPERATION_ON_REGION_0.toLocalizedString(regionName);
            this.logger.warning(LocalizedStrings.TWO_ARG_COLON, new Object[]{this, errStr});
            if (this.isPrincipalSerializable) {
                throw new NotAuthorizedException(errStr, this.principal);
            }
            throw new NotAuthorizedException(errStr);
        }
        if (this.logger.finestEnabled()) {
            this.logger.finest(this.toString() + ": Authorized to perform DESTROY operation on region [" + regionName + ']');
        }
        return destroyEntryContext;
    }

    public QueryOperationContext queryAuthorize(String queryString, Set regionNames) throws NotAuthorizedException {
        return this.queryAuthorize(queryString, regionNames, null);
    }

    public QueryOperationContext queryAuthorize(String queryString, Set regionNames, Object[] queryParams) throws NotAuthorizedException {
        QueryOperationContext queryContext;
        if (regionNames == null) {
            regionNames = new HashSet();
        }
        if (!this.authzCallback.authorizeOperation(null, queryContext = new QueryOperationContext(queryString, regionNames, false, queryParams))) {
            String errStr = LocalizedStrings.AuthorizeRequest_NOT_AUTHORIZED_TO_PERFOM_QUERY_OPERATION_0_ON_THE_CACHE.toLocalizedString(queryString);
            this.logger.warning(LocalizedStrings.TWO_ARG_COLON, new Object[]{this, errStr});
            if (this.isPrincipalSerializable) {
                throw new NotAuthorizedException(errStr, this.principal);
            }
            throw new NotAuthorizedException(errStr);
        }
        if (this.logger.finestEnabled()) {
            this.logger.finest(this.toString() + ": Authorized to perform QUERY operation [" + queryString + "] on cache");
        }
        return queryContext;
    }

    public ExecuteCQOperationContext executeCQAuthorize(String cqName, String queryString, Set regionNames) throws NotAuthorizedException {
        ExecuteCQOperationContext executeCQContext;
        if (regionNames == null) {
            regionNames = new HashSet();
        }
        if (!this.authzCallback.authorizeOperation(null, executeCQContext = new ExecuteCQOperationContext(cqName, queryString, regionNames, false))) {
            String errStr = LocalizedStrings.AuthorizeRequest_NOT_AUTHORIZED_TO_PERFOM_EXECUTE_CQ_OPERATION_0_ON_THE_CACHE.toLocalizedString(queryString);
            this.logger.warning(LocalizedStrings.TWO_ARG_COLON, new Object[]{this, errStr});
            if (this.isPrincipalSerializable) {
                throw new NotAuthorizedException(errStr, this.principal);
            }
            throw new NotAuthorizedException(errStr);
        }
        if (this.logger.finestEnabled()) {
            this.logger.finest(this.toString() + ": Authorized to perform EXECUTE_CQ operation [" + queryString + "] on cache");
        }
        return executeCQContext;
    }

    public void stopCQAuthorize(String cqName, String queryString, Set regionNames) throws NotAuthorizedException {
        StopCQOperationContext stopCQContext = new StopCQOperationContext(cqName, queryString, regionNames);
        if (!this.authzCallback.authorizeOperation(null, stopCQContext)) {
            String errStr = LocalizedStrings.AuthorizeRequest_NOT_AUTHORIZED_TO_PERFOM_STOP_CQ_OPERATION_0_ON_THE_CACHE.toLocalizedString(cqName);
            this.logger.warning(LocalizedStrings.TWO_ARG_COLON, new Object[]{this, errStr});
            if (this.isPrincipalSerializable) {
                throw new NotAuthorizedException(errStr, this.principal);
            }
            throw new NotAuthorizedException(errStr);
        }
        if (this.logger.finestEnabled()) {
            this.logger.finest(this.toString() + ": Authorized to perform STOP_CQ operation [" + cqName + ',' + queryString + "] on cache");
        }
    }

    public void closeCQAuthorize(String cqName, String queryString, Set regionNames) throws NotAuthorizedException {
        CloseCQOperationContext closeCQContext = new CloseCQOperationContext(cqName, queryString, regionNames);
        if (!this.authzCallback.authorizeOperation(null, closeCQContext)) {
            String errStr = LocalizedStrings.AuthorizeRequest_NOT_AUTHORIZED_TO_PERFOM_CLOSE_CQ_OPERATION_0_ON_THE_CACHE.toLocalizedString(cqName);
            this.logger.warning(LocalizedStrings.TWO_ARG_COLON, new Object[]{this, errStr});
            if (this.isPrincipalSerializable) {
                throw new NotAuthorizedException(errStr, this.principal);
            }
            throw new NotAuthorizedException(errStr);
        }
        if (this.logger.finestEnabled()) {
            this.logger.finest(this.toString() + ": Authorized to perform CLOSE_CQ operation [" + cqName + ',' + queryString + "] on cache");
        }
    }

    public void getDurableCQsAuthorize() throws NotAuthorizedException {
        GetDurableCQsOperationContext getDurableCQsContext = new GetDurableCQsOperationContext();
        if (!this.authzCallback.authorizeOperation(null, getDurableCQsContext)) {
            String errStr = LocalizedStrings.AuthorizeRequest_NOT_AUTHORIZED_TO_PERFORM_GET_DURABLE_CQS_OPERATION_0_ON_THE_CACHE.toLocalizedString();
            this.logger.warning(LocalizedStrings.TWO_ARG_COLON, new Object[]{this, errStr});
            if (this.isPrincipalSerializable) {
                throw new NotAuthorizedException(errStr, this.principal);
            }
            throw new NotAuthorizedException(errStr);
        }
        if (this.logger.finestEnabled()) {
            this.logger.finest(this.toString() + ": Authorized to perform GET_DURABLE_CQS operation on cache");
        }
    }

    public RegionClearOperationContext clearAuthorize(String regionName, Object callbackArg) throws NotAuthorizedException {
        RegionClearOperationContext regionClearContext = new RegionClearOperationContext(false);
        regionClearContext.setCallbackArg(callbackArg);
        if (!this.authzCallback.authorizeOperation(regionName, regionClearContext)) {
            String errStr = LocalizedStrings.AuthorizeRequest_NOT_AUTHORIZED_TO_PERFORM_REGION_CLEAR_OPERATION_ON_REGION_0.toLocalizedString(regionName);
            this.logger.warning(LocalizedStrings.TWO_ARG_COLON, new Object[]{this, errStr});
            if (this.isPrincipalSerializable) {
                throw new NotAuthorizedException(errStr, this.principal);
            }
            throw new NotAuthorizedException(errStr);
        }
        if (this.logger.finestEnabled()) {
            this.logger.finest(this.toString() + ": Authorized to perform REGION_CLEAR operation on region [" + regionName + ']');
        }
        return regionClearContext;
    }

    public RegisterInterestOperationContext registerInterestAuthorize(String regionName, Object key, int interestType2, InterestResultPolicy policy) throws NotAuthorizedException {
        RegisterInterestOperationContext registerInterestContext = new RegisterInterestOperationContext(key, InterestType.fromOrdinal((byte)interestType2), policy);
        if (!this.authzCallback.authorizeOperation(regionName, registerInterestContext)) {
            String errStr = LocalizedStrings.AuthorizeRequest_NOT_AUTHORIZED_TO_PERFORM_REGISTER_INTEREST_OPERATION_FOR_REGION_0.toLocalizedString(regionName);
            this.logger.warning(LocalizedStrings.TWO_ARG_COLON, new Object[]{this, errStr});
            if (this.isPrincipalSerializable) {
                throw new NotAuthorizedException(errStr, this.principal);
            }
            throw new NotAuthorizedException(errStr);
        }
        if (this.logger.finestEnabled()) {
            this.logger.finest(this.toString() + ": Authorized to perform REGISTER_INTEREST operation for region [" + regionName + ']');
        }
        return registerInterestContext;
    }

    public RegisterInterestOperationContext registerInterestListAuthorize(String regionName, List keys, InterestResultPolicy policy) throws NotAuthorizedException {
        RegisterInterestOperationContext registerInterestListContext = new RegisterInterestOperationContext(keys, InterestType.LIST, policy);
        if (!this.authzCallback.authorizeOperation(regionName, registerInterestListContext)) {
            String errStr = LocalizedStrings.AuthorizeRequest_NOT_AUTHORIZED_TO_PERFORM_REGISTER_INTEREST_LIST_OPERATION_FOR_REGION_0.toLocalizedString(regionName);
            this.logger.warning(LocalizedStrings.TWO_ARG_COLON, new Object[]{this, errStr});
            if (this.isPrincipalSerializable) {
                throw new NotAuthorizedException(errStr, this.principal);
            }
            throw new NotAuthorizedException(errStr);
        }
        if (this.logger.finestEnabled()) {
            this.logger.finest(this.toString() + ": Authorized to perform REGISTER_INTEREST_LIST operation for region [" + regionName + ']');
        }
        return registerInterestListContext;
    }

    public UnregisterInterestOperationContext unregisterInterestAuthorize(String regionName, Object key, int interestType2) throws NotAuthorizedException {
        UnregisterInterestOperationContext unregisterInterestContext = new UnregisterInterestOperationContext(key, InterestType.fromOrdinal((byte)interestType2));
        if (!this.authzCallback.authorizeOperation(regionName, unregisterInterestContext)) {
            String errStr = LocalizedStrings.AuthorizeRequest_NOT_AUTHORIZED_TO_PERFORM_UNREGISTER_INTEREST_OPERATION_FOR_REGION_0.toLocalizedString(regionName);
            this.logger.warning(LocalizedStrings.TWO_ARG_COLON, new Object[]{this, errStr});
            if (this.isPrincipalSerializable) {
                throw new NotAuthorizedException(errStr, this.principal);
            }
            throw new NotAuthorizedException(errStr);
        }
        if (this.logger.finestEnabled()) {
            this.logger.finest(this.toString() + ": Authorized to perform DESTROY operation on region [" + regionName + ']');
        }
        return unregisterInterestContext;
    }

    public UnregisterInterestOperationContext unregisterInterestListAuthorize(String regionName, List keys) throws NotAuthorizedException {
        UnregisterInterestOperationContext unregisterInterestListContext = new UnregisterInterestOperationContext(keys, InterestType.LIST);
        if (!this.authzCallback.authorizeOperation(regionName, unregisterInterestListContext)) {
            String errStr = LocalizedStrings.AuthorizeRequest_NOT_AUTHORIZED_TO_PERFORM_UNREGISTER_INTEREST_LIST_OPERATION_FOR_REGION_0.toLocalizedString(regionName);
            this.logger.warning(LocalizedStrings.TWO_ARG_COLON, new Object[]{this, errStr});
            if (this.isPrincipalSerializable) {
                throw new NotAuthorizedException(errStr, this.principal);
            }
            throw new NotAuthorizedException(errStr);
        }
        if (this.logger.finestEnabled()) {
            this.logger.finest(this.toString() + ": Authorized to perform UNREGISTER_INTEREST_LIST operation for region [" + regionName + ']');
        }
        return unregisterInterestListContext;
    }

    public KeySetOperationContext keySetAuthorize(String regionName) throws NotAuthorizedException {
        KeySetOperationContext keySetContext = new KeySetOperationContext(false);
        if (!this.authzCallback.authorizeOperation(regionName, keySetContext)) {
            String errStr = LocalizedStrings.AuthorizeRequest_NOT_AUTHORIZED_TO_PERFORM_KEY_SET_OPERATION_ON_REGION_0.toLocalizedString(regionName);
            this.logger.warning(LocalizedStrings.TWO_ARG_COLON, new Object[]{this, errStr});
            if (this.isPrincipalSerializable) {
                throw new NotAuthorizedException(errStr, this.principal);
            }
            throw new NotAuthorizedException(errStr);
        }
        if (this.logger.finestEnabled()) {
            this.logger.finest(this.toString() + ": Authorized to perform KEY_SET operation on region [" + regionName + ']');
        }
        return keySetContext;
    }

    public void containsKeyAuthorize(String regionName, Object key) throws NotAuthorizedException {
        ContainsKeyOperationContext containsKeyContext = new ContainsKeyOperationContext(key);
        if (!this.authzCallback.authorizeOperation(regionName, containsKeyContext)) {
            String errStr = LocalizedStrings.AuthorizeRequest_NOT_AUTHORIZED_TO_PERFORM_CONTAINS_KEY_OPERATION_ON_REGION_0.toLocalizedString(regionName);
            this.logger.warning(LocalizedStrings.TWO_ARG_COLON, new Object[]{this, errStr});
            if (this.isPrincipalSerializable) {
                throw new NotAuthorizedException(errStr, this.principal);
            }
            throw new NotAuthorizedException(errStr);
        }
        if (this.logger.finestEnabled()) {
            this.logger.finest(this.toString() + ": Authorized to perform CONTAINS_KEY operation on region [" + regionName + ']');
        }
    }

    public void createRegionAuthorize(String regionName) throws NotAuthorizedException {
        RegionCreateOperationContext regionCreateContext = new RegionCreateOperationContext(false);
        if (!this.authzCallback.authorizeOperation(regionName, regionCreateContext)) {
            String errStr = LocalizedStrings.AuthorizeRequest_NOT_AUTHORIZED_TO_PERFORM_CREATE_REGION_OPERATION_FOR_THE_REGION_0.toLocalizedString(regionName);
            this.logger.warning(LocalizedStrings.TWO_ARG_COLON, new Object[]{this, errStr});
            if (this.isPrincipalSerializable) {
                throw new NotAuthorizedException(errStr, this.principal);
            }
            throw new NotAuthorizedException(errStr);
        }
        if (this.logger.finestEnabled()) {
            this.logger.finest(this.toString() + ": Authorized to perform REGION_CREATE operation of region [" + regionName + ']');
        }
    }

    public RegionDestroyOperationContext destroyRegionAuthorize(String regionName, Object callbackArg) throws NotAuthorizedException {
        RegionDestroyOperationContext regionDestroyContext = new RegionDestroyOperationContext(false);
        regionDestroyContext.setCallbackArg(callbackArg);
        if (!this.authzCallback.authorizeOperation(regionName, regionDestroyContext)) {
            String errStr = LocalizedStrings.AuthorizeRequest_NOT_AUTHORIZED_TO_PERFORM_REGION_DESTROY_OPERATION_FOR_THE_REGION_0.toLocalizedString(regionName);
            this.logger.warning(LocalizedStrings.TWO_ARG_COLON, new Object[]{this, errStr});
            if (this.isPrincipalSerializable) {
                throw new NotAuthorizedException(errStr, this.principal);
            }
            throw new NotAuthorizedException(errStr);
        }
        if (this.logger.finestEnabled()) {
            this.logger.finest(this.toString() + ": Authorized to perform REGION_DESTROY operation for region [" + regionName + ']');
        }
        return regionDestroyContext;
    }

    public ExecuteFunctionOperationContext executeFunctionAuthorize(String functionName, String region, Set keySet, Object arguments, boolean optimizeForWrite) throws NotAuthorizedException {
        ExecuteFunctionOperationContext executeContext = new ExecuteFunctionOperationContext(functionName, region, keySet, arguments, optimizeForWrite, false);
        if (!this.authzCallback.authorizeOperation(region, executeContext)) {
            String errStr = LocalizedStrings.AuthorizeRequest_NOT_AUTHORIZED_TO_PERFORM_EXECUTE_REGION_FUNCTION_OPERATION.toLocalizedString();
            if (this.logger.warningEnabled()) {
                this.logger.warning(LocalizedStrings.TWO_ARG_COLON, new Object[]{this, errStr});
            }
            if (this.isPrincipalSerializable) {
                throw new NotAuthorizedException(errStr, this.principal);
            }
            throw new NotAuthorizedException(errStr);
        }
        if (this.logger.finestEnabled()) {
            this.logger.finest(this.toString() + ": Authorized to perform EXECUTE_REGION_FUNCTION operation ");
        }
        return executeContext;
    }

    public InvalidateOperationContext invalidateAuthorize(String regionName, Object key, Object callbackArg) throws NotAuthorizedException {
        InvalidateOperationContext invalidateEntryContext = new InvalidateOperationContext(key);
        invalidateEntryContext.setCallbackArg(callbackArg);
        if (!this.authzCallback.authorizeOperation(regionName, invalidateEntryContext)) {
            String errStr = LocalizedStrings.AuthorizeRequest_NOT_AUTHORIZED_TO_PERFORM_INVALIDATE_OPERATION_ON_REGION_0.toLocalizedString(regionName);
            this.logger.warning(LocalizedStrings.TWO_ARG_COLON, new Object[]{this, errStr});
            if (this.isPrincipalSerializable) {
                throw new NotAuthorizedException(errStr, this.principal);
            }
            throw new NotAuthorizedException(errStr);
        }
        if (this.logger.finestEnabled()) {
            this.logger.finest(this.toString() + ": Authorized to perform INVALIDATE operation on region [" + regionName + ']');
        }
        return invalidateEntryContext;
    }

    public void close() {
        this.authzCallback.close();
    }

    public String toString() {
        return (this.id == null ? "ClientProxyMembershipID not available" : this.id.toString()) + ",Principal:" + (this.principal == null ? "" : this.principal.getName());
    }
}

