/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.process;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.process.BlockingProcessStreamReader;
import org.apache.geode.internal.process.NonBlockingProcessStreamReader;
import org.apache.logging.log4j.Logger;

public abstract class ProcessStreamReader
implements Runnable {
    private static final Logger logger = LogService.getLogger();
    protected final Process process;
    protected final InputStream inputStream;
    protected final InputListener inputListener;
    private Thread thread;

    protected ProcessStreamReader(Builder builder) {
        this.process = builder.process;
        this.inputStream = builder.inputStream;
        this.inputListener = builder.inputListener == null ? new InputListener(){

            @Override
            public void notifyInputLine(String line) {
            }

            public String toString() {
                return "NullInputListener";
            }
        } : builder.inputListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (isDebugEnabled) {
            logger.debug("Running {}", (Object)this);
        }
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(this.inputStream));
            while ((line = reader.readLine()) != null) {
                this.inputListener.notifyInputLine(line);
            }
        }
        catch (IOException e) {
            if (isDebugEnabled) {
                logger.debug("Failure reading from buffered input stream: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        finally {
            block16: {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    if (!isDebugEnabled) break block16;
                    logger.debug("Failure closing buffered input stream reader: {}", (Object)e.getMessage(), (Object)e);
                }
            }
            if (isDebugEnabled) {
                logger.debug("Terminating {}", (Object)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessStreamReader start() {
        ProcessStreamReader processStreamReader = this;
        synchronized (processStreamReader) {
            if (this.thread != null) {
                if (this.thread.isAlive()) {
                    throw new IllegalStateException(this + " has already started");
                }
                throw new IllegalStateException(this + " was stopped and cannot be restarted");
            }
            this.thread = new Thread((Runnable)this, this.createThreadName());
            this.thread.setDaemon(true);
            this.thread.start();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessStreamReader stop() {
        ProcessStreamReader processStreamReader = this;
        synchronized (processStreamReader) {
            if (this.thread != null && this.thread.isAlive()) {
                this.thread.interrupt();
            } else if (this.thread != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{} has already been stopped", (Object)this);
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug("{} has not been started", (Object)this);
            }
        }
        return this;
    }

    public ProcessStreamReader stopAsync(final long delayMillis) {
        Runnable delayedStop = new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(delayMillis);
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    ProcessStreamReader.this.stop();
                }
            }
        };
        String threadName = this.getClass().getSimpleName() + " stopAfterDelay Thread @" + Integer.toHexString(this.hashCode());
        Thread thread = new Thread(delayedStop, threadName);
        thread.setDaemon(true);
        thread.start();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        ProcessStreamReader processStreamReader = this;
        synchronized (processStreamReader) {
            if (this.thread != null) {
                return this.thread.isAlive();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join() throws InterruptedException {
        Thread thread;
        ProcessStreamReader processStreamReader = this;
        synchronized (processStreamReader) {
            thread = this.thread;
        }
        if (thread != null) {
            thread.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join(long millis) throws InterruptedException {
        Thread thread;
        ProcessStreamReader processStreamReader = this;
        synchronized (processStreamReader) {
            thread = this.thread;
        }
        if (thread != null) {
            thread.join(millis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join(long millis, int nanos) throws InterruptedException {
        Thread thread;
        ProcessStreamReader processStreamReader = this;
        synchronized (processStreamReader) {
            thread = this.thread;
        }
        if (thread != null) {
            thread.join(millis, nanos);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append(" Thread").append(" #").append(System.identityHashCode(this));
        sb.append(" alive=").append(this.isRunning());
        sb.append(" listener=").append(this.inputListener);
        return sb.toString();
    }

    private String createThreadName() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode());
    }

    public static class Builder {
        protected Process process;
        protected InputStream inputStream;
        protected InputListener inputListener;
        protected long continueReadingMillis = 0L;
        protected ReadingMode readingMode = ReadingMode.BLOCKING;

        public Builder(Process process) {
            this.process = process;
        }

        public Builder inputStream(InputStream inputStream) {
            this.inputStream = inputStream;
            return this;
        }

        public Builder inputListener(InputListener inputListener) {
            this.inputListener = inputListener;
            return this;
        }

        public Builder continueReadingMillis(long continueReadingMillis) {
            this.continueReadingMillis = continueReadingMillis;
            return this;
        }

        public Builder readingMode(ReadingMode readingMode) {
            this.readingMode = readingMode;
            return this;
        }

        public ProcessStreamReader build() {
            if (this.process == null) {
                throw new NullPointerException("process may not be null");
            }
            if (this.inputStream == null) {
                throw new NullPointerException("inputStream may not be null");
            }
            if (this.continueReadingMillis < 0L) {
                throw new IllegalArgumentException("continueReadingMillis must zero or positive");
            }
            switch (this.readingMode) {
                case NON_BLOCKING: {
                    return new NonBlockingProcessStreamReader(this);
                }
            }
            return new BlockingProcessStreamReader(this);
        }
    }

    public static enum ReadingMode {
        BLOCKING,
        NON_BLOCKING;

    }

    public static interface InputListener {
        public void notifyInputLine(String var1);
    }
}

