/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.process;

import com.sun.tools.attach.AgentInitializationException;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Properties;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.geode.internal.process.ConnectionFailedException;
import org.apache.geode.internal.process.MBeanInvocationFailedException;
import org.apache.geode.internal.process.PidUnavailableException;
import org.apache.geode.internal.process.ProcessUtils;
import org.apache.geode.internal.util.IOUtils;

public final class LocalProcessController {
    private static final String LOCAL_CONNECTOR_ADDRESS_PROP = "com.sun.management.jmxremote.localConnectorAddress";
    private final int pid;
    protected JMXConnector jmxc;
    protected MBeanServerConnection server;

    public LocalProcessController(int pid) {
        if (pid < 1) {
            throw new IllegalArgumentException("Invalid pid '" + pid + "' specified");
        }
        this.pid = pid;
    }

    public LocalProcessController(File pidFile) throws IOException {
        this(LocalProcessController.readPid(pidFile));
    }

    public LocalProcessController(File directory, String pidFilename) throws IOException {
        this(LocalProcessController.readPid(directory, pidFilename));
    }

    public void stop(ObjectName namePattern, String pidAttribute, String stopMethod, String[] attributes, Object[] values) throws ConnectionFailedException, IOException, MBeanInvocationFailedException, PidUnavailableException {
        this.invokeOperationOnTargetMBean(namePattern, pidAttribute, stopMethod, attributes, values);
    }

    public String status(ObjectName namePattern, String pidAttribute, String statusMethod, String[] attributes, Object[] values) throws ConnectionFailedException, IOException, MBeanInvocationFailedException, PidUnavailableException {
        return this.invokeOperationOnTargetMBean(namePattern, pidAttribute, statusMethod, attributes, values).toString();
    }

    private Object invokeOperationOnTargetMBean(ObjectName namePattern, String pidAttribute, String methodName, String[] attributes, Object[] values) throws ConnectionFailedException, IOException, MBeanInvocationFailedException, PidUnavailableException {
        ObjectName objectName = namePattern;
        this.connect();
        try {
            QueryExp constraint = this.buildQueryExp(pidAttribute, attributes, values);
            Set<ObjectName> mbeanNames = this.server.queryNames(namePattern, constraint);
            if (mbeanNames.isEmpty()) {
                throw new MBeanInvocationFailedException("Failed to find mbean matching '" + namePattern + "' with attribute '" + pidAttribute + "' of value '" + this.pid + "'");
            }
            if (mbeanNames.size() > 1) {
                throw new MBeanInvocationFailedException("Found more than one mbean matching '" + namePattern + "' with attribute '" + pidAttribute + "' of value '" + this.pid + "'");
            }
            objectName = mbeanNames.iterator().next();
            Object object = this.invoke(objectName, methodName);
            return object;
        }
        catch (InstanceNotFoundException e) {
            throw new MBeanInvocationFailedException("Failed to invoke " + methodName + " on " + objectName, e);
        }
        catch (MBeanException e) {
            throw new MBeanInvocationFailedException("Failed to invoke " + methodName + " on " + objectName, e);
        }
        catch (ReflectionException e) {
            throw new MBeanInvocationFailedException("Failed to invoke " + methodName + " on " + objectName, e);
        }
        finally {
            this.disconnect();
        }
    }

    public int getProcessId() {
        return this.pid;
    }

    void connect() throws ConnectionFailedException, IOException {
        try {
            JMXServiceURL jmxUrl = this.getJMXServiceURL();
            this.jmxc = JMXConnectorFactory.connect(jmxUrl);
            this.server = this.jmxc.getMBeanServerConnection();
        }
        catch (AttachNotSupportedException e) {
            throw new ConnectionFailedException("Failed to connect to process '" + this.pid + "'", e);
        }
    }

    void disconnect() {
        this.server = null;
        if (this.jmxc != null) {
            try {
                this.jmxc.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.jmxc = null;
    }

    boolean checkPidMatches() throws IllegalStateException, IOException, PidUnavailableException {
        RuntimeMXBean proxy = ManagementFactory.newPlatformMXBeanProxy(this.server, "java.lang:type=Runtime", RuntimeMXBean.class);
        int remotePid = ProcessUtils.identifyPid(proxy.getName());
        if (remotePid != this.pid) {
            throw new IllegalStateException("Process has different pid '" + remotePid + "' than expected pid '" + this.pid + "'");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JMXServiceURL getJMXServiceURL() throws AttachNotSupportedException, IOException {
        String connectorAddress;
        block8: {
            connectorAddress = null;
            VirtualMachine vm = VirtualMachine.attach(String.valueOf(this.pid));
            try {
                Properties agentProps = vm.getAgentProperties();
                connectorAddress = (String)agentProps.get(LOCAL_CONNECTOR_ADDRESS_PROP);
                if (connectorAddress != null) break block8;
                String javaHome = vm.getSystemProperties().getProperty("java.home");
                String managementAgentPath = javaHome + File.separator + "jre" + File.separator + "lib" + File.separator + "management-agent.jar";
                File managementAgent = new File(managementAgentPath);
                if (!managementAgent.exists() && !(managementAgent = new File(managementAgentPath = javaHome + File.separator + "lib" + File.separator + "management-agent.jar")).exists()) {
                    throw new IOException("JDK management agent not found");
                }
                managementAgentPath = managementAgent.getCanonicalPath();
                try {
                    vm.loadAgent(managementAgentPath, "com.sun.management.jmxremote");
                }
                catch (AgentLoadException e) {
                    IOException ioe = new IOException(e.getMessage());
                    ioe.initCause(e);
                    throw ioe;
                }
                catch (AgentInitializationException e) {
                    IOException ioe = new IOException(e.getMessage());
                    ioe.initCause(e);
                    throw ioe;
                }
                agentProps = vm.getAgentProperties();
                connectorAddress = (String)agentProps.get(LOCAL_CONNECTOR_ADDRESS_PROP);
            }
            finally {
                vm.detach();
            }
        }
        if (connectorAddress == null) {
            throw new IOException("Failed to find address to attach to process");
        }
        return new JMXServiceURL(connectorAddress);
    }

    private QueryExp buildQueryExp(String pidAttribute, String[] attributes, Object[] values) {
        QueryExp optionalAttributes = this.buildOptionalQueryExp(attributes, values);
        QueryExp constraint = optionalAttributes != null ? Query.and(optionalAttributes, Query.eq(Query.attr(pidAttribute), Query.value(this.pid))) : Query.eq(Query.attr(pidAttribute), Query.value(this.pid));
        return constraint;
    }

    private QueryExp buildOptionalQueryExp(String[] attributes, Object[] values) {
        QueryExp queryExp = null;
        for (int i = 0; i < attributes.length; ++i) {
            if (values[i] instanceof Boolean) {
                if (queryExp == null) {
                    queryExp = Query.eq(Query.attr(attributes[i]), Query.value((Boolean)values[i]));
                    continue;
                }
                queryExp = Query.and(queryExp, Query.eq(Query.attr(attributes[i]), Query.value((Boolean)values[i])));
                continue;
            }
            if (values[i] instanceof Number) {
                if (queryExp == null) {
                    queryExp = Query.eq(Query.attr(attributes[i]), Query.value((Number)values[i]));
                    continue;
                }
                queryExp = Query.and(queryExp, Query.eq(Query.attr(attributes[i]), Query.value((Number)values[i])));
                continue;
            }
            if (!(values[i] instanceof String)) continue;
            queryExp = queryExp == null ? Query.eq(Query.attr(attributes[i]), Query.value((String)values[i])) : Query.and(queryExp, Query.eq(Query.attr(attributes[i]), Query.value((String)values[i])));
        }
        return queryExp;
    }

    private Object invoke(ObjectName objectName, String method) throws InstanceNotFoundException, IOException, MBeanException, ReflectionException {
        return this.server.invoke(objectName, method, new Object[0], new String[0]);
    }

    private static int readPid(File pidFile) throws IOException {
        int n;
        BufferedReader fileReader = null;
        String pidValue = null;
        try {
            fileReader = new BufferedReader(new FileReader(pidFile));
            pidValue = fileReader.readLine();
            int pid = Integer.parseInt(pidValue);
            if (pid < 1) {
                throw new IllegalArgumentException("Invalid pid '" + pid + "' found in " + pidFile);
            }
            n = pid;
        }
        catch (NumberFormatException e) {
            try {
                throw new IllegalArgumentException("Invalid pid '" + pidValue + "' found in " + pidFile);
            }
            catch (Throwable throwable) {
                IOUtils.close(fileReader);
                throw throwable;
            }
        }
        IOUtils.close(fileReader);
        return n;
    }

    private static int readPid(File directory, final String pidFilename) throws IOException {
        if (!directory.isDirectory() && directory.exists()) {
            throw new IllegalArgumentException("Argument '" + directory + "' must be an existing directory!");
        }
        File[] files = directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String filename) {
                return filename.equals(pidFilename);
            }
        });
        if (files.length == 0) {
            throw new FileNotFoundException("Unable to find PID file '" + pidFilename + "' in directory " + directory);
        }
        return LocalProcessController.readPid(files[0]);
    }
}

