/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.process;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.geode.distributed.AbstractLauncher;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.process.ControlFileWatchdog;
import org.apache.geode.internal.process.ControlNotificationHandler;
import org.apache.geode.internal.process.FileAlreadyExistsException;
import org.apache.geode.internal.process.LocalProcessLauncher;
import org.apache.geode.internal.process.PidUnavailableException;
import org.apache.geode.internal.process.ProcessType;
import org.apache.logging.log4j.Logger;

public final class ControllableProcess {
    private static final Logger logger = LogService.getLogger();
    private final File workingDir;
    private final File pidFile;
    private final LocalProcessLauncher launcher;
    private final ControlFileWatchdog stopRequestFileWatchdog;
    private final ControlFileWatchdog statusRequestFileWatchdog;

    public ControllableProcess(final ControlNotificationHandler handler, final File workingDir, final ProcessType processType, boolean force) throws FileAlreadyExistsException, IOException, PidUnavailableException {
        this.workingDir = workingDir;
        this.pidFile = new File(this.workingDir, processType.getPidFileName());
        ControllableProcess.deleteFiles(this.workingDir, processType);
        this.launcher = new LocalProcessLauncher(this.pidFile, force);
        ControlFileWatchdog.ControlRequestHandler stopHandler = new ControlFileWatchdog.ControlRequestHandler(){

            @Override
            public void handleRequest() {
                handler.handleStop();
            }
        };
        ControlFileWatchdog.ControlRequestHandler statusHandler = new ControlFileWatchdog.ControlRequestHandler(){

            @Override
            public void handleRequest() throws IOException {
                File statusFileTmp;
                AbstractLauncher.ServiceState<?> state = handler.handleStatus();
                File statusFile = new File(workingDir, processType.getStatusFileName());
                if (statusFile.exists()) {
                    statusFile.delete();
                }
                if ((statusFileTmp = new File(workingDir, processType.getStatusFileName() + ".tmp")).exists()) {
                    statusFileTmp.delete();
                }
                boolean created = statusFileTmp.createNewFile();
                assert (created);
                FileWriter writer = new FileWriter(statusFileTmp);
                writer.write(state.toJson());
                writer.flush();
                writer.close();
                boolean renamed = statusFileTmp.renameTo(statusFile);
                assert (renamed);
            }
        };
        this.stopRequestFileWatchdog = new ControlFileWatchdog(workingDir, processType.getStopRequestFileName(), stopHandler, false);
        this.stopRequestFileWatchdog.start();
        this.statusRequestFileWatchdog = new ControlFileWatchdog(workingDir, processType.getStatusRequestFileName(), statusHandler, false);
        this.statusRequestFileWatchdog.start();
    }

    public int getPid() {
        return this.launcher.getPid();
    }

    public File getPidFile() {
        return this.launcher.getPidFile();
    }

    public void stop() {
        try {
            this.statusRequestFileWatchdog.stop();
        }
        catch (InterruptedException e) {
            logger.warn("Interrupted while stopping status handler for controllable process.", (Throwable)e);
        }
        finally {
            try {
                this.stopRequestFileWatchdog.stop();
            }
            catch (InterruptedException e) {
                logger.warn("Interrupted while stopping stop handler for controllable process.", (Throwable)e);
            }
            this.launcher.close();
        }
    }

    protected File getWorkingDir() {
        return this.workingDir;
    }

    private static void deleteFiles(File workingDir, ProcessType processType) {
        ControllableProcess.deleteFile(workingDir, processType.getStatusRequestFileName());
        ControllableProcess.deleteFile(workingDir, processType.getStatusFileName());
        ControllableProcess.deleteFile(workingDir, processType.getStopRequestFileName());
    }

    private static void deleteFile(File workingDir, String fileName) {
        File file = new File(workingDir, fileName);
        if (file.exists()) {
            file.delete();
        }
    }
}

