/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.offheap;

import java.lang.reflect.Method;
import org.apache.geode.StatisticDescriptor;
import org.apache.geode.Statistics;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.StatisticsType;
import org.apache.geode.StatisticsTypeFactory;
import org.apache.geode.cache.CacheException;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.offheap.DisconnectingOutOfOffHeapMemoryListener;
import org.apache.geode.internal.offheap.MemoryAllocator;
import org.apache.geode.internal.offheap.MemoryAllocatorImpl;
import org.apache.geode.internal.offheap.OffHeapMemoryStats;
import org.apache.geode.internal.offheap.OutOfOffHeapMemoryListener;
import org.apache.geode.internal.statistics.StatisticsTypeFactoryImpl;

public class OffHeapStorage
implements OffHeapMemoryStats {
    public static final String STAY_CONNECTED_ON_OUTOFOFFHEAPMEMORY_PROPERTY = "gemfire.offheap.stayConnectedOnOutOfOffHeapMemory";
    private static final StatisticsType statsType;
    private static final String statsTypeName = "OffHeapMemoryStats";
    private static final String statsTypeDescription = "Statistics about off-heap memory storage.";
    private static final String statsName = "offHeapMemoryStats";
    private static final int freeMemoryId;
    private static final int maxMemoryId;
    private static final int usedMemoryId;
    private static final int objectsId;
    private static final int readsId;
    private static final int defragmentationId;
    private static final int fragmentsId;
    private static final int largestFragmentId;
    private static final int defragmentationTimeId;
    private static final int fragmentationId;
    private static final int defragmentationsInProgressId;
    private static final long MAX_SLAB_SIZE = Integer.MAX_VALUE;
    static final long MIN_SLAB_SIZE = 1024L;
    private final Statistics stats;

    public static long parseOffHeapMemorySize(String value) {
        long parsed = OffHeapStorage.parseLongWithUnits(value, 0L, 0x100000);
        if (parsed < 0L) {
            return 0L;
        }
        return parsed;
    }

    public static long calcMaxSlabSize(long offHeapMemorySize) {
        String offHeapSlabConfig = System.getProperty("gemfire.OFF_HEAP_SLAB_SIZE");
        long result = 0L;
        if (offHeapSlabConfig != null && !offHeapSlabConfig.equals("")) {
            result = OffHeapStorage.parseLongWithUnits(offHeapSlabConfig, Integer.MAX_VALUE, 0x100000);
            if (result > offHeapMemorySize) {
                result = offHeapMemorySize;
            }
        } else {
            result = offHeapMemorySize < Integer.MAX_VALUE ? offHeapMemorySize : Integer.MAX_VALUE;
        }
        assert (result > 0L && result <= Integer.MAX_VALUE && result <= offHeapMemorySize);
        return result;
    }

    private static void validateVmCompatibility() {
        try {
            Class<?> klass = ClassPathLoader.getLatest().forName("sun.misc.Unsafe");
            Method method = klass.getMethod("copyMemory", Object.class, Long.TYPE, Object.class, Long.TYPE, Long.TYPE);
        }
        catch (ClassNotFoundException e) {
            throw new CacheException(LocalizedStrings.MEMSCALE_JVM_INCOMPATIBLE_WITH_OFF_HEAP.toLocalizedString("product"), e){};
        }
        catch (NoSuchMethodException e) {
            throw new CacheException(LocalizedStrings.MEMSCALE_JVM_INCOMPATIBLE_WITH_OFF_HEAP.toLocalizedString("product"), e){};
        }
    }

    public static MemoryAllocator createOffHeapStorage(StatisticsFactory sf, long offHeapMemorySize, DistributedSystem system) {
        if (offHeapMemorySize == 0L || Boolean.getBoolean("Locator.forceLocatorDMType")) {
            return null;
        }
        if (offHeapMemorySize < 1024L) {
            throw new IllegalArgumentException("The amount of off heap memory must be at least 1024 but it was set to " + offHeapMemorySize);
        }
        OffHeapStorage.validateVmCompatibility();
        if (system == null) {
            throw new IllegalArgumentException("InternalDistributedSystem is null");
        }
        DisconnectingOutOfOffHeapMemoryListener ooohml = new DisconnectingOutOfOffHeapMemoryListener((InternalDistributedSystem)system);
        return OffHeapStorage.basicCreateOffHeapStorage(sf, offHeapMemorySize, ooohml);
    }

    static MemoryAllocator basicCreateOffHeapStorage(StatisticsFactory sf, long offHeapMemorySize, OutOfOffHeapMemoryListener ooohml) {
        OffHeapStorage stats = new OffHeapStorage(sf);
        long maxSlabSize = OffHeapStorage.calcMaxSlabSize(offHeapMemorySize);
        int slabCount = OffHeapStorage.calcSlabCount(maxSlabSize, offHeapMemorySize);
        return MemoryAllocatorImpl.create(ooohml, stats, slabCount, offHeapMemorySize, maxSlabSize);
    }

    static int calcSlabCount(long maxSlabSize, long offHeapMemorySize) {
        long result = offHeapMemorySize / maxSlabSize;
        if (offHeapMemorySize % maxSlabSize >= 1024L) {
            ++result;
        }
        if (result > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("The number of slabs of off heap memory exceeded the limit of 2147483647. Decrease the amount of off heap memory or increase the maximum slab size using gemfire.OFF_HEAP_SLAB_SIZE.");
        }
        return (int)result;
    }

    private static long parseLongWithUnits(String v, long defaultValue, int defaultMultiplier) {
        if (v == null || v.equals("")) {
            return defaultValue;
        }
        int unitMultiplier = defaultMultiplier;
        if (v.toLowerCase().endsWith("g")) {
            unitMultiplier = 0x40000000;
            v = v.substring(0, v.length() - 1);
        } else if (v.toLowerCase().endsWith("m")) {
            unitMultiplier = 0x100000;
            v = v.substring(0, v.length() - 1);
        }
        try {
            long result = Long.parseLong(v);
            return result *= (long)unitMultiplier;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Memory size must be specified as <n>[g|m], where <n> is the size and [g|m] specifies the units in gigabytes or megabytes.");
        }
    }

    private OffHeapStorage(StatisticsFactory f) {
        this.stats = f.createAtomicStatistics(statsType, statsName);
    }

    @Override
    public void incFreeMemory(long value) {
        this.stats.incLong(freeMemoryId, value);
    }

    @Override
    public void incMaxMemory(long value) {
        this.stats.incLong(maxMemoryId, value);
    }

    @Override
    public void incUsedMemory(long value) {
        this.stats.incLong(usedMemoryId, value);
    }

    @Override
    public void incObjects(int value) {
        this.stats.incInt(objectsId, value);
    }

    @Override
    public long getFreeMemory() {
        return this.stats.getLong(freeMemoryId);
    }

    @Override
    public long getMaxMemory() {
        return this.stats.getLong(maxMemoryId);
    }

    @Override
    public long getUsedMemory() {
        return this.stats.getLong(usedMemoryId);
    }

    @Override
    public int getObjects() {
        return this.stats.getInt(objectsId);
    }

    @Override
    public void incReads() {
        this.stats.incLong(readsId, 1L);
    }

    @Override
    public long getReads() {
        return this.stats.getLong(readsId);
    }

    private void incDefragmentations() {
        this.stats.incInt(defragmentationId, 1);
    }

    @Override
    public int getDefragmentations() {
        return this.stats.getInt(defragmentationId);
    }

    @Override
    public void setFragments(long value) {
        this.stats.setLong(fragmentsId, value);
    }

    @Override
    public long getFragments() {
        return this.stats.getLong(fragmentsId);
    }

    @Override
    public void setLargestFragment(int value) {
        this.stats.setInt(largestFragmentId, value);
    }

    @Override
    public int getLargestFragment() {
        return this.stats.getInt(largestFragmentId);
    }

    @Override
    public int getDefragmentationsInProgress() {
        return this.stats.getInt(defragmentationsInProgressId);
    }

    @Override
    public long startDefragmentation() {
        this.stats.incInt(defragmentationsInProgressId, 1);
        return DistributionStats.getStatTime();
    }

    @Override
    public void endDefragmentation(long start) {
        this.incDefragmentations();
        this.stats.incInt(defragmentationsInProgressId, -1);
        if (DistributionStats.enableClockStats) {
            this.stats.incLong(defragmentationTimeId, DistributionStats.getStatTime() - start);
        }
    }

    @Override
    public long getDefragmentationTime() {
        return this.stats.getLong(defragmentationTimeId);
    }

    @Override
    public void setFragmentation(int value) {
        this.stats.setInt(fragmentationId, value);
    }

    @Override
    public int getFragmentation() {
        return this.stats.getInt(fragmentationId);
    }

    @Override
    public Statistics getStats() {
        return this.stats;
    }

    @Override
    public void close() {
        this.stats.close();
    }

    @Override
    public void initialize(OffHeapMemoryStats oldStats) {
        this.setFreeMemory(oldStats.getFreeMemory());
        this.setMaxMemory(oldStats.getMaxMemory());
        this.setUsedMemory(oldStats.getUsedMemory());
        this.setObjects(oldStats.getObjects());
        this.setReads(oldStats.getReads());
        this.setDefragmentations(oldStats.getDefragmentations());
        this.setDefragmentationsInProgress(oldStats.getDefragmentationsInProgress());
        this.setFragments(oldStats.getFragments());
        this.setLargestFragment(oldStats.getLargestFragment());
        this.setDefragmentationTime(oldStats.getDefragmentationTime());
        this.setFragmentation(oldStats.getFragmentation());
        oldStats.close();
    }

    private void setDefragmentationTime(long value) {
        this.stats.setLong(defragmentationTimeId, value);
    }

    private void setDefragmentations(int value) {
        this.stats.setInt(defragmentationId, value);
    }

    private void setDefragmentationsInProgress(int value) {
        this.stats.setInt(defragmentationsInProgressId, value);
    }

    private void setReads(long value) {
        this.stats.setLong(readsId, value);
    }

    private void setObjects(int value) {
        this.stats.setInt(objectsId, value);
    }

    private void setUsedMemory(long value) {
        this.stats.setLong(usedMemoryId, value);
    }

    private void setMaxMemory(long value) {
        this.stats.setLong(maxMemoryId, value);
    }

    private void setFreeMemory(long value) {
        this.stats.setLong(freeMemoryId, value);
    }

    static {
        StatisticsTypeFactory f = StatisticsTypeFactoryImpl.singleton();
        String usedMemoryDesc = "The amount of off-heap memory, in bytes, that is being used to store data.";
        String defragmentationDesc = "The total number of times off-heap memory has been defragmented.";
        String defragmentationsInProgressDesc = "Current number of defragment operations currently in progress.";
        String defragmentationTimeDesc = "The total time spent defragmenting off-heap memory.";
        String fragmentationDesc = "The percentage of off-heap free memory that is fragmented.  Updated every time a defragmentation is performed.";
        String fragmentsDesc = "The number of fragments of free off-heap memory. Updated every time a defragmentation is done.";
        String freeMemoryDesc = "The amount of off-heap memory, in bytes, that is not being used.";
        String largestFragmentDesc = "The largest fragment of memory found by the last defragmentation of off heap memory. Updated every time a defragmentation is done.";
        String objectsDesc = "The number of objects stored in off-heap memory.";
        String readsDesc = "The total number of reads of off-heap memory. Only reads of a full object increment this statistic. If only a part of the object is read this statistic is not incremented.";
        String maxMemoryDesc = "The maximum amount of off-heap memory, in bytes. This is the amount of memory allocated at startup and does not change.";
        String usedMemory = "usedMemory";
        String defragmentations = "defragmentations";
        String defragmentationsInProgress = "defragmentationsInProgress";
        String defragmentationTime = "defragmentationTime";
        String fragmentation = "fragmentation";
        String fragments = "fragments";
        String freeMemory = "freeMemory";
        String largestFragment = "largestFragment";
        String objects = "objects";
        String reads = "reads";
        String maxMemory = "maxMemory";
        statsType = f.createType(statsTypeName, statsTypeDescription, new StatisticDescriptor[]{f.createLongGauge("usedMemory", "The amount of off-heap memory, in bytes, that is being used to store data.", "bytes"), f.createIntCounter("defragmentations", "The total number of times off-heap memory has been defragmented.", "operations"), f.createIntGauge("defragmentationsInProgress", "Current number of defragment operations currently in progress.", "operations"), f.createLongCounter("defragmentationTime", "The total time spent defragmenting off-heap memory.", "nanoseconds", false), f.createIntGauge("fragmentation", "The percentage of off-heap free memory that is fragmented.  Updated every time a defragmentation is performed.", "percentage"), f.createLongGauge("fragments", "The number of fragments of free off-heap memory. Updated every time a defragmentation is done.", "fragments"), f.createLongGauge("freeMemory", "The amount of off-heap memory, in bytes, that is not being used.", "bytes"), f.createIntGauge("largestFragment", "The largest fragment of memory found by the last defragmentation of off heap memory. Updated every time a defragmentation is done.", "bytes"), f.createIntGauge("objects", "The number of objects stored in off-heap memory.", "objects"), f.createLongCounter("reads", "The total number of reads of off-heap memory. Only reads of a full object increment this statistic. If only a part of the object is read this statistic is not incremented.", "operations"), f.createLongGauge("maxMemory", "The maximum amount of off-heap memory, in bytes. This is the amount of memory allocated at startup and does not change.", "bytes")});
        usedMemoryId = statsType.nameToId("usedMemory");
        defragmentationId = statsType.nameToId("defragmentations");
        defragmentationsInProgressId = statsType.nameToId("defragmentationsInProgress");
        defragmentationTimeId = statsType.nameToId("defragmentationTime");
        fragmentationId = statsType.nameToId("fragmentation");
        fragmentsId = statsType.nameToId("fragments");
        freeMemoryId = statsType.nameToId("freeMemory");
        largestFragmentId = statsType.nameToId("largestFragment");
        objectsId = statsType.nameToId("objects");
        readsId = statsType.nameToId("reads");
        maxMemoryId = statsType.nameToId("maxMemory");
    }
}

