/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.net;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.GemFireConfigException;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.internal.admin.SSLConfig;
import org.apache.geode.internal.security.SecurableCommunicationChannel;

public class SSLConfigurationFactory {
    private static SSLConfigurationFactory instance = new SSLConfigurationFactory();
    private DistributionConfig distributionConfig = null;
    private Map<SecurableCommunicationChannel, SSLConfig> registeredSSLConfig = new HashMap<SecurableCommunicationChannel, SSLConfig>();

    private SSLConfigurationFactory() {
    }

    private static synchronized SSLConfigurationFactory getInstance() {
        if (instance == null) {
            instance = new SSLConfigurationFactory();
        }
        return instance;
    }

    private DistributionConfig getDistributionConfig() {
        if (this.distributionConfig == null) {
            throw new GemFireConfigException("SSL Configuration requires a valid distribution config.");
        }
        return this.distributionConfig;
    }

    public static void setDistributionConfig(DistributionConfig distributionConfig) {
        if (distributionConfig == null) {
            throw new GemFireConfigException("SSL Configuration requires a valid distribution config.");
        }
        SSLConfigurationFactory.getInstance().distributionConfig = distributionConfig;
    }

    public static SSLConfig getSSLConfigForComponent(SecurableCommunicationChannel sslEnabledComponent) {
        SSLConfig sslConfig = SSLConfigurationFactory.getInstance().getRegisteredSSLConfigForComponent(sslEnabledComponent);
        if (sslConfig == null) {
            sslConfig = SSLConfigurationFactory.getInstance().createSSLConfigForComponent(sslEnabledComponent);
            SSLConfigurationFactory.getInstance().registeredSSLConfigForComponent(sslEnabledComponent, sslConfig);
        }
        return sslConfig;
    }

    private synchronized void registeredSSLConfigForComponent(SecurableCommunicationChannel sslEnabledComponent, SSLConfig sslConfig) {
        this.registeredSSLConfig.put(sslEnabledComponent, sslConfig);
    }

    private SSLConfig createSSLConfigForComponent(SecurableCommunicationChannel sslEnabledComponent) {
        SSLConfig sslConfig = this.createSSLConfig(sslEnabledComponent);
        SecurableCommunicationChannel[] sslEnabledComponents = this.getDistributionConfig().getSecurableCommunicationChannels();
        if (sslEnabledComponents.length == 0) {
            sslConfig = this.configureLegacyClusterSSL(sslConfig);
        }
        sslConfig.setSecurableCommunicationChannel(sslEnabledComponent);
        switch (sslEnabledComponent) {
            case ALL: {
                this.createSSLConfigForComponent(SecurableCommunicationChannel.WEB);
                break;
            }
            case CLUSTER: {
                if (sslEnabledComponents.length > 0) {
                    sslConfig = this.setAliasForComponent(sslConfig, this.getDistributionConfig().getClusterSSLAlias());
                    break;
                }
                sslConfig = this.configureLegacyClusterSSL(sslConfig);
                break;
            }
            case LOCATOR: {
                if (sslEnabledComponents.length <= 0) break;
                sslConfig = this.setAliasForComponent(sslConfig, this.getDistributionConfig().getLocatorSSLAlias());
                break;
            }
            case SERVER: {
                if (sslEnabledComponents.length > 0) {
                    sslConfig = this.setAliasForComponent(sslConfig, this.getDistributionConfig().getServerSSLAlias());
                    break;
                }
                sslConfig = this.configureLegacyServerSSL(sslConfig);
                break;
            }
            case GATEWAY: {
                if (sslEnabledComponents.length > 0) {
                    sslConfig = this.setAliasForComponent(sslConfig, this.getDistributionConfig().getGatewaySSLAlias());
                    break;
                }
                sslConfig = this.configureLegacyGatewaySSL(sslConfig);
                break;
            }
            case WEB: {
                if (sslEnabledComponents.length > 0) {
                    sslConfig = this.setAliasForComponent(sslConfig, this.getDistributionConfig().getHTTPServiceSSLAlias());
                    sslConfig.setRequireAuth(this.getDistributionConfig().getSSLWebRequireAuthentication());
                    break;
                }
                sslConfig = this.configureLegacyHttpServiceSSL(sslConfig);
                break;
            }
            case JMX: {
                sslConfig = sslEnabledComponents.length > 0 ? this.setAliasForComponent(sslConfig, this.getDistributionConfig().getJMXSSLAlias()) : this.configureLegacyJMXSSL(sslConfig);
            }
        }
        this.configureSSLPropertiesFromSystemProperties(sslConfig);
        return sslConfig;
    }

    private SSLConfig setAliasForComponent(SSLConfig sslConfig, String clusterSSLAlias) {
        if (!StringUtils.isEmpty((String)clusterSSLAlias)) {
            sslConfig.setAlias(clusterSSLAlias);
        }
        return sslConfig;
    }

    private SSLConfig createSSLConfig(SecurableCommunicationChannel sslEnabledComponent) {
        SSLConfig sslConfig = new SSLConfig();
        sslConfig.setCiphers(this.getDistributionConfig().getSSLCiphers());
        sslConfig.setEnabled(this.determineIfSSLEnabledForSSLComponent(sslEnabledComponent));
        sslConfig.setKeystore(this.getDistributionConfig().getSSLKeyStore());
        sslConfig.setKeystorePassword(this.getDistributionConfig().getSSLKeyStorePassword());
        sslConfig.setKeystoreType(this.getDistributionConfig().getSSLKeyStoreType());
        sslConfig.setTruststore(this.getDistributionConfig().getSSLTrustStore());
        sslConfig.setTruststorePassword(this.getDistributionConfig().getSSLTrustStorePassword());
        sslConfig.setProtocols(this.getDistributionConfig().getSSLProtocols());
        sslConfig.setRequireAuth(this.getDistributionConfig().getSSLRequireAuthentication());
        sslConfig.setAlias(this.getDistributionConfig().getSSLDefaultAlias());
        return sslConfig;
    }

    private boolean determineIfSSLEnabledForSSLComponent(SecurableCommunicationChannel sslEnabledComponent) {
        if (ArrayUtils.contains((Object[])this.getDistributionConfig().getSecurableCommunicationChannels(), (Object)((Object)SecurableCommunicationChannel.NONE))) {
            return false;
        }
        if (ArrayUtils.contains((Object[])this.getDistributionConfig().getSecurableCommunicationChannels(), (Object)((Object)SecurableCommunicationChannel.ALL))) {
            return true;
        }
        return ArrayUtils.contains((Object[])this.getDistributionConfig().getSecurableCommunicationChannels(), (Object)((Object)sslEnabledComponent));
    }

    private SSLConfig configureLegacyClusterSSL(SSLConfig sslConfig) {
        sslConfig.setCiphers(this.getDistributionConfig().getClusterSSLCiphers());
        sslConfig.setEnabled(this.getDistributionConfig().getClusterSSLEnabled());
        sslConfig.setKeystore(this.getDistributionConfig().getClusterSSLKeyStore());
        sslConfig.setKeystorePassword(this.getDistributionConfig().getClusterSSLKeyStorePassword());
        sslConfig.setKeystoreType(this.getDistributionConfig().getClusterSSLKeyStoreType());
        sslConfig.setTruststore(this.getDistributionConfig().getClusterSSLTrustStore());
        sslConfig.setTruststorePassword(this.getDistributionConfig().getClusterSSLTrustStorePassword());
        sslConfig.setProtocols(this.getDistributionConfig().getClusterSSLProtocols());
        sslConfig.setRequireAuth(this.getDistributionConfig().getClusterSSLRequireAuthentication());
        return sslConfig;
    }

    private SSLConfig configureLegacyServerSSL(SSLConfig sslConfig) {
        sslConfig.setCiphers(this.getDistributionConfig().getServerSSLCiphers());
        sslConfig.setEnabled(this.getDistributionConfig().getServerSSLEnabled());
        sslConfig.setKeystore(this.getDistributionConfig().getServerSSLKeyStore());
        sslConfig.setKeystorePassword(this.getDistributionConfig().getServerSSLKeyStorePassword());
        sslConfig.setKeystoreType(this.getDistributionConfig().getServerSSLKeyStoreType());
        sslConfig.setTruststore(this.getDistributionConfig().getServerSSLTrustStore());
        sslConfig.setTruststorePassword(this.getDistributionConfig().getServerSSLTrustStorePassword());
        sslConfig.setProtocols(this.getDistributionConfig().getServerSSLProtocols());
        sslConfig.setRequireAuth(this.getDistributionConfig().getServerSSLRequireAuthentication());
        return sslConfig;
    }

    private SSLConfig configureLegacyJMXSSL(SSLConfig sslConfig) {
        sslConfig.setCiphers(this.getDistributionConfig().getJmxManagerSSLCiphers());
        sslConfig.setEnabled(this.getDistributionConfig().getJmxManagerSSLEnabled());
        sslConfig.setKeystore(this.getDistributionConfig().getJmxManagerSSLKeyStore());
        sslConfig.setKeystorePassword(this.getDistributionConfig().getJmxManagerSSLKeyStorePassword());
        sslConfig.setKeystoreType(this.getDistributionConfig().getJmxManagerSSLKeyStoreType());
        sslConfig.setTruststore(this.getDistributionConfig().getJmxManagerSSLTrustStore());
        sslConfig.setTruststorePassword(this.getDistributionConfig().getJmxManagerSSLTrustStorePassword());
        sslConfig.setProtocols(this.getDistributionConfig().getJmxManagerSSLProtocols());
        sslConfig.setRequireAuth(this.getDistributionConfig().getJmxManagerSSLRequireAuthentication());
        return sslConfig;
    }

    private SSLConfig configureLegacyGatewaySSL(SSLConfig sslConfig) {
        sslConfig.setCiphers(this.getDistributionConfig().getGatewaySSLCiphers());
        sslConfig.setEnabled(this.getDistributionConfig().getGatewaySSLEnabled());
        sslConfig.setKeystore(this.getDistributionConfig().getGatewaySSLKeyStore());
        sslConfig.setKeystorePassword(this.getDistributionConfig().getGatewaySSLKeyStorePassword());
        sslConfig.setKeystoreType(this.getDistributionConfig().getGatewaySSLKeyStoreType());
        sslConfig.setTruststore(this.getDistributionConfig().getGatewaySSLTrustStore());
        sslConfig.setTruststorePassword(this.getDistributionConfig().getGatewaySSLTrustStorePassword());
        sslConfig.setProtocols(this.getDistributionConfig().getGatewaySSLProtocols());
        sslConfig.setRequireAuth(this.getDistributionConfig().getGatewaySSLRequireAuthentication());
        return sslConfig;
    }

    private SSLConfig configureLegacyHttpServiceSSL(SSLConfig sslConfig) {
        sslConfig.setCiphers(this.getDistributionConfig().getHttpServiceSSLCiphers());
        sslConfig.setEnabled(this.getDistributionConfig().getHttpServiceSSLEnabled());
        sslConfig.setKeystore(this.getDistributionConfig().getHttpServiceSSLKeyStore());
        sslConfig.setKeystorePassword(this.getDistributionConfig().getHttpServiceSSLKeyStorePassword());
        sslConfig.setKeystoreType(this.getDistributionConfig().getHttpServiceSSLKeyStoreType());
        sslConfig.setTruststore(this.getDistributionConfig().getHttpServiceSSLTrustStore());
        sslConfig.setTruststorePassword(this.getDistributionConfig().getHttpServiceSSLTrustStorePassword());
        sslConfig.setProtocols(this.getDistributionConfig().getHttpServiceSSLProtocols());
        sslConfig.setRequireAuth(this.getDistributionConfig().getHttpServiceSSLRequireAuthentication());
        return sslConfig;
    }

    private SSLConfig configureSSLPropertiesFromSystemProperties(SSLConfig sslConfig) {
        return this.configureSSLPropertiesFromSystemProperties(sslConfig, null);
    }

    private SSLConfig configureSSLPropertiesFromSystemProperties(SSLConfig sslConfig, Properties properties) {
        if (StringUtils.isEmpty((String)sslConfig.getKeystore())) {
            sslConfig.setKeystore(this.getValueFromSystemProperties(properties, "javax.net.ssl.keyStore"));
        }
        if (StringUtils.isEmpty((String)sslConfig.getKeystoreType())) {
            sslConfig.setKeystoreType(this.getValueFromSystemProperties(properties, "javax.net.ssl.keyStoreType"));
        }
        if (StringUtils.isEmpty((String)sslConfig.getKeystorePassword())) {
            sslConfig.setKeystorePassword(this.getValueFromSystemProperties(properties, "javax.net.ssl.keyStorePassword"));
        }
        if (StringUtils.isEmpty((String)sslConfig.getTruststore())) {
            sslConfig.setTruststore(this.getValueFromSystemProperties(properties, "javax.net.ssl.trustStore"));
        }
        if (StringUtils.isEmpty((String)sslConfig.getTruststorePassword())) {
            sslConfig.setTruststorePassword(this.getValueFromSystemProperties(properties, "javax.net.ssl.trustStorePassword"));
        }
        if (StringUtils.isEmpty((String)sslConfig.getTruststoreType())) {
            sslConfig.setTruststoreType(this.getValueFromSystemProperties(properties, "javax.net.ssl.trustStoreType"));
        }
        return sslConfig;
    }

    private String getValueFromSystemProperties(Properties properties, String property) {
        String propertyValue = null;
        if (properties != null) {
            propertyValue = properties.getProperty(property);
        }
        if (property != null && (propertyValue = System.getProperty(property)) != null && propertyValue.trim().equals("")) {
            propertyValue = System.getenv(property);
        }
        return propertyValue;
    }

    private SSLConfig getRegisteredSSLConfigForComponent(SecurableCommunicationChannel sslEnabledComponent) {
        return this.registeredSSLConfig.get((Object)sslEnabledComponent);
    }

    public static void close() {
        SSLConfigurationFactory.getInstance().clearSSLConfigForAllComponents();
        SSLConfigurationFactory.getInstance().distributionConfig = null;
    }

    private void clearSSLConfigForAllComponents() {
        this.registeredSSLConfig.clear();
    }

    @Deprecated
    public static SSLConfig getSSLConfigForComponent(boolean useSSL, boolean needClientAuth, String protocols, String ciphers, Properties gfsecurityProps, String alias) {
        SSLConfig sslConfig = new SSLConfig();
        sslConfig.setAlias(alias);
        sslConfig.setCiphers(ciphers);
        sslConfig.setProtocols(protocols);
        sslConfig.setRequireAuth(needClientAuth);
        sslConfig.setEnabled(useSSL);
        sslConfig = SSLConfigurationFactory.getInstance().configureSSLPropertiesFromSystemProperties(sslConfig, gfsecurityProps);
        return sslConfig;
    }
}

