/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.logging.log4j;

import org.apache.geode.i18n.StringId;
import org.apache.logging.log4j.message.Message;

public final class LocalizedMessage
implements Message {
    private static final long serialVersionUID = -8893339995741536401L;
    private final StringId stringId;
    private final Object[] params;
    private final Throwable throwable;

    private LocalizedMessage(StringId stringId, Object[] params, Throwable throwable) {
        this.stringId = stringId;
        this.params = params;
        this.throwable = throwable;
    }

    public static LocalizedMessage create(StringId stringId) {
        return new LocalizedMessage(stringId, null, null);
    }

    public static final LocalizedMessage create(StringId stringId, Object[] params) {
        return new LocalizedMessage(stringId, params, null);
    }

    public static final LocalizedMessage create(StringId stringId, Throwable throwable) {
        return new LocalizedMessage(stringId, null, throwable);
    }

    public static final LocalizedMessage create(StringId stringId, Object object) {
        return new LocalizedMessage(stringId, new Object[]{object}, null);
    }

    public static final LocalizedMessage create(StringId stringId, Object[] params, Throwable throwable) {
        return new LocalizedMessage(stringId, params, throwable);
    }

    public String getFormattedMessage() {
        return this.stringId.toLocalizedString(this.params);
    }

    public String getFormat() {
        return this.stringId.getRawText();
    }

    public Object[] getParameters() {
        return this.params;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }
}

