/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.jta;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import org.apache.geode.i18n.LogWriterI18n;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.jta.GlobalTransaction;
import org.apache.geode.internal.jta.TransactionManagerImpl;
import org.apache.geode.internal.jta.TransactionUtils;

public class TransactionImpl
implements Transaction {
    private GlobalTransaction gtx = null;
    private Synchronization sync = null;
    private TransactionManagerImpl tm = TransactionManagerImpl.getTransactionManager();
    private List syncList = new ArrayList();

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException {
        this.tm.commit();
    }

    public void rollback() throws IllegalStateException, SystemException {
        this.tm.rollback();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.gtx = this.tm.getGlobalTransaction();
        if (this.gtx == null) {
            String exception = LocalizedStrings.TransactionImpl_TRANSACTIONIMPL_SETROLLBACKONLY_NO_GLOBAL_TRANSACTION_EXISTS.toLocalizedString();
            LogWriterI18n writer = TransactionUtils.getLogWriterI18n();
            if (writer.fineEnabled()) {
                writer.fine(exception);
            }
            throw new SystemException(exception);
        }
        this.gtx.setRollbackOnly();
    }

    public int getStatus() throws SystemException {
        this.gtx = this.tm.getGlobalTransaction();
        if (this.gtx == null) {
            return 6;
        }
        return this.gtx.getStatus();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        String exception = LocalizedStrings.TransactionImpl_SETTRANSACTIONTIMEOUT_IS_NOT_SUPPORTED.toLocalizedString();
        LogWriterI18n writer = TransactionUtils.getLogWriterI18n();
        if (writer.fineEnabled()) {
            writer.fine(exception);
        }
        throw new SystemException(exception);
    }

    public boolean enlistResource(XAResource xaRes) throws RollbackException, IllegalStateException, SystemException {
        this.gtx = this.tm.getGlobalTransaction();
        if (this.gtx == null) {
            String exception = LocalizedStrings.TransactionImpl_TRANSACTIONIMPL_ENLISTRESOURCE_NO_GLOBAL_TRANSACTION_EXISTS.toLocalizedString();
            LogWriterI18n writer = TransactionUtils.getLogWriterI18n();
            if (writer.fineEnabled()) {
                writer.fine(exception);
            }
            throw new SystemException(exception);
        }
        return this.gtx.enlistResource(xaRes);
    }

    public boolean delistResource(XAResource xaRes, int flag) throws IllegalStateException, SystemException {
        this.gtx = this.tm.getGlobalTransaction();
        if (this.gtx == null) {
            String exception = LocalizedStrings.TransactionImpl_TRANSACTIONIMPL_DELISTRESOURCE_NO_GLOBAL_TRANSACTION_EXISTS.toLocalizedString();
            LogWriterI18n writer = TransactionUtils.getLogWriterI18n();
            if (writer.fineEnabled()) {
                writer.fine(exception);
            }
            throw new SystemException(exception);
        }
        return this.gtx.delistResource(xaRes, flag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSynchronization(Synchronization synchronisation) throws SystemException, IllegalStateException, RollbackException {
        LogWriterI18n writer = TransactionUtils.getLogWriterI18n();
        if (writer.fineEnabled()) {
            writer.fine("registering JTA synchronization: " + synchronisation);
        }
        if (synchronisation == null) {
            throw new SystemException(LocalizedStrings.TransactionImpl_TRANSACTIONIMPLREGISTERSYNCHRONIZATIONSYNCHRONIZATION_IS_NULL.toLocalizedString());
        }
        this.gtx = this.tm.getGlobalTransaction();
        if (this.gtx == null) {
            throw new SystemException(LocalizedStrings.TransactionManagerImpl_NO_TRANSACTION_PRESENT.toLocalizedString());
        }
        GlobalTransaction globalTransaction = this.gtx;
        synchronized (globalTransaction) {
            int status = -1;
            status = this.gtx.getStatus();
            if (status == 1) {
                String exception = LocalizedStrings.TransactionImpl_TRANSACTIONIMPL_REGISTERSYNCHRONIZATION_SYNCHRONIZATION_CANNOT_BE_REGISTERED_BECAUSE_THE_TRANSACTION_HAS_BEEN_MARKED_FOR_ROLLBACK.toLocalizedString();
                LogWriterI18n writer2 = TransactionUtils.getLogWriterI18n();
                if (writer2.fineEnabled()) {
                    writer2.fine(exception);
                }
                throw new RollbackException(exception);
            }
            if (status != 0) {
                String exception = LocalizedStrings.TransactionImpl_TRANSACTIONIMPL_REGISTERSYNCHRONIZATION_SYNCHRONIZATION_CANNOT_BE_REGISTERED_ON_A_TRANSACTION_WHICH_IS_NOT_ACTIVE.toLocalizedString();
                LogWriterI18n writer3 = TransactionUtils.getLogWriterI18n();
                if (writer3.fineEnabled()) {
                    writer3.fine(exception);
                }
                throw new IllegalStateException(exception);
            }
            this.syncList.add(synchronisation);
        }
    }

    boolean notifyBeforeCompletion() {
        Iterator iterator = this.syncList.iterator();
        boolean result = true;
        while (iterator.hasNext()) {
            this.sync = (Synchronization)iterator.next();
            this.sync.beforeCompletion();
        }
        return result;
    }

    void notifyAfterCompletion(int status) throws SystemException {
        for (Synchronization this.sync : this.syncList) {
            this.sync.afterCompletion(status);
        }
    }

    List getSyncList() {
        return this.syncList;
    }
}

