/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.xmlcache;

import java.io.File;
import java.io.Serializable;
import org.apache.geode.cache.DiskStore;
import org.apache.geode.internal.cache.DiskStoreAttributes;
import org.apache.geode.internal.cache.DiskStoreFactoryImpl;
import org.apache.geode.internal.cache.UserSpecifiedDiskStoreAttributes;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class DiskStoreAttributesCreation
extends UserSpecifiedDiskStoreAttributes
implements Serializable {
    public DiskStoreAttributesCreation() {
    }

    public DiskStoreAttributesCreation(DiskStoreAttributes attrs) {
        this.name = attrs.getName();
        this.autoCompact = attrs.getAutoCompact();
        this.compactionThreshold = attrs.getCompactionThreshold();
        this.allowForceCompaction = attrs.getAllowForceCompaction();
        this.maxOplogSizeInBytes = attrs.getMaxOplogSizeInBytes();
        this.timeInterval = attrs.getTimeInterval();
        this.writeBufferSize = attrs.getWriteBufferSize();
        this.queueSize = attrs.getQueueSize();
        this.diskDirs = attrs.getDiskDirs();
        this.diskDirSizes = attrs.getDiskDirSizes();
        this.setDiskUsageWarningPercentage(attrs.getDiskUsageWarningPercentage());
        this.setDiskUsageCriticalPercentage(attrs.getDiskUsageCriticalPercentage());
        if (attrs instanceof UserSpecifiedDiskStoreAttributes) {
            UserSpecifiedDiskStoreAttributes nonDefault = (UserSpecifiedDiskStoreAttributes)attrs;
            this.initHasFields(nonDefault);
        } else {
            this.setAllHasFields(true);
        }
    }

    static boolean equal(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    private boolean equal(long[] array1, long[] array2) {
        if (array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    private boolean equal(int[] array1, int[] array2) {
        if (array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    private boolean equal(File[] array1, File[] array2) {
        if (array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            boolean found = false;
            for (int j = 0; j < array2.length; ++j) {
                if (!DiskStoreAttributesCreation.equal(array1[i].getAbsoluteFile(), array2[j].getAbsoluteFile())) continue;
                found = true;
                break;
            }
            if (found) continue;
            StringBuffer sb = new StringBuffer();
            sb.append("Didn't find ");
            sb.append(array1[i]);
            sb.append(" in ");
            for (int k = 0; k < array2.length; ++k) {
                sb.append(array2[k]);
                sb.append(" ");
            }
            System.out.println(sb);
            return false;
        }
        return true;
    }

    public boolean sameAs(DiskStore other) {
        if (this.autoCompact != other.getAutoCompact()) {
            throw new RuntimeException(LocalizedStrings.DiskStoreAttributesCreation_AUTOCOMPACT_OF_0_IS_NOT_THE_SAME_THIS_1_OTHER_2.toLocalizedString(this.name, this.autoCompact, other.getAutoCompact()));
        }
        if (this.compactionThreshold != other.getCompactionThreshold()) {
            throw new RuntimeException(LocalizedStrings.DiskStoreAttributesCreation_COMPACTIONTHRESHOLD_OF_0_IS_NOT_THE_SAME_THIS_1_OTHER_2.toLocalizedString(this.name, this.compactionThreshold, other.getCompactionThreshold()));
        }
        if (this.allowForceCompaction != other.getAllowForceCompaction()) {
            throw new RuntimeException(LocalizedStrings.DiskStoreAttributesCreation_ALLOWFORCECOMPACTION_OF_0_IS_NOT_THE_SAME_THIS_1_OTHER_2.toLocalizedString(this.name, this.allowForceCompaction, other.getAllowForceCompaction()));
        }
        if (this.maxOplogSizeInBytes != other.getMaxOplogSize() * 1024L * 1024L) {
            throw new RuntimeException(LocalizedStrings.DiskStoreAttributesCreation_MAXOPLOGSIZE_OF_0_IS_NOT_THE_SAME_THIS_1_OTHER_2.toLocalizedString(this.name, this.maxOplogSizeInBytes / 1024L / 1024L, other.getMaxOplogSize()));
        }
        if (this.timeInterval != other.getTimeInterval()) {
            throw new RuntimeException(LocalizedStrings.DiskStoreAttributesCreation_TIMEINTERVAL_OF_0_IS_NOT_THE_SAME_THIS_1_OTHER_2.toLocalizedString(this.name, this.timeInterval, other.getTimeInterval()));
        }
        if (this.writeBufferSize != other.getWriteBufferSize()) {
            throw new RuntimeException(LocalizedStrings.DiskStoreAttributesCreation_WRITEBUFFERSIZE_OF_0_IS_NOT_THE_SAME_THIS_1_OTHER_2.toLocalizedString(this.name, this.writeBufferSize, other.getWriteBufferSize()));
        }
        if (this.queueSize != other.getQueueSize()) {
            throw new RuntimeException(LocalizedStrings.DiskStoreAttributesCreation_QUEUESIZE_OF_0_IS_NOT_THE_SAME_THIS_1_OTHER_2.toLocalizedString(this.name, this.queueSize, other.getQueueSize()));
        }
        if (!this.equal(this.diskDirs, other.getDiskDirs())) {
            throw new RuntimeException(LocalizedStrings.DiskStoreAttributesCreation_DISK_DIRS_OF_0_ARE_NOT_THE_SAME.toLocalizedString(this.name));
        }
        if (!this.equal(this.diskDirSizes, other.getDiskDirSizes())) {
            throw new RuntimeException(LocalizedStrings.DiskStoreAttributesCreation_DISK_DIR_SIZES_OF_0_ARE_NOT_THE_SAME.toLocalizedString(this.name));
        }
        if (!DiskStoreAttributesCreation.equal(Float.valueOf(this.getDiskUsageWarningPercentage()), Float.valueOf(other.getDiskUsageWarningPercentage()))) {
            throw new RuntimeException(LocalizedStrings.DiskStoreAttributesCreation_DISK_USAGE_WARN_ARE_NOT_THE_SAME.toLocalizedString(this.name));
        }
        if (!DiskStoreAttributesCreation.equal(Float.valueOf(this.getDiskUsageCriticalPercentage()), Float.valueOf(other.getDiskUsageCriticalPercentage()))) {
            throw new RuntimeException(LocalizedStrings.DiskStoreAttributesCreation_DISK_USAGE_CRITICAL_ARE_NOT_THE_SAME.toLocalizedString(this.name));
        }
        return true;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAutoCompact(boolean autoCompact) {
        this.autoCompact = autoCompact;
        this.setHasAutoCompact(true);
    }

    public void setCompactionThreshold(int compactionThreshold) {
        this.compactionThreshold = compactionThreshold;
        this.setHasCompactionThreshold(true);
    }

    public void setAllowForceCompaction(boolean allowForceCompaction) {
        this.allowForceCompaction = allowForceCompaction;
        this.setHasAllowForceCompaction(true);
    }

    public void setMaxOplogSize(long maxOplogSize) {
        this.maxOplogSizeInBytes = maxOplogSize * 1024L * 1024L;
        this.setHasMaxOplogSize(true);
    }

    public void setTimeInterval(long timeInterval) {
        this.timeInterval = timeInterval;
        this.setHasTimeInterval(true);
    }

    public void setWriteBufferSize(int writeBufferSize) {
        this.writeBufferSize = writeBufferSize;
        this.setHasWriteBufferSize(true);
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
        this.setHasQueueSize(true);
    }

    public void setDiskDirs(File[] diskDirs) {
        this.checkIfDirectoriesExist(diskDirs);
        this.diskDirs = diskDirs;
        this.diskDirSizes = new int[diskDirs.length];
        for (int i = 0; i < diskDirs.length; ++i) {
            this.diskDirSizes[i] = Integer.MAX_VALUE;
        }
        this.setHasDiskDirs(true);
    }

    public void setDiskDirsAndSize(File[] diskDirs, int[] sizes) {
        this.checkIfDirectoriesExist(diskDirs);
        this.diskDirs = diskDirs;
        if (sizes.length != this.diskDirs.length) {
            throw new IllegalArgumentException(LocalizedStrings.DiskStoreAttributesCreation_NUMBER_OF_DISKSIZES_IS_0_WHICH_IS_NOT_EQUAL_TO_NUMBER_OF_DISK_DIRS_WHICH_IS_1.toLocalizedString(sizes.length, diskDirs.length));
        }
        this.verifyNonNegativeDirSize(sizes);
        this.diskDirSizes = sizes;
        this.setHasDiskDirs(true);
    }

    @Override
    public void setDiskUsageWarningPercentage(float diskUsageWarningPercentage) {
        super.setDiskUsageWarningPercentage(diskUsageWarningPercentage);
        this.setHasDiskUsageWarningPercentage(true);
    }

    @Override
    public void setDiskUsageCriticalPercentage(float diskUsageCriticalPercentage) {
        super.setDiskUsageCriticalPercentage(diskUsageCriticalPercentage);
        this.setHasDiskUsageCriticalPercentage(true);
    }

    private void checkIfDirectoriesExist(File[] disk_dirs) {
        DiskStoreFactoryImpl.checkIfDirectoriesExist(disk_dirs);
    }

    private void verifyNonNegativeDirSize(int[] sizes) {
        for (int i = 0; i < sizes.length; ++i) {
            if (sizes[i] >= 0) continue;
            throw new IllegalArgumentException(LocalizedStrings.DiskStoreAttributesCreation_DIR_SIZE_CANNOT_BE_NEGATIVE_0_FOR_DISKSTORE_1.toLocalizedString(sizes[i], this.name));
        }
    }
}

