/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;

public class UpdateClientNotification
extends BaseCommand {
    private static final UpdateClientNotification singleton = new UpdateClientNotification();

    public static Command getCommand() {
        return singleton;
    }

    private UpdateClientNotification() {
    }

    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException {
        CacheServerStats stats = servConn.getCacheServerStats();
        long oldStart = start;
        start = DistributionStats.getStatTime();
        stats.incReadUpdateClientNotificationRequestTime(start - oldStart);
        oldStart = start;
        start = DistributionStats.getStatTime();
        stats.incProcessUpdateClientNotificationTime(start - oldStart);
    }
}

