/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.security.GemFireSecurityException;

public class RemoveUserAuth
extends BaseCommand {
    private static final RemoveUserAuth singleton = new RemoveUserAuth();

    public static Command getCommand() {
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException, ClassNotFoundException, InterruptedException {
        boolean isSecureMode = msg.isSecureMode();
        if (!isSecureMode) {
            return;
        }
        try {
            servConn.setAsTrue(2);
            Part keepalivePart = msg.getPart(0);
            byte[] keepaliveByte = keepalivePart.getSerializedForm();
            boolean keepalive = keepaliveByte != null && keepaliveByte[0] != 0;
            servConn.getSecurityLogWriter().fine("remove user auth keep alive " + keepalive);
            servConn.removeUserAuth(msg, keepalive);
            this.writeReply(msg, servConn);
        }
        catch (GemFireSecurityException gfse) {
            if (servConn.getSecurityLogWriter().warningEnabled()) {
                servConn.getSecurityLogWriter().warning(LocalizedStrings.ONE_ARG, servConn.getName() + ": Security exception: " + gfse.getMessage());
            }
            RemoveUserAuth.writeException(msg, gfse, false, servConn);
        }
        catch (Exception ex) {
            if (servConn.getLogWriter().warningEnabled()) {
                servConn.getLogWriter().warning(LocalizedStrings.CacheClientNotifier_AN_EXCEPTION_WAS_THROWN_FOR_CLIENT_0_1, new Object[]{servConn.getProxyID(), ""}, (Throwable)ex);
            }
            RemoveUserAuth.writeException(msg, ex, false, servConn);
        }
        finally {
            servConn.setAsTrue(1);
        }
    }
}

