/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import java.util.Set;
import org.apache.geode.cache.operations.QueryOperationContext;
import org.apache.geode.cache.query.QueryExecutionLowMemoryException;
import org.apache.geode.cache.query.QueryInvalidException;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.internal.DefaultQuery;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommandQuery;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.security.AuthorizeRequest;

public class Query
extends BaseCommandQuery {
    private static final Query singleton = new Query();

    public static Command getCommand() {
        return singleton;
    }

    private Query() {
    }

    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException, InterruptedException {
        servConn.setAsTrue(2);
        servConn.setAsTrue(3);
        String queryString = msg.getPart(0).getString();
        if (msg.getNumberOfParts() == 3) {
            int timeout = msg.getPart(2).getInt();
            servConn.setRequestSpecificTimeout(timeout);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received query request from {} queryString: {}", (Object)servConn.getName(), (Object)servConn.getSocketString(), (Object)queryString);
        }
        try {
            QueryService queryService = ((GemFireCacheImpl)servConn.getCachedRegionHelper().getCache()).getLocalQueryService();
            org.apache.geode.cache.query.Query query = queryService.newQuery(queryString);
            Set regionNames = ((DefaultQuery)query).getRegionsInQuery(null);
            QueryOperationContext queryContext = null;
            AuthorizeRequest authzRequest = servConn.getAuthzRequest();
            if (authzRequest != null) {
                queryContext = authzRequest.queryAuthorize(queryString, regionNames);
                String newQueryString = queryContext.getQuery();
                if (queryString != null && !queryString.equals(newQueryString)) {
                    query = queryService.newQuery(newQueryString);
                    queryString = newQueryString;
                    regionNames = queryContext.getRegionNames();
                    if (regionNames == null) {
                        regionNames = ((DefaultQuery)query).getRegionsInQuery(null);
                    }
                }
            }
            this.processQuery(msg, query, queryString, regionNames, start, null, queryContext, servConn, true);
        }
        catch (QueryInvalidException e) {
            throw new QueryInvalidException(e.getMessage() + queryString);
        }
        catch (QueryExecutionLowMemoryException e) {
            Query.writeQueryResponseException(msg, e, false, servConn);
        }
    }
}

