/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.internal.cache.tier.CachedRegionHelper;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.ClientHealthMonitor;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;

public class Ping
extends BaseCommand {
    private static final Ping singleton = new Ping();

    public static Command getCommand() {
        return singleton;
    }

    private Ping() {
    }

    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException {
        ClientHealthMonitor chm;
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (isDebugEnabled) {
            logger.debug("{}: rcv tx: {} from {} rcvTime: {}", (Object)servConn.getName(), (Object)msg.getTransactionId(), (Object)servConn.getSocketString(), (Object)(DistributionStats.getStatTime() - start));
        }
        if ((chm = ClientHealthMonitor.getInstance()) != null) {
            chm.receivedPing(servConn.getProxyID());
        }
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        this.writeReply(msg, servConn);
        servConn.setAsTrue(1);
        if (isDebugEnabled) {
            logger.debug("{}: Sent ping reply to {}", (Object)servConn.getName(), (Object)servConn.getSocketString());
        }
    }

    @Override
    protected void writeReply(Message origMsg, ServerConnection servConn) throws IOException {
        Message replyMsg = servConn.getReplyMessage();
        servConn.getCache().getCancelCriterion().checkCancelInProgress(null);
        replyMsg.setMessageType(6);
        replyMsg.setNumberOfParts(1);
        replyMsg.setTransactionId(origMsg.getTransactionId());
        replyMsg.addBytesPart(OK_BYTES);
        replyMsg.send(servConn);
        if (logger.isTraceEnabled()) {
            logger.trace("{}: rpl tx: {}", (Object)servConn.getName(), (Object)origMsg.getTransactionId());
        }
    }
}

