/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.cache.tier.sockets.command.Destroy65;
import org.apache.geode.internal.cache.versions.VersionTag;

public class Destroy70
extends Destroy65 {
    private static final Destroy70 singleton = new Destroy70();

    public static Command getCommand() {
        return singleton;
    }

    private Destroy70() {
    }

    @Override
    protected void writeReplyWithRefreshMetadata(Message origMsg, ServerConnection servConn, PartitionedRegion pr, boolean entryNotFoundForRemove, byte nwHop, VersionTag versionTag) throws IOException {
        Message replyMsg = servConn.getReplyMessage();
        servConn.getCache().getCancelCriterion().checkCancelInProgress(null);
        replyMsg.setMessageType(6);
        int flags = 0;
        int numParts = 3;
        if (versionTag != null) {
            flags |= 1;
            ++numParts;
        }
        replyMsg.setNumberOfParts(numParts);
        replyMsg.setTransactionId(origMsg.getTransactionId());
        replyMsg.addIntPart(flags |= 2);
        if (versionTag != null) {
            replyMsg.addObjPart(versionTag);
        }
        replyMsg.addBytesPart(new byte[]{pr.getMetadataVersion(), nwHop});
        replyMsg.addIntPart(entryNotFoundForRemove ? 1 : 0);
        pr.getPrStats().incPRMetaDataSentCount();
        replyMsg.send(servConn);
        if (logger.isTraceEnabled()) {
            logger.trace("{}: rpl with REFRESH_METADAT tx: {}", (Object)servConn.getName(), (Object)origMsg.getTransactionId());
        }
    }

    @Override
    protected void writeReply(Message origMsg, ServerConnection servConn, boolean entryNotFound, VersionTag versionTag) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("Destroy70.writeReply(entryNotFound={}, tag={})", (Object)entryNotFound, (Object)versionTag);
        }
        Message replyMsg = servConn.getReplyMessage();
        servConn.getCache().getCancelCriterion().checkCancelInProgress(null);
        replyMsg.setMessageType(6);
        int flags = 0;
        int numParts = 3;
        if (versionTag != null) {
            flags |= 1;
            ++numParts;
        }
        replyMsg.setNumberOfParts(numParts);
        replyMsg.setTransactionId(origMsg.getTransactionId());
        replyMsg.addIntPart(flags |= 2);
        if (versionTag != null) {
            replyMsg.addObjPart(versionTag);
        }
        replyMsg.addBytesPart(OK_BYTES);
        replyMsg.addIntPart(entryNotFound ? 1 : 0);
        replyMsg.send(servConn);
        if (logger.isTraceEnabled()) {
            logger.trace("{}: rpl tx: {} parts={}", (Object)servConn.getName(), (Object)origMsg.getTransactionId(), (Object)replyMsg.getNumberOfParts());
        }
    }
}

