/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;

public class ClientReady
extends BaseCommand {
    private static final ClientReady singleton = new ClientReady();

    public static Command getCommand() {
        return singleton;
    }

    private ClientReady() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException {
        CacheServerStats stats = servConn.getCacheServerStats();
        long oldStart = start;
        start = DistributionStats.getStatTime();
        stats.incReadClientReadyRequestTime(start - oldStart);
        try {
            String clientHost = servConn.getSocketHost();
            int clientPort = servConn.getSocketPort();
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Received client ready request ({} bytes) from {} on {}:{}", (Object)servConn.getName(), (Object)msg.getPayloadLength(), (Object)servConn.getProxyID(), (Object)clientHost, (Object)clientPort);
            }
            servConn.getAcceptor().getCacheClientNotifier().readyForEvents(servConn.getProxyID());
            long oldStart2 = start;
            start = DistributionStats.getStatTime();
            stats.incProcessClientReadyTime(start - oldStart2);
            this.writeReply(msg, servConn);
            servConn.setAsTrue(1);
            if (logger.isDebugEnabled()) {
                logger.debug(servConn.getName() + ": Processed client ready request from " + servConn.getProxyID() + " on " + clientHost + ":" + clientPort);
            }
        }
        finally {
            stats.incWriteClientReadyResponseTime(DistributionStats.getStatTime() - start);
        }
    }
}

