/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.locks;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.MessageWithReply;
import org.apache.geode.distributed.internal.PooledDistributionMessage;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.locks.DLockGrantor;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.TXCommitMessage;
import org.apache.geode.internal.cache.locks.TXLockId;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class TXOriginatorRecoveryProcessor
extends ReplyProcessor21 {
    private static final Logger logger = LogService.getLogger();

    static void sendMessage(Set members, InternalDistributedMember originator, TXLockId txLockId, DLockGrantor grantor, DM dm) {
        TXOriginatorRecoveryProcessor processor = new TXOriginatorRecoveryProcessor(dm, members);
        TXOriginatorRecoveryMessage msg = new TXOriginatorRecoveryMessage();
        msg.processorId = processor.getProcessorId();
        msg.txLockId = txLockId;
        HashSet recipients = new HashSet(members);
        recipients.remove(dm.getId());
        msg.setRecipients(members);
        if (logger.isDebugEnabled()) {
            logger.debug("Sending TXOriginatorRecoveryMessage: {}", (Object)msg);
        }
        dm.putOutgoing(msg);
        if (members.contains(dm.getId())) {
            if (msg.getSender() == null) {
                msg.setSender(dm.getId());
            }
            msg.process((DistributionManager)dm);
        }
        dm.getCancelCriterion().checkCancelInProgress(null);
        try {
            processor.waitForRepliesUninterruptibly();
        }
        catch (ReplyException e) {
            e.handleAsUnexpected();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("TXOriginatorRecoveryProcessor releasing: {}", (Object)txLockId);
        }
        try {
            grantor.releaseLockBatch(txLockId, originator);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private TXOriginatorRecoveryProcessor(DM dm, Set members) {
        super(dm, (Collection)members);
    }

    @Override
    protected boolean allowReplyFromSender() {
        return true;
    }

    @Override
    protected boolean logMultipleExceptions() {
        return false;
    }

    public static final class TXOriginatorRecoveryReplyMessage
    extends ReplyMessage {
        protected TXLockId txLockId;

        @Override
        public int getDSFID() {
            return -74;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
        }

        @Override
        public String toString() {
            return "TXOriginatorRecoveryReplyMessage (processorId=" + this.processorId + "; txLockId=" + this.txLockId + "; sender=" + this.getSender() + ")";
        }
    }

    public static final class TXOriginatorRecoveryMessage
    extends PooledDistributionMessage
    implements MessageWithReply {
        protected TXLockId txLockId;
        protected int processorId;

        @Override
        public int getProcessorId() {
            return this.processorId;
        }

        @Override
        protected void process(final DistributionManager dm) {
            final TXOriginatorRecoveryMessage msg = this;
            try {
                dm.getWaitingThreadPool().execute(new Runnable(){

                    @Override
                    public void run() {
                        this.processTXOriginatorRecoveryMessage(dm, msg);
                    }
                });
            }
            catch (RejectedExecutionException e) {
                logger.debug("Rejected processing of <{}>", (Object)msg, (Object)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void processTXOriginatorRecoveryMessage(DistributionManager dm, TXOriginatorRecoveryMessage msg) {
            ReplyException replyException = null;
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.TXOriginatorRecoveryProcessor_PROCESSTXORIGINATORRECOVERYMESSAGE));
            try {
                TXCommitMessage.getTracker().waitToProcess(msg.txLockId, dm);
            }
            catch (RuntimeException t) {
                TXOriginatorRecoveryReplyMessage replyMsg;
                try {
                    logger.warn((Message)LocalizedMessage.create(LocalizedStrings.TXOriginatorRecoveryProcessor_PROCESSTXORIGINATORRECOVERYMESSAGE_THROWABLE), (Throwable)t);
                    replyException = new ReplyException(t);
                    replyMsg = new TXOriginatorRecoveryReplyMessage();
                    replyMsg.txLockId = this.txLockId;
                }
                catch (Throwable throwable) {
                    TXOriginatorRecoveryReplyMessage replyMsg2 = new TXOriginatorRecoveryReplyMessage();
                    replyMsg2.txLockId = this.txLockId;
                    replyMsg2.setProcessorId(this.getProcessorId());
                    replyMsg2.setRecipient(this.getSender());
                    replyMsg2.setException(replyException);
                    if (this.getSender().equals(dm.getId())) {
                        logger.info((Message)LocalizedMessage.create(LocalizedStrings.TXOriginatorRecoveryProcessor_PROCESSTXORIGINATORRECOVERYMESSAGE_LOCALLY_PROCESS_REPLY));
                        replyMsg2.setSender(dm.getId());
                        replyMsg2.dmProcess(dm);
                    } else {
                        logger.info((Message)LocalizedMessage.create(LocalizedStrings.TXOriginatorRecoveryProcessor_PROCESSTXORIGINATORRECOVERYMESSAGE_SEND_REPLY));
                        dm.putOutgoing(replyMsg2);
                    }
                    throw throwable;
                }
                replyMsg.setProcessorId(this.getProcessorId());
                replyMsg.setRecipient(this.getSender());
                replyMsg.setException(replyException);
                if (this.getSender().equals(dm.getId())) {
                    logger.info((Message)LocalizedMessage.create(LocalizedStrings.TXOriginatorRecoveryProcessor_PROCESSTXORIGINATORRECOVERYMESSAGE_LOCALLY_PROCESS_REPLY));
                    replyMsg.setSender(dm.getId());
                    replyMsg.dmProcess(dm);
                } else {
                    logger.info((Message)LocalizedMessage.create(LocalizedStrings.TXOriginatorRecoveryProcessor_PROCESSTXORIGINATORRECOVERYMESSAGE_SEND_REPLY));
                    dm.putOutgoing(replyMsg);
                }
            }
            TXOriginatorRecoveryReplyMessage replyMsg = new TXOriginatorRecoveryReplyMessage();
            replyMsg.txLockId = this.txLockId;
            replyMsg.setProcessorId(this.getProcessorId());
            replyMsg.setRecipient(this.getSender());
            replyMsg.setException(replyException);
            if (this.getSender().equals(dm.getId())) {
                logger.info((Message)LocalizedMessage.create(LocalizedStrings.TXOriginatorRecoveryProcessor_PROCESSTXORIGINATORRECOVERYMESSAGE_LOCALLY_PROCESS_REPLY));
                replyMsg.setSender(dm.getId());
                replyMsg.dmProcess(dm);
            } else {
                logger.info((Message)LocalizedMessage.create(LocalizedStrings.TXOriginatorRecoveryProcessor_PROCESSTXORIGINATORRECOVERYMESSAGE_SEND_REPLY));
                dm.putOutgoing(replyMsg);
            }
        }

        @Override
        public int getDSFID() {
            return -75;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.txLockId = (TXLockId)DataSerializer.readObject(in);
            this.processorId = in.readInt();
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeObject(this.txLockId, out);
            out.writeInt(this.processorId);
        }

        @Override
        public String toString() {
            StringBuffer buff = new StringBuffer();
            buff.append("TXOriginatorRecoveryMessage (txLockId='");
            buff.append(this.txLockId);
            buff.append("'; processorId=");
            buff.append(this.processorId);
            buff.append(")");
            return buff.toString();
        }
    }
}

