/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.Collections;
import java.util.Set;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ReliableReplyProcessor21;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.TXId;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.TXMessage;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class TXRemoteRollbackMessage
extends TXMessage {
    private static final Logger logger = LogService.getLogger();

    public TXRemoteRollbackMessage() {
    }

    public TXRemoteRollbackMessage(int txUniqId, InternalDistributedMember onBehalfOfClientMember, ReplyProcessor21 processor) {
        super(txUniqId, onBehalfOfClientMember, processor);
    }

    public static ReliableReplyProcessor21 send(Cache cache, int txUniqId, InternalDistributedMember onBehalfOfClientMember, DistributedMember recipient) {
        InternalDistributedSystem system = (InternalDistributedSystem)cache.getDistributedSystem();
        Set<DistributedMember> recipients = Collections.singleton(recipient);
        ReliableReplyProcessor21 response = new ReliableReplyProcessor21(system, recipients);
        TXRemoteRollbackMessage msg = new TXRemoteRollbackMessage(txUniqId, onBehalfOfClientMember, response);
        msg.setRecipients(recipients);
        system.getDistributionManager().putOutgoing(msg);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean operateOnTx(TXId txId, DistributionManager dm) {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        if (cache == null) {
            throw new CacheClosedException(LocalizedStrings.CacheFactory_A_CACHE_HAS_NOT_YET_BEEN_CREATED.toLocalizedString());
        }
        TXManagerImpl txMgr = cache.getTXMgr();
        if (logger.isDebugEnabled()) {
            logger.debug("TX: Rolling back :{}", (Object)txId);
        }
        try {
            if (!txMgr.isHostedTxRecentlyCompleted(txId)) {
                txMgr.rollback();
            }
        }
        finally {
            txMgr.removeHostedTXState(txId);
        }
        return true;
    }

    @Override
    public int getDSFID() {
        return -111;
    }
}

