/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.lang.SystemUtils;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public final class MinimumSystemRequirements {
    public static final String JAVA_VERSION = "1.7.0_72";
    private static final Logger logger = LogService.getLogger();

    private MinimumSystemRequirements() {
    }

    public static void assertLogAndExit() {
        if (!MinimumSystemRequirements.checkAndLog()) {
            System.exit(1);
        }
    }

    public static boolean checkAndLog() {
        boolean minimumSystemRequirementsMet = true;
        if (!(minimumSystemRequirementsMet &= MinimumSystemRequirements.checkJavaVersion())) {
            logger.warn((Message)LocalizedMessage.create(LocalizedStrings.MinimumSystemRequirements_NOT_MET));
        }
        return minimumSystemRequirementsMet;
    }

    private static boolean checkJavaVersion() {
        if (SystemUtils.isJavaVersionAtLeast(JAVA_VERSION)) {
            return true;
        }
        logger.warn((Message)LocalizedMessage.create(LocalizedStrings.MinimumSystemRequirements_JAVA_VERSION, JAVA_VERSION));
        return false;
    }
}

