/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.concurrent.ConcurrentMap;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.cache.util.CacheListenerAdapter;
import org.apache.geode.internal.cache.FixedPartitionAttributesImpl;
import org.apache.geode.internal.cache.PartitionRegionConfig;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.partitioned.PRLocallyDestroyedException;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

class FixedPartitionAttributesListener
extends CacheListenerAdapter {
    private static final Logger logger = LogService.getLogger();

    FixedPartitionAttributesListener() {
    }

    @Override
    public void afterCreate(EntryEvent event) {
        PartitionRegionConfig prConfig = (PartitionRegionConfig)event.getNewValue();
        if (!prConfig.getElderFPAs().isEmpty()) {
            this.updatePartitionMap(prConfig);
        }
    }

    @Override
    public void afterUpdate(EntryEvent event) {
        PartitionRegionConfig prConfig = (PartitionRegionConfig)event.getNewValue();
        if (!prConfig.getElderFPAs().isEmpty()) {
            this.updatePartitionMap(prConfig);
        }
    }

    private void updatePartitionMap(PartitionRegionConfig prConfig) {
        int prId = prConfig.getPRId();
        PartitionedRegion pr = null;
        try {
            pr = PartitionedRegion.getPRFromId(prId);
            if (pr != null) {
                ConcurrentMap<String, Integer[]> partitionMap = pr.getPartitionsMap();
                for (FixedPartitionAttributesImpl fxPrAttr : prConfig.getElderFPAs()) {
                    partitionMap.put(fxPrAttr.getPartitionName(), new Integer[]{fxPrAttr.getStartingBucketID(), fxPrAttr.getNumBuckets()});
                }
            }
        }
        catch (PRLocallyDestroyedException e) {
            logger.debug("PRLocallyDestroyedException : Region ={} is locally destroyed on this node", (Object)prConfig.getPRId(), (Object)e);
        }
    }
}

