/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.geode.UnmodifiableException;
import org.apache.geode.cache.Cache;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.tcpserver.TcpClient;
import org.apache.geode.internal.ConfigSource;
import org.apache.geode.internal.JarClassLoader;
import org.apache.geode.internal.JarDeployer;
import org.apache.geode.internal.admin.remote.DistributionLocatorId;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.lang.StringUtils;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.process.ClusterConfigurationNotAvailableException;
import org.apache.geode.management.internal.configuration.domain.Configuration;
import org.apache.geode.management.internal.configuration.messages.ConfigurationRequest;
import org.apache.geode.management.internal.configuration.messages.ConfigurationResponse;
import org.apache.logging.log4j.Logger;

public class ClusterConfigurationLoader {
    private static final Logger logger = LogService.getLogger();

    public static void deployJarsReceivedFromClusterConfiguration(Cache cache, ConfigurationResponse response) throws IOException, ClassNotFoundException {
        if (response == null) {
            return;
        }
        String[] jarFileNames = response.getJarNames();
        byte[][] jarBytes = response.getJars();
        JarDeployer jarDeployer = new JarDeployer(((GemFireCacheImpl)cache).getDistributedSystem().getConfig().getDeployWorkingDir());
        if (jarFileNames != null && jarBytes != null) {
            JarClassLoader[] jarClassLoaders = jarDeployer.deploy(jarFileNames, jarBytes);
            for (int i = 0; i < jarFileNames.length; ++i) {
                if (jarClassLoaders[i] == null) continue;
                logger.info("Deployed " + jarClassLoaders[i].getFileCanonicalPath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void applyClusterXmlConfiguration(Cache cache, ConfigurationResponse response, DistributionConfig config) {
        String cacheXmlContent;
        if (response == null || response.getRequestedConfiguration().isEmpty()) {
            return;
        }
        List<String> groups = ClusterConfigurationLoader.getGroups(config);
        Map<String, Configuration> requestedConfiguration = response.getRequestedConfiguration();
        LinkedList<String> cacheXmlContentList = new LinkedList<String>();
        Configuration clusterConfiguration = requestedConfiguration.get("cluster");
        if (clusterConfiguration != null && !StringUtils.isBlank(cacheXmlContent = clusterConfiguration.getCacheXmlContent())) {
            cacheXmlContentList.add(cacheXmlContent);
        }
        for (String group : groups) {
            String cacheXmlContent2;
            Configuration groupConfiguration = requestedConfiguration.get(group);
            if (groupConfiguration == null || StringUtils.isBlank(cacheXmlContent2 = groupConfiguration.getCacheXmlContent())) continue;
            cacheXmlContentList.add(cacheXmlContent2);
        }
        for (String cacheXmlContent3 : cacheXmlContentList) {
            ByteArrayInputStream is = new ByteArrayInputStream(cacheXmlContent3.getBytes());
            try {
                cache.loadCacheXml(is);
            }
            finally {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void applyClusterPropertiesConfiguration(Cache cache, ConfigurationResponse response, DistributionConfig config) {
        if (response == null || response.getRequestedConfiguration().isEmpty()) {
            return;
        }
        List<String> groups = ClusterConfigurationLoader.getGroups(config);
        Map<String, Configuration> requestedConfiguration = response.getRequestedConfiguration();
        Properties runtimeProps = new Properties();
        Configuration clusterConfiguration = requestedConfiguration.get("cluster");
        if (clusterConfiguration != null) {
            runtimeProps.putAll((Map<?, ?>)clusterConfiguration.getGemfireProperties());
        }
        for (String group : groups) {
            Configuration groupConfiguration = requestedConfiguration.get(group);
            if (groupConfiguration == null) continue;
            runtimeProps.putAll((Map<?, ?>)groupConfiguration.getGemfireProperties());
        }
        Set<Object> attNames = runtimeProps.keySet();
        for (Object attNameObj : attNames) {
            String attName = (String)attNameObj;
            String attValue = runtimeProps.getProperty(attName);
            try {
                config.setAttribute(attName, attValue, ConfigSource.runtime());
            }
            catch (IllegalArgumentException e) {
                logger.info(e.getMessage());
            }
            catch (UnmodifiableException e) {
                logger.info(e.getMessage());
            }
        }
    }

    public static ConfigurationResponse requestConfigurationFromLocators(DistributionConfig config, List<String> locatorList) throws ClusterConfigurationNotAvailableException, UnknownHostException {
        List<String> groups = ClusterConfigurationLoader.getGroups(config);
        ConfigurationRequest request = new ConfigurationRequest();
        request.addGroups("cluster");
        for (String group : groups) {
            request.addGroups(group);
        }
        request.setNumAttempts(10);
        ConfigurationResponse response = null;
        TcpClient client = new TcpClient();
        for (String locatorInfo : locatorList) {
            DistributionLocatorId dlId = new DistributionLocatorId(locatorInfo);
            String ipaddress = dlId.getBindAddress();
            InetAddress locatorInetAddress = null;
            locatorInetAddress = !StringUtils.isBlank(ipaddress) ? InetAddress.getByName(ipaddress) : dlId.getHost();
            int port = dlId.getPort();
            try {
                response = (ConfigurationResponse)client.requestToServer(locatorInetAddress, port, request, 10000);
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (response == null || response.failedToGetSharedConfig()) {
            throw new ClusterConfigurationNotAvailableException(LocalizedStrings.Launcher_Command_FAILED_TO_GET_SHARED_CONFIGURATION.toLocalizedString());
        }
        return response;
    }

    private static List<String> getGroups(DistributionConfig config) {
        String groupString = config.getGroups();
        ArrayList<String> groups = new ArrayList<String>();
        if (!StringUtils.isBlank(groupString)) {
            groups.addAll(Arrays.asList(groupString.split(",")));
        }
        return groups;
    }

    public static List<String[]> getLocatorsInfo(String locatorsString) {
        ArrayList<String[]> locatorList = new ArrayList<String[]>();
        if (!StringUtils.isBlank(locatorsString)) {
            String[] bootstrappedlocators;
            for (String bootstrappedlocator : bootstrappedlocators = locatorsString.split(",")) {
                locatorList.add(bootstrappedlocator.split("\\[|]"));
            }
        }
        return locatorList;
    }

    public static List<String[]> getLocatorsInfo(List<String> locatorConnectionStrings) {
        ArrayList<String[]> locatorList = new ArrayList<String[]>();
        for (String locatorConnectionString : locatorConnectionStrings) {
            locatorList.add(locatorConnectionString.split("\\[|]"));
        }
        return locatorList;
    }
}

