/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.statalerts;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.SystemFailure;
import org.apache.geode.internal.admin.StatAlert;
import org.apache.geode.internal.admin.StatAlertDefinition;
import org.apache.geode.internal.admin.statalerts.StatisticInfo;

public abstract class BaseDecoratorImpl
implements StatAlertDefinition {
    protected StatAlertDefinition _def;

    public BaseDecoratorImpl() {
    }

    public BaseDecoratorImpl(StatAlertDefinition definition) {
        this._def = definition;
    }

    @Override
    public final int getId() {
        return this._def.getId();
    }

    @Override
    public boolean verify(StatisticsFactory factory) {
        return this._def.verify(factory);
    }

    @Override
    public String getName() {
        return this._def.getName();
    }

    @Override
    public void setName(String name) {
        this._def.setName(name);
    }

    @Override
    public final StatisticInfo[] getStatisticInfo() {
        return this._def.getStatisticInfo();
    }

    @Override
    public final void setStatisticInfo(StatisticInfo[] info) {
        this._def.setStatisticInfo(info);
    }

    public String toString() {
        return this._def.toString();
    }

    @Override
    public String getStringRepresentation() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("StatAlertDefinition [\n");
        buffer.append(this.toString());
        buffer.append("]");
        return buffer.toString();
    }

    @Override
    public boolean evaluate(Number[] params) {
        return this._def.evaluate(params);
    }

    @Override
    public boolean evaluate() {
        return this._def.evaluate();
    }

    @Override
    public StatAlert evaluateAndAlert(Number[] params) {
        return this._def.evaluateAndAlert(params);
    }

    @Override
    public StatAlert evaluateAndAlert() {
        return this._def.evaluateAndAlert();
    }

    @Override
    public Number[] getValue() {
        return this._def.getValue();
    }

    @Override
    public Number[] getValue(Number[] vals) {
        return this._def.getValue(vals);
    }

    @Override
    public boolean hasDecorator(String decoratorID) {
        return this._def.hasDecorator(decoratorID);
    }

    @Override
    public StatAlertDefinition getDecorator(String decoratorID) {
        return this._def.getDecorator(decoratorID);
    }

    public static boolean isGreaterThan(Number param, Number threshold) {
        try {
            int eval = BaseDecoratorImpl.compare(param, threshold);
            return eval > 0;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable e) {
            SystemFailure.checkFailure();
            return false;
        }
    }

    public static boolean isLessThan(Number param, Number threshold) {
        try {
            int eval = BaseDecoratorImpl.compare(param, threshold);
            return eval < 0;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable e) {
            SystemFailure.checkFailure();
            return false;
        }
    }

    public static int compare(Number param, Number threshold) throws Throwable {
        try {
            int eval = 0;
            if (threshold instanceof Double) {
                eval = Double.compare(param.doubleValue(), threshold.doubleValue());
            } else if (threshold instanceof Float) {
                eval = Float.compare(param.floatValue(), threshold.floatValue());
            } else if (threshold instanceof Long) {
                eval = Long.valueOf(param.longValue()).compareTo(threshold.longValue());
            } else if (threshold instanceof Integer) {
                eval = param.intValue() > threshold.intValue() ? 1 : -1;
            }
            return eval;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable e) {
            SystemFailure.checkFailure();
            throw e;
        }
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeObject(this._def, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this._def = (StatAlertDefinition)DataSerializer.readObject(in);
    }
}

