/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.apache.geode.CancelException;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.SystemFailure;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.InternalLocator;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.admin.remote.AdminFailureResponse;
import org.apache.geode.internal.admin.remote.AdminMultipleReplyProcessor;
import org.apache.geode.internal.admin.remote.AdminRequest;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.admin.remote.ShutdownAllResponse;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.tcp.ConnectionTable;
import org.apache.logging.log4j.Logger;

public class ShutdownAllRequest
extends AdminRequest {
    private static final Logger logger = LogService.getLogger();
    static final long SLEEP_TIME_BEFORE_DISCONNECT_DS = Long.getLong("gemfire.sleep-before-disconnect-ds", 1000L);

    public static Set send(DM dm, long timeout) {
        InternalDistributedSystem ids;
        boolean hadCache = ShutdownAllRequest.hasCache();
        boolean interrupted = false;
        DistributionManager dism = dm instanceof DistributionManager ? (DistributionManager)dm : null;
        InternalDistributedMember myId = dm.getDistributionManagerId();
        Set recipients = dm.getOtherNormalDistributionManagerIds();
        recipients.remove(myId);
        ShutdownAllRequest request = new ShutdownAllRequest();
        request.setRecipients(recipients);
        ShutDownAllReplyProcessor replyProcessor = new ShutDownAllReplyProcessor(dm, (Collection)recipients);
        request.msgId = replyProcessor.getProcessorId();
        dm.putOutgoing(request);
        if (!InternalLocator.isDedicatedLocator() && hadCache && dism != null) {
            AdminResponse response;
            try {
                request.setSender(myId);
                response = request.createResponse(dism);
            }
            catch (Exception ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug("caught exception while processing shutdownAll locally", (Throwable)ex);
                }
                response = AdminFailureResponse.create(dism, myId, ex);
            }
            response.setSender(myId);
            replyProcessor.process(response);
        }
        try {
            if (!replyProcessor.waitForReplies(timeout)) {
                return null;
            }
        }
        catch (ReplyException e) {
            if (!(e.getCause() instanceof CancelException)) {
                e.handleAsUnexpected();
            }
        }
        catch (CancelException e) {
        }
        catch (InterruptedException e) {
            interrupted = true;
        }
        if (hadCache && !InternalLocator.isDedicatedLocator() && (ids = dm.getSystem()).isConnected()) {
            ids.disconnect();
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        try {
            Thread.sleep(3L * SLEEP_TIME_BEFORE_DISCONNECT_DS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return replyProcessor.getResults();
    }

    @Override
    public boolean sendViaUDP() {
        return true;
    }

    @Override
    protected void process(DistributionManager dm) {
        InternalDistributedSystem ids;
        boolean isToShutdown = ShutdownAllRequest.hasCache();
        super.process(dm);
        if (isToShutdown && (ids = dm.getSystem()).isConnected()) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(SLEEP_TIME_BEFORE_DISCONNECT_DS);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ConnectionTable.threadWantsSharedResources();
                    if (ids.isConnected()) {
                        ids.disconnect();
                    }
                }
            });
            t.start();
        }
    }

    private static boolean hasCache() {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        return cache != null && !cache.isClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AdminResponse createResponse(DistributionManager dm) {
        boolean isToShutdown = ShutdownAllRequest.hasCache();
        boolean isSuccess = false;
        if (isToShutdown) {
            try {
                GemFireCacheImpl.getInstance().shutDownAll();
                isSuccess = true;
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                if (t instanceof InternalGemFireError) {
                    logger.fatal("DistributedSystem is closed due to InternalGemFireError", t);
                } else {
                    logger.fatal("DistributedSystem is closed due to unexpected exception", t);
                }
            }
            finally {
                if (!isSuccess) {
                    InternalDistributedMember me = dm.getDistributionManagerId();
                    InternalDistributedSystem ids = dm.getSystem();
                    if (!this.getSender().equals(me) && ids.isConnected()) {
                        logger.fatal("ShutdownAllRequest: disconnect distributed without response.");
                        ids.disconnect();
                    }
                }
            }
        }
        return new ShutdownAllResponse(this.getSender(), isToShutdown);
    }

    @Override
    public int getDSFID() {
        return 2111;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
    }

    @Override
    public String toString() {
        return "ShutdownAllRequest sent to " + Arrays.toString(this.getRecipients()) + " from " + this.getSender();
    }

    private static class ShutDownAllReplyProcessor
    extends AdminMultipleReplyProcessor {
        Set results = Collections.synchronizedSet(new TreeSet());

        public ShutDownAllReplyProcessor(DM dm, Collection initMembers) {
            super(dm, initMembers);
        }

        @Override
        protected boolean stopBecauseOfExceptions() {
            return false;
        }

        @Override
        public void process(DistributionMessage msg) {
            ReplyException ex;
            if (logger.isDebugEnabled()) {
                logger.debug("shutdownAll reply processor is processing {}", (Object)msg);
            }
            if (msg instanceof ShutdownAllResponse) {
                if (((ShutdownAllResponse)msg).isToShutDown()) {
                    logger.debug("{} adding {} to result set {}", (Object)this, (Object)msg.getSender(), (Object)this.results);
                    this.results.add(msg.getSender());
                } else {
                    this.removeMember(msg.getSender(), false);
                }
                if (msg.getSender().equals(this.dmgr.getDistributionManagerId())) {
                    this.removeMember(msg.getSender(), false);
                }
            }
            if (msg instanceof ReplyMessage && (ex = ((ReplyMessage)msg).getException()) != null) {
                this.processException(msg, ex);
            }
            this.checkIfDone();
        }

        public Set getResults() {
            logger.debug("{} shutdownAll returning {}", (Object)this, (Object)this.results, (Object)new Exception("stack trace"));
            return this.results;
        }
    }
}

