/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.apache.geode.admin.RuntimeAdminException;
import org.apache.geode.cache.AttributesMutator;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.CacheLoaderException;
import org.apache.geode.cache.CacheRuntimeException;
import org.apache.geode.cache.CacheStatistics;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.EntryExistsException;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.ExpirationAction;
import org.apache.geode.cache.InterestResultPolicy;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionExistsException;
import org.apache.geode.cache.RegionService;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.snapshot.RegionSnapshotService;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.admin.remote.DestroyEntryMessage;
import org.apache.geode.internal.admin.remote.DestroyRegionMessage;
import org.apache.geode.internal.admin.remote.DummyEntry;
import org.apache.geode.internal.admin.remote.ObjectDetailsRequest;
import org.apache.geode.internal.admin.remote.ObjectDetailsResponse;
import org.apache.geode.internal.admin.remote.ObjectNamesRequest;
import org.apache.geode.internal.admin.remote.ObjectNamesResponse;
import org.apache.geode.internal.admin.remote.RegionAdminMessage;
import org.apache.geode.internal.admin.remote.RegionAdminRequest;
import org.apache.geode.internal.admin.remote.RegionAttributesRequest;
import org.apache.geode.internal.admin.remote.RegionAttributesResponse;
import org.apache.geode.internal.admin.remote.RegionSizeRequest;
import org.apache.geode.internal.admin.remote.RegionSizeResponse;
import org.apache.geode.internal.admin.remote.RegionStatisticsRequest;
import org.apache.geode.internal.admin.remote.RegionStatisticsResponse;
import org.apache.geode.internal.admin.remote.RemoteGemFireVM;
import org.apache.geode.internal.admin.remote.SubRegionRequest;
import org.apache.geode.internal.admin.remote.SubRegionResponse;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class AdminRegion
implements Region {
    private final String globalName;
    private final String localName;
    private final String userAttributeDesc;
    private final RemoteGemFireVM vm;
    private static final char nameSep = '/';

    public AdminRegion(String localName, RemoteGemFireVM vm, String userAttributeDesc) {
        String gn = localName;
        int idx = localName.lastIndexOf(47);
        if (idx != -1) {
            localName = localName.substring(idx + 1);
        } else {
            gn = '/' + gn;
        }
        this.globalName = gn;
        this.localName = localName;
        this.userAttributeDesc = userAttributeDesc;
        this.vm = vm;
    }

    public AdminRegion(String localName, AdminRegion parent, String userAttributeDesc) {
        String gn;
        this.localName = localName;
        this.userAttributeDesc = userAttributeDesc;
        this.globalName = gn = parent.getFullPath() + '/' + localName;
        this.vm = parent.vm;
    }

    @Override
    public String getName() {
        return this.localName;
    }

    @Override
    public String getFullPath() {
        return this.globalName;
    }

    public Region getParentRegion() {
        throw new UnsupportedOperationException();
    }

    public RegionAttributes getAttributes() {
        try {
            RegionAttributesResponse resp = (RegionAttributesResponse)this.sendAndWait(RegionAttributesRequest.create());
            return resp.getRegionAttributes();
        }
        catch (CacheException c) {
            throw new RuntimeAdminException(c);
        }
    }

    public AttributesMutator getAttributesMutator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CacheStatistics getStatistics() {
        try {
            RegionStatisticsResponse resp = (RegionStatisticsResponse)this.sendAndWait(RegionStatisticsRequest.create());
            return resp.getRegionStatistics();
        }
        catch (CacheException c) {
            throw new RuntimeAdminException(c);
        }
    }

    @Override
    public void invalidateRegion() throws TimeoutException {
        this.sendAsync(DestroyRegionMessage.create(ExpirationAction.INVALIDATE));
    }

    @Override
    public void invalidateRegion(Object aCallbackArgument) throws TimeoutException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void localInvalidateRegion() {
        this.sendAsync(DestroyRegionMessage.create(ExpirationAction.LOCAL_INVALIDATE));
    }

    @Override
    public void localInvalidateRegion(Object aCallbackArgument) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void destroyRegion() throws CacheWriterException, TimeoutException {
        this.sendAsync(DestroyRegionMessage.create(ExpirationAction.DESTROY));
    }

    @Override
    public void destroyRegion(Object aCallbackArgument) throws CacheWriterException, TimeoutException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void localDestroyRegion() {
        this.sendAsync(DestroyRegionMessage.create(ExpirationAction.LOCAL_DESTROY));
    }

    @Override
    public void localDestroyRegion(Object aCallbackArgument) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException();
    }

    public Region getSubregion(String regionName) {
        throw new UnsupportedOperationException();
    }

    public Region createSubregion(String subregionName, RegionAttributes aRegionAttributes) throws RegionExistsException, TimeoutException {
        throw new UnsupportedOperationException();
    }

    public Set subregions(boolean recursive) {
        if (recursive) {
            throw new UnsupportedOperationException();
        }
        try {
            SubRegionResponse resp = (SubRegionResponse)this.sendAndWait(SubRegionRequest.create());
            return resp.getRegionSet(this);
        }
        catch (CacheException c) {
            throw new RuntimeAdminException(c);
        }
    }

    public Region.Entry getEntry(Object key) {
        try {
            ObjectDetailsResponse resp = (ObjectDetailsResponse)this.sendAndWait(ObjectDetailsRequest.create(key, this.vm.getCacheInspectionMode()));
            return new DummyEntry(this, key, resp.getObjectValue(), resp.getUserAttribute(), resp.getStatistics());
        }
        catch (CacheException c) {
            throw new RuntimeAdminException(c);
        }
    }

    @Override
    public Object get(Object key) throws CacheLoaderException, TimeoutException {
        throw new UnsupportedOperationException();
    }

    public Object get(Object key, Object aCallbackArgument) throws TimeoutException, CacheLoaderException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object put(Object key, Object value) throws TimeoutException, CacheWriterException {
        throw new UnsupportedOperationException();
    }

    public Object put(Object key, Object value, Object aCallbackArgument) throws TimeoutException, CacheWriterException {
        throw new UnsupportedOperationException();
    }

    public void create(Object key, Object value) throws TimeoutException, EntryExistsException, CacheWriterException {
        throw new UnsupportedOperationException();
    }

    public void create(Object key, Object value, Object aCacheWriterParam) throws TimeoutException, EntryExistsException, CacheWriterException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void invalidate(Object key) throws TimeoutException, EntryNotFoundException {
        this.sendAsync(DestroyEntryMessage.create(key, ExpirationAction.INVALIDATE));
    }

    @Override
    public void invalidate(Object key, Object aCallbackArgument) throws TimeoutException, EntryNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void localInvalidate(Object key) throws EntryNotFoundException {
        this.sendAsync(DestroyEntryMessage.create(key, ExpirationAction.LOCAL_INVALIDATE));
    }

    @Override
    public void localInvalidate(Object key, Object aCallbackArgument) throws EntryNotFoundException {
        throw new UnsupportedOperationException();
    }

    public Object destroy(Object key) throws TimeoutException, EntryNotFoundException, CacheWriterException {
        this.sendAsync(DestroyEntryMessage.create(key, ExpirationAction.DESTROY));
        return null;
    }

    public Object destroy(Object key, Object aCacheWriterParam) throws TimeoutException, EntryNotFoundException, CacheWriterException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void localDestroy(Object key) throws EntryNotFoundException {
        this.sendAsync(DestroyEntryMessage.create(key, ExpirationAction.LOCAL_DESTROY));
    }

    @Override
    public void localDestroy(Object key, Object aCallbackArgument) throws EntryNotFoundException {
        throw new UnsupportedOperationException();
    }

    public Set keys() {
        try {
            ObjectNamesResponse resp = (ObjectNamesResponse)this.sendAndWait(ObjectNamesRequest.create());
            return resp.getNameSet();
        }
        catch (CacheException ce) {
            throw new RuntimeAdminException(ce);
        }
    }

    @Override
    public Collection values() {
        throw new UnsupportedOperationException();
    }

    public Set entries(boolean recursive) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Cache getCache() {
        throw new UnsupportedOperationException();
    }

    @Override
    public RegionService getRegionService() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getUserAttribute() {
        return this.userAttributeDesc;
    }

    @Override
    public void setUserAttribute(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDestroyed() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void becomeLockGrantor() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValueForKey(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Lock getRegionDistributedLock() throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Lock getDistributedLock(Object key) throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeToDisk() {
        throw new UnsupportedOperationException(LocalizedStrings.AdminRegion_SHOULD_NOT_BE_CALLED.toLocalizedString());
    }

    public void registerInterest(Object key) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    @Override
    public void registerInterestRegex(String regex) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    public void registerInterest(Object key, InterestResultPolicy policy) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    @Override
    public void registerInterestRegex(String regex, InterestResultPolicy policy) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    public void unregisterInterest(Object key) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    @Override
    public void unregisterInterestRegex(String regex) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    public void registerInterest(Object key, boolean isDurable) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    public void registerInterest(Object key, boolean isDurable, boolean receiveValues) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    @Override
    public void registerInterestRegex(String regex, boolean isDurable) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    @Override
    public void registerInterestRegex(String regex, boolean isDurable, boolean receiveValues) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    public void registerInterest(Object key, InterestResultPolicy policy, boolean isDurable) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    public void registerInterest(Object key, InterestResultPolicy policy, boolean isDurable, boolean receiveValues) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    @Override
    public void registerInterestRegex(String regex, InterestResultPolicy policy, boolean isDurable) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    @Override
    public void registerInterestRegex(String regex, InterestResultPolicy policy, boolean isDurable, boolean receiveValues) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    public void unregisterInterest(Object key, boolean isDurable) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    public void unregisterInterestRegex(String regex, boolean isDurable) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    public List getInterestList() throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    public List getInterestListRegex() throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    public Set keySetOnServer() throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    @Override
    public boolean containsKeyOnServer(Object key) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    public String toString() {
        return "<AdminRegion " + this.getFullPath() + ">";
    }

    public int[] sizes() throws CacheException {
        RegionSizeResponse resp = (RegionSizeResponse)this.sendAndWait(RegionSizeRequest.create());
        return new int[]{resp.getEntryCount(), resp.getSubregionCount()};
    }

    AdminResponse sendAndWait(RegionAdminRequest msg) throws CacheException {
        msg.setRegionName(this.getFullPath());
        try {
            return this.vm.sendAndWait(msg);
        }
        catch (RuntimeAdminException ex) {
            Throwable cause = ex.getRootCause();
            if (cause instanceof CacheException) {
                throw (CacheException)cause;
            }
            if (cause instanceof CacheRuntimeException) {
                throw (CacheRuntimeException)cause;
            }
            throw ex;
        }
    }

    void sendAsync(RegionAdminMessage msg) {
        msg.setRegionName(this.getFullPath());
        this.vm.sendAsync(msg);
    }

    @Override
    public boolean existsValue(String predicate) {
        throw new UnsupportedOperationException();
    }

    public SelectResults query(String predicate) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object selectValue(String predicate) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void loadSnapshot(InputStream inputStream) throws IOException, ClassNotFoundException, CacheWriterException, TimeoutException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void saveSnapshot(OutputStream outputStream) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map arg0) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map arg0, Object callbackArg) {
        throw new UnsupportedOperationException();
    }

    public Map getAll(Collection keys) {
        throw new UnsupportedOperationException();
    }

    public Map getAll(Collection keys, Object callback) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object remove(Object arg0) {
        throw new UnsupportedOperationException();
    }

    public Set entrySet(boolean recursive) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public void localClear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void forceRolling() {
        throw new UnsupportedOperationException();
    }

    public int[] forceCompaction() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object putIfAbsent(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object replace(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean replace(Object key, Object oldValue, Object newValue) {
        throw new UnsupportedOperationException();
    }

    public RegionSnapshotService<?, ?> getSnapshotService() {
        throw new UnsupportedOperationException();
    }

    public void removeAll(Collection keys) {
        throw new UnsupportedOperationException();
    }

    public void removeAll(Collection keys, Object aCallbackArgument) {
        throw new UnsupportedOperationException();
    }
}

