/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalLocator;
import org.apache.geode.distributed.internal.StartupMessageData;
import org.apache.geode.distributed.internal.StartupResponseMessage;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.GemFireVersion;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class StartupResponseWithVersionMessage
extends StartupResponseMessage {
    private static final Logger logger = LogService.getLogger();
    private String version;
    private Collection<String> hostedLocators;
    private boolean isSharedConfigurationEnabled;

    public StartupResponseWithVersionMessage() {
    }

    StartupResponseWithVersionMessage(DistributionManager dm, int processorId, InternalDistributedMember recipient, String rejectionMessage, boolean responderIsAdmin) {
        super(dm, processorId, recipient, rejectionMessage, responderIsAdmin);
        this.version = GemFireVersion.getGemFireVersion();
        this.hostedLocators = InternalLocator.getLocatorStrings();
        InternalLocator locator = InternalLocator.getLocator();
        if (locator != null) {
            this.isSharedConfigurationEnabled = locator.isSharedConfigurationEnabled();
        }
    }

    @Override
    protected void process(DistributionManager dm) {
        super.process(dm);
        if (this.hostedLocators != null) {
            dm.addHostedLocators(this.getSender(), this.hostedLocators, this.isSharedConfigurationEnabled);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Received StartupResponseWithVersionMessage from a member with version: {}", (Object)this.version);
        }
    }

    @Override
    public int getDSFID() {
        return 146;
    }

    @Override
    public String toString() {
        return super.toString() + " version=" + this.version;
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeString(this.version, out);
        StartupMessageData data = new StartupMessageData();
        data.writeHostedLocators(this.hostedLocators);
        data.writeIsSharedConfigurationEnabled(this.isSharedConfigurationEnabled);
        data.writeTo(out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.version = DataSerializer.readString(in);
        StartupMessageData data = new StartupMessageData();
        data.readFrom(in);
        this.hostedLocators = data.readHostedLocators();
        this.isSharedConfigurationEnabled = data.readIsSharedConfigurationEnabled();
    }
}

