/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.MessageWithReply;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.SerialDistributionMessage;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public final class SerialAckedMessage
extends SerialDistributionMessage
implements MessageWithReply {
    private static final Logger logger = LogService.getLogger();
    private InternalDistributedMember id;
    private int processorId;
    transient DistributionManager originDm;
    private transient ReplyProcessor21 rp;

    public SerialAckedMessage() {
        InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
        if (ds != null) {
            this.originDm = (DistributionManager)ds.getDistributionManager();
            this.id = this.originDm.getDistributionManagerId();
        }
    }

    public void send(Set recipients, boolean multicast) throws InterruptedException, ReplyException {
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        InternalDistributedMember me = this.originDm.getDistributionManagerId();
        if ((recipients = new HashSet(recipients)).contains(me)) {
            recipients.remove(me);
        }
        if (isDebugEnabled) {
            logger.debug("Recipients for SerialAckedMessage are {}", recipients);
        }
        this.rp = new ReplyProcessor21((DM)this.originDm, recipients);
        this.processorId = this.rp.getProcessorId();
        this.setRecipients(recipients);
        this.setMulticast(multicast);
        Set failures = this.originDm.putOutgoing(this);
        if (failures != null && failures.size() > 0) {
            for (InternalDistributedMember mbr : failures) {
                if (!isDebugEnabled) continue;
                logger.debug("Unable to send serial acked message to {}", (Object)mbr);
            }
        }
        this.rp.waitForReplies();
    }

    void setDistributionManagerId(InternalDistributedMember id) {
        this.id = id;
    }

    public void setProcessorId(int pid) {
        this.processorId = pid;
    }

    @Override
    public int getProcessorId() {
        return this.processorId;
    }

    @Override
    protected void process(DistributionManager dm) {
        Assert.assertTrue(this.id != null);
        ReplyMessage reply = new ReplyMessage();
        reply.setProcessorId(this.processorId);
        reply.setRecipient(this.getSender());
        dm.putOutgoing(reply);
    }

    @Override
    public int getDSFID() {
        return 2001;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.processorId);
        DataSerializer.writeObject(this.id, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.processorId = in.readInt();
        this.id = (InternalDistributedMember)DataSerializer.readObject(in);
    }

    @Override
    public String toString() {
        return "SerialAckedMessage from=" + this.id + ";processorId=" + this.processorId;
    }
}

