/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Array;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.geode.CancelCriterion;
import org.apache.geode.CancelException;
import org.apache.geode.ForcedDisconnectException;
import org.apache.geode.GemFireConfigException;
import org.apache.geode.GemFireIOException;
import org.apache.geode.LogWriter;
import org.apache.geode.StatisticDescriptor;
import org.apache.geode.Statistics;
import org.apache.geode.StatisticsType;
import org.apache.geode.StatisticsTypeFactory;
import org.apache.geode.SystemConnectException;
import org.apache.geode.SystemFailure;
import org.apache.geode.admin.AlertLevel;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.execute.internal.FunctionServiceManager;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.DistributedSystemDisconnectedException;
import org.apache.geode.distributed.DurableClientAttributes;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.DMStats;
import org.apache.geode.distributed.internal.DSClock;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.DistributionConfigImpl;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalLocator;
import org.apache.geode.distributed.internal.LonerDistributionManager;
import org.apache.geode.distributed.internal.ResourceEvent;
import org.apache.geode.distributed.internal.ResourceEventsListener;
import org.apache.geode.distributed.internal.RuntimeDistributionConfigImpl;
import org.apache.geode.distributed.internal.locks.GrantorRequestProcessor;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.distributed.internal.membership.MembershipManager;
import org.apache.geode.distributed.internal.membership.QuorumChecker;
import org.apache.geode.distributed.internal.membership.gms.Services;
import org.apache.geode.distributed.internal.membership.gms.mgr.GMSMembershipManager;
import org.apache.geode.i18n.LogWriterI18n;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.DSFIDFactory;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.InternalInstantiator;
import org.apache.geode.internal.SystemTimer;
import org.apache.geode.internal.admin.remote.DistributionLocatorId;
import org.apache.geode.internal.cache.CacheServerImpl;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.execute.FunctionServiceStats;
import org.apache.geode.internal.cache.execute.FunctionStats;
import org.apache.geode.internal.cache.tier.sockets.HandShake;
import org.apache.geode.internal.cache.xmlcache.CacheServerCreation;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.InternalLogWriter;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.LogWriterFactory;
import org.apache.geode.internal.logging.LoggingThreadGroup;
import org.apache.geode.internal.logging.log4j.AlertAppender;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.logging.log4j.LogWriterAppender;
import org.apache.geode.internal.logging.log4j.LogWriterAppenders;
import org.apache.geode.internal.net.SocketCreatorFactory;
import org.apache.geode.internal.offheap.MemoryAllocator;
import org.apache.geode.internal.offheap.OffHeapStorage;
import org.apache.geode.internal.statistics.DummyStatisticsImpl;
import org.apache.geode.internal.statistics.GemFireStatSampler;
import org.apache.geode.internal.statistics.LocalStatisticsImpl;
import org.apache.geode.internal.statistics.StatisticsImpl;
import org.apache.geode.internal.statistics.StatisticsManager;
import org.apache.geode.internal.statistics.StatisticsTypeFactoryImpl;
import org.apache.geode.internal.statistics.platform.LinuxProcFsStatistics;
import org.apache.geode.internal.statistics.platform.OsStatisticsFactory;
import org.apache.geode.internal.tcp.ConnectionTable;
import org.apache.geode.management.ManagementException;
import org.apache.geode.security.GemFireSecurityException;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class InternalDistributedSystem
extends DistributedSystem
implements OsStatisticsFactory,
StatisticsManager {
    private static final Logger logger = LogService.getLogger();
    public static final String DISABLE_MANAGEMENT_PROPERTY = "gemfire.disableManagement";
    public static volatile DistributedSystem systemAttemptingReconnect;
    public static final CreationStackGenerator DEFAULT_CREATION_STACK_GENERATOR;
    public static final AtomicReference<CreationStackGenerator> TEST_CREATION_STACK_GENERATOR;
    protected DM dm;
    private final GrantorRequestProcessor.GrantorRequestContext grc;
    private long id;
    protected InternalLogWriter logWriter = null;
    protected InternalLogWriter securityLogWriter = null;
    private DSClock clock;
    private LogWriterAppender logWriterAppender = null;
    private LogWriterAppender securityLogWriterAppender = null;
    private final long startTime;
    protected final Object isConnectedMutex = new Object();
    protected volatile boolean isConnected;
    private boolean isLoner = false;
    private GemFireStatSampler sampler = null;
    private final Set listeners = new LinkedHashSet();
    private static Set connectListeners;
    private static List<ReconnectListener> reconnectListeners;
    private boolean isReconnectingDS;
    private QuorumChecker quorumChecker;
    public static final String SHUTDOWN_HOOK_NAME = "Distributed system shutdown hook";
    public static final String DISABLE_SHUTDOWN_HOOK_PROPERTY = "gemfire.disableShutdownHook";
    public static final String APPEND_TO_LOG_FILE = "gemfire.append-log";
    private final DistributionConfig originalConfig;
    private DistributionConfig config;
    private final boolean statsDisabled = Boolean.getBoolean("gemfire.statsDisabled");
    private volatile boolean shareSockets = true;
    private InternalLocator startedLocator;
    private List<ResourceEventsListener> resourceListeners;
    private final boolean disableManagement = Boolean.getBoolean("gemfire.disableManagement");
    private final Throwable creationStack;
    private MemoryAllocator offHeapStore = null;
    private final Stopper stopper = new Stopper();
    protected volatile boolean isDisconnecting = false;
    private static final long MAX_DISCONNECT_WAIT;
    private final ThreadGroup disconnectListenerThreadGroup = LoggingThreadGroup.createThreadGroup("Disconnect Listeners");
    private static volatile boolean emergencyClassesLoaded;
    private final CopyOnWriteArrayList<Statistics> statsList = new CopyOnWriteArrayList();
    private int statsListModCount = 0;
    private long statsListUniqueId = 1L;
    private final Object statsListUniqueIdLock = new Object();
    private final ConcurrentHashMap<String, FunctionStats> functionExecutionStatsMap = new ConcurrentHashMap();
    private FunctionServiceStats functionServiceStats = null;
    private static final StatisticsTypeFactory tf;
    final ThreadLocal disconnectListenerThread = new ThreadLocal();
    public static final Thread shutdownHook;
    private static volatile int reconnectAttemptCounter;
    private static long reconnectAttemptTime;
    private volatile boolean attemptingToReconnect = false;
    private volatile boolean reconnected = false;
    private volatile boolean forcedDisconnect = false;
    private volatile InternalDistributedSystem reconnectDS;
    private boolean locatorDMTypeForced;
    private volatile boolean reconnectCancelled = false;
    private final Object reconnectLock = new Object();

    public GrantorRequestProcessor.GrantorRequestContext getGrantorRequestContext() {
        return this.grc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InternalDistributedSystem newInstance(Properties config) {
        boolean success = false;
        InternalDataSerializer.checkSerializationVersion();
        try {
            SystemFailure.startThreads();
            InternalDistributedSystem newSystem = new InternalDistributedSystem(config);
            newSystem.initialize();
            reconnectAttemptCounter = 0;
            InternalDistributedSystem.notifyConnectListeners(newSystem);
            success = true;
            InternalDistributedSystem internalDistributedSystem = newSystem;
            return internalDistributedSystem;
        }
        finally {
            if (!success) {
                LoggingThreadGroup.cleanUpThreadGroups();
                SystemFailure.stopThreads();
            }
        }
    }

    public static InternalDistributedSystem newInstanceForTesting(DM dm, Properties nonDefault) {
        InternalDistributedSystem sys = new InternalDistributedSystem(nonDefault);
        sys.config = new RuntimeDistributionConfigImpl(sys);
        sys.dm = dm;
        sys.isConnected = true;
        return sys;
    }

    public static DistributedSystem connectForAdmin(Properties props) {
        return DistributedSystem.connectForAdmin(props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InternalDistributedSystem getConnectedInstance() {
        InternalDistributedSystem result = null;
        Object object = existingSystemsLock;
        synchronized (object) {
            InternalDistributedSystem existingSystem;
            if (!existingSystems.isEmpty() && (existingSystem = (InternalDistributedSystem)existingSystems.get(0)).isConnected()) {
                result = existingSystem;
            }
        }
        return result;
    }

    public static InternalDistributedSystem unsafeGetConnectedInstance() {
        InternalDistributedSystem result = InternalDistributedSystem.getAnyInstance();
        if (result != null && !result.isConnected()) {
            result = null;
        }
        return result;
    }

    public static DMStats getDMStats() {
        InternalDistributedSystem sys = InternalDistributedSystem.getAnyInstance();
        if (sys != null && sys.dm != null) {
            return sys.dm.getStats();
        }
        return null;
    }

    public static LogWriterI18n getLoggerI18n() {
        InternalDistributedSystem sys = InternalDistributedSystem.getAnyInstance();
        if (sys != null && sys.logWriter != null) {
            return sys.logWriter.convertToLogWriterI18n();
        }
        return null;
    }

    public static InternalLogWriter getStaticInternalLogWriter() {
        InternalDistributedSystem sys = InternalDistributedSystem.getAnyInstance();
        if (sys != null) {
            return sys.logWriter;
        }
        return null;
    }

    public InternalLogWriter getInternalLogWriter() {
        return this.logWriter;
    }

    public static InternalLogWriter getStaticSecurityInternalLogWriter() {
        InternalDistributedSystem sys = InternalDistributedSystem.getAnyInstance();
        if (sys != null) {
            return sys.securityLogWriter;
        }
        return null;
    }

    public InternalLogWriter getSecurityInternalLogWriter() {
        InternalDistributedSystem sys = InternalDistributedSystem.getAnyInstance();
        if (sys != null) {
            return sys.securityLogWriter;
        }
        return null;
    }

    private static void resetReconnectAttemptCounter() {
        reconnectAttemptCounter = 0;
    }

    private InternalDistributedSystem(Properties nonDefault) {
        DSFIDFactory.registerTypes();
        Object o = nonDefault.remove("ds-reconnecting");
        this.isReconnectingDS = o instanceof Boolean ? (Boolean)o : false;
        o = nonDefault.remove("ds-quorum-checker");
        if (o instanceof QuorumChecker) {
            this.quorumChecker = (QuorumChecker)o;
        }
        this.originalConfig = (o = nonDefault.remove("ds-config")) instanceof DistributionConfigImpl ? (DistributionConfigImpl)o : new DistributionConfigImpl(nonDefault);
        ((DistributionConfigImpl)this.originalConfig).checkForDisallowedDefaults();
        this.shareSockets = this.originalConfig.getConserveSockets();
        this.startTime = System.currentTimeMillis();
        this.grc = new GrantorRequestProcessor.GrantorRequestContext(this.stopper);
        this.creationStack = TEST_CREATION_STACK_GENERATOR.get().generateCreationStack(this.originalConfig);
    }

    public void addResourceListener(ResourceEventsListener listener) {
        this.resourceListeners.add(listener);
    }

    public void removeResourceListener(ResourceEventsListener listener) {
        this.resourceListeners.remove(listener);
    }

    public List<ResourceEventsListener> getResourceListeners() {
        return this.resourceListeners;
    }

    public void handleResourceEvent(ResourceEvent event, Object resource) {
        if (this.disableManagement) {
            return;
        }
        if (this.resourceListeners.size() == 0) {
            return;
        }
        this.notifyResourceEventListeners(event, resource);
    }

    public boolean isLoner() {
        return this.isLoner;
    }

    public MemoryAllocator getOffHeapStore() {
        return this.offHeapStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void initialize() {
        if (this.originalConfig.getLocators().equals("")) {
            if (this.originalConfig.getMcastPort() != 0) {
                throw new GemFireConfigException("The locators attribute can not be empty when the mcast-port attribute is non-zero.");
            }
            this.isLoner = true;
        }
        this.config = new RuntimeDistributionConfigImpl(this);
        if (!this.isLoner) {
            this.attemptingToReconnect = InternalDistributedSystem.reconnectAttemptCounter > 0;
        }
        try {
            SocketCreatorFactory.setDistributionConfig(this.config);
            hasLogFile = this.config.getLogFile() != null && this.config.getLogFile().equals(new File("")) == false;
            hasSecurityLogFile = this.config.getSecurityLogFile() != null && this.config.getSecurityLogFile().equals(new File("")) == false;
            LogService.configureLoggers(hasLogFile, hasSecurityLogFile);
            if (hasLogFile || hasSecurityLogFile) {
                if (hasLogFile) {
                    this.logWriterAppender = LogWriterAppenders.getOrCreateAppender(LogWriterAppenders.Identifier.MAIN, this.isLoner, this.config, true);
                }
                if (hasSecurityLogFile) {
                    this.securityLogWriterAppender = LogWriterAppenders.getOrCreateAppender(LogWriterAppenders.Identifier.SECURITY, this.isLoner, this.config, false);
                }
            }
            if (this.logWriter == null) {
                this.logWriter = LogWriterFactory.createLogWriterLogger(this.isLoner, false, this.config, true);
                this.logWriter.fine("LogWriter is created.");
            }
            if (this.securityLogWriter == null) {
                this.securityLogWriter = LogWriterFactory.createLogWriterLogger(this.isLoner, true, this.config, false);
                this.securityLogWriter.fine("SecurityLogWriter is created.");
            }
            Services.setLogWriter(this.logWriter);
            Services.setSecurityLogWriter(this.securityLogWriter);
            this.clock = new DSClock(this.isLoner);
            if (this.attemptingToReconnect && InternalDistributedSystem.logger.isDebugEnabled()) {
                InternalDistributedSystem.logger.debug("This thread is initializing a new DistributedSystem in order to reconnect to other members");
            }
            if (Boolean.getBoolean("Locator.forceLocatorDMType")) {
                this.locatorDMTypeForced = true;
            }
            try {
                HandShake.initCertsMap(this.config.getSecurityProps());
                HandShake.initPrivateKey(this.config.getSecurityProps());
                HandShake.initDHKeys(this.config);
            }
            catch (Exception ex) {
                throw new GemFireSecurityException(LocalizedStrings.InternalDistributedSystem_PROBLEM_IN_INITIALIZING_KEYS_FOR_CLIENT_AUTHENTICATION.toLocalizedString(), ex);
            }
            offHeapMemorySize = OffHeapStorage.parseOffHeapMemorySize(this.getConfig().getOffHeapMemorySize());
            this.offHeapStore = OffHeapStorage.createOffHeapStorage(this, offHeapMemorySize, this);
            if (this.getConfig().getLockMemory()) {
                avail = LinuxProcFsStatistics.getAvailableMemory(InternalDistributedSystem.logger);
                if (avail < (size = offHeapMemorySize + Runtime.getRuntime().totalMemory())) {
                    if (GemFireCacheImpl.ALLOW_MEMORY_LOCK_WHEN_OVERCOMMITTED) {
                        InternalDistributedSystem.logger.warn((Message)LocalizedMessage.create(LocalizedStrings.InternalDistributedSystem_MEMORY_OVERCOMMIT_WARN, size - avail));
                    } else {
                        throw new IllegalStateException(LocalizedStrings.InternalDistributedSystem_MEMORY_OVERCOMMIT.toLocalizedString(new Object[]{avail, size}));
                    }
                }
                InternalDistributedSystem.logger.info("Locking memory. This may take a while...");
                GemFireCacheImpl.lockMemory();
                InternalDistributedSystem.logger.info("Finished locking memory.");
            }
            try {
                this.startInitLocator();
            }
            catch (InterruptedException e) {
                throw new SystemConnectException("Startup has been interrupted", e);
            }
            e = this.isConnectedMutex;
            synchronized (e) {
                this.isConnected = true;
            }
            if (!this.isLoner) {
                try {
                    if (this.quorumChecker != null) {
                        this.quorumChecker.suspend();
                    }
                    this.dm = DistributionManager.create(this);
                    if (!InternalLocator.hasLocator()) ** GOTO lbl78
                    locator = InternalLocator.getLocator();
                    this.getDistributionManager().addHostedLocators(this.getDistributedMember(), InternalLocator.getLocatorStrings(), locator.isSharedConfigurationEnabled());
                }
                finally {
                    if (this.dm == null && this.quorumChecker != null) {
                        this.quorumChecker.resume();
                    }
                    this.setDisconnected();
                }
            } else {
                this.dm = new LonerDistributionManager(this, this.logWriter);
            }
lbl78:
            // 3 sources

            Assert.assertTrue(this.dm != null);
            Assert.assertTrue(this.dm.getSystem() == this);
            try {
                this.id = this.dm.getChannelId();
            }
            catch (DistributedSystemDisconnectedException e) {
                throw new SystemConnectException(LocalizedStrings.InternalDistributedSystem_DISTRIBUTED_SYSTEM_HAS_DISCONNECTED.toLocalizedString(), e);
            }
            e = this.isConnectedMutex;
            synchronized (e) {
                this.isConnected = true;
            }
            if (this.attemptingToReconnect && this.startedLocator == null) {
                try {
                    this.startInitLocator();
                }
                catch (InterruptedException e) {
                    throw new SystemConnectException("Startup has been interrupted", e);
                }
            }
            try {
                this.endInitLocator();
            }
            catch (IOException e) {
                throw new GemFireIOException("Problem finishing a locator service start", e);
            }
            if (!this.statsDisabled) {
                this.sampler = new GemFireStatSampler(this);
                this.sampler.start();
            }
            if (this.logWriterAppender != null) {
                LogWriterAppenders.startupComplete(LogWriterAppenders.Identifier.MAIN);
            }
            if (this.securityLogWriterAppender != null) {
                LogWriterAppenders.startupComplete(LogWriterAppenders.Identifier.SECURITY);
            }
            InternalInstantiator.logInstantiators();
        }
        catch (RuntimeException ex) {
            this.config.close();
            throw ex;
        }
        this.resourceListeners = new CopyOnWriteArrayList<ResourceEventsListener>();
        this.reconnected = this.attemptingToReconnect;
        this.attemptingToReconnect = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startInitLocator() throws InterruptedException {
        block9: {
            String locatorString = this.originalConfig.getStartLocator();
            if (locatorString.length() > 0) {
                if (this.attemptingToReconnect && !this.isConnected && this.quorumChecker != null) {
                    logger.info("performing a quorum check to see if location services can be started early");
                    if (!this.quorumChecker.checkForQuorum(3 * this.config.getMemberTimeout())) {
                        logger.info("quorum check failed - not allowing location services to start early");
                        return;
                    }
                    logger.info("Quorum check passed - allowing location services to start early");
                }
                DistributionLocatorId locId = new DistributionLocatorId(locatorString);
                try {
                    this.startedLocator = InternalLocator.createLocator(locId.getPort(), null, null, this.logWriter, this.securityLogWriter, locId.getHost(), locId.getHostnameForClients(), this.originalConfig.toProperties(), false);
                    if (!locId.isPeerLocator()) break block9;
                    boolean startedPeerLocation = false;
                    try {
                        this.startedLocator.startPeerLocation(true);
                        startedPeerLocation = true;
                    }
                    finally {
                        if (!startedPeerLocation) {
                            this.startedLocator.stop();
                        }
                    }
                }
                catch (IOException e) {
                    throw new GemFireIOException(LocalizedStrings.InternalDistributedSystem_PROBLEM_STARTING_A_LOCATOR_SERVICE.toLocalizedString(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endInitLocator() throws IOException {
        InternalLocator loc = this.startedLocator;
        if (loc != null) {
            String locatorString = this.originalConfig.getStartLocator();
            boolean finished = false;
            try {
                loc.startServerLocation(this);
                loc.endStartLocator(this);
                finished = true;
            }
            finally {
                if (!finished) {
                    loc.stop();
                }
            }
        }
    }

    public void setDependentLocator(InternalLocator theLocator) {
        this.startedLocator = theLocator;
    }

    void setDM(DM dm) {
        this.dm = dm;
    }

    private void checkConnected() {
        if (!this.isConnected()) {
            throw new DistributedSystemDisconnectedException(LocalizedStrings.InternalDistributedSystem_THIS_CONNECTION_TO_A_DISTRIBUTED_SYSTEM_HAS_BEEN_DISCONNECTED.toLocalizedString(), this.dm.getRootCause());
        }
    }

    @Override
    public boolean isConnected() {
        if (this.dm == null) {
            return false;
        }
        if (this.dm.getCancelCriterion().isCancelInProgress()) {
            return false;
        }
        if (this.isDisconnecting) {
            return false;
        }
        return this.isConnected;
    }

    @Override
    public CancelCriterion getCancelCriterion() {
        return this.stopper;
    }

    public boolean isDisconnecting() {
        if (this.dm == null) {
            return true;
        }
        if (this.dm.getCancelCriterion().isCancelInProgress()) {
            return true;
        }
        if (!this.isConnected) {
            return true;
        }
        return this.isDisconnecting;
    }

    @Override
    public LogWriter getLogWriter() {
        return this.logWriter;
    }

    public DSClock getClock() {
        return this.clock;
    }

    @Override
    public LogWriter getSecurityLogWriter() {
        return this.securityLogWriter;
    }

    public GemFireStatSampler getStatSampler() {
        return this.sampler;
    }

    @Override
    public void disconnect() {
        this.disconnect(false, LocalizedStrings.InternalDistributedSystem_NORMAL_DISCONNECT.toLocalizedString(), false);
    }

    public void disconnect(String reason, Throwable cause, boolean shunned) {
        boolean isForcedDisconnect = this.dm.getRootCause() instanceof ForcedDisconnectException;
        boolean rejoined = false;
        this.reconnected = false;
        if (isForcedDisconnect) {
            this.forcedDisconnect = true;
            InternalDistributedSystem.resetReconnectAttemptCounter();
            rejoined = this.tryReconnect(true, reason, GemFireCacheImpl.getInstance());
        }
        if (!rejoined) {
            this.disconnect(false, reason, shunned);
        }
    }

    private void runDisconnect(final DisconnectListener dc, ThreadGroup tg) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        InternalDistributedSystem.this.disconnectListenerThread.set(Boolean.TRUE);
                        dc.onDisconnect(InternalDistributedSystem.this);
                    }
                    catch (CancelException e) {
                        if (!logger.isDebugEnabled()) break block2;
                        logger.debug("Disconnect listener <{}> thwarted by cancellation: {}", (Object)dc, (Object)e, (Object)(logger.isTraceEnabled() ? e : null));
                    }
                }
            }
        };
        Thread t = new Thread(tg, r, dc.toString());
        try {
            t.start();
            t.join(MAX_DISCONNECT_WAIT);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.warn((Message)LocalizedMessage.create(LocalizedStrings.InternalDistributedSystem_INTERRUPTED_WHILE_PROCESSING_DISCONNECT_LISTENER), (Throwable)e);
        }
        if (t.isAlive()) {
            logger.warn((Message)LocalizedMessage.create(LocalizedStrings.InternalDistributedSystem_DISCONNECT_LISTENER_STILL_RUNNING__0, dc));
            t.interrupt();
            try {
                t.join(MAX_DISCONNECT_WAIT);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (t.isAlive()) {
                logger.warn((Message)LocalizedMessage.create(LocalizedStrings.InternalDistributedSystem_DISCONNECT_LISTENER_IGNORED_ITS_INTERRUPT__0, dc));
            }
        }
    }

    public boolean isDisconnectListenerThread() {
        Boolean disconnectListenerThreadBoolean = (Boolean)this.disconnectListenerThread.get();
        return disconnectListenerThreadBoolean != null && disconnectListenerThreadBoolean != false;
    }

    private void runDisconnectForReconnect(DisconnectListener dc, ThreadGroup tg) {
        block2: {
            try {
                dc.onDisconnect(this);
            }
            catch (DistributedSystemDisconnectedException e) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Disconnect listener <{}> thwarted by shutdown: {}", (Object)dc, (Object)e, (Object)(logger.isTraceEnabled() ? e : null));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashSet doDisconnects(boolean doReconnect, String reason) {
        HashSet<DisconnectListener> shutdownListeners = new HashSet<DisconnectListener>();
        while (true) {
            DisconnectListener listener = null;
            Set set = this.listeners;
            synchronized (set) {
                Iterator itr = this.listeners.iterator();
                if (!itr.hasNext()) {
                    break;
                }
                listener = (DisconnectListener)itr.next();
                if (listener instanceof ShutdownListener) {
                    shutdownListeners.add(listener);
                }
                itr.remove();
            }
            if (doReconnect) {
                this.runDisconnectForReconnect(listener, this.disconnectListenerThreadGroup);
                continue;
            }
            this.runDisconnect(listener, this.disconnectListenerThreadGroup);
        }
        return shutdownListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doShutdownListeners(HashSet shutdownListeners) {
        if (shutdownListeners == null) {
            return;
        }
        for (ShutdownListener s : shutdownListeners) {
            try {
                s.onShutdown(this);
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                logger.fatal((Message)LocalizedMessage.create(LocalizedStrings.InternalDistributedSystem_SHUTDOWNLISTENER__0__THREW, s), t);
            }
        }
        while (true) {
            DisconnectListener dcListener = null;
            ShutdownListener sdListener = null;
            Set set = this.listeners;
            synchronized (set) {
                Iterator itr = this.listeners.iterator();
                if (!itr.hasNext()) {
                    return;
                }
                dcListener = (DisconnectListener)itr.next();
                itr.remove();
                if (dcListener instanceof ShutdownListener) {
                    sdListener = (ShutdownListener)dcListener;
                }
            }
            this.runDisconnect(dcListener, this.disconnectListenerThreadGroup);
            if (sdListener == null) continue;
            try {
                sdListener.onShutdown(this);
                continue;
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                logger.fatal((Message)LocalizedMessage.create(LocalizedStrings.InternalDistributedSystem_DISCONNECTLISTENERSHUTDOWN_THREW), t);
                continue;
            }
            break;
        }
    }

    public static void loadEmergencyClasses() {
        if (emergencyClassesLoaded) {
            return;
        }
        emergencyClassesLoaded = true;
        GMSMembershipManager.loadEmergencyClasses();
    }

    public void emergencyClose() {
        MembershipManager mm;
        boolean DEBUG = false;
        if (this.dm != null && (mm = this.dm.getMembershipManager()) != null) {
            mm.emergencyClose();
        }
        this.isConnected = false;
        if (this.dm != null) {
            this.dm.setRootCause(SystemFailure.getFailure());
        }
        this.isDisconnecting = true;
        this.listeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDisconnected() {
        Object object = this.isConnectedMutex;
        synchronized (object) {
            this.isConnected = false;
            this.isConnectedMutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitDisconnected() {
        Object object = this.isConnectedMutex;
        synchronized (object) {
            while (this.isConnected) {
                boolean interrupted = Thread.interrupted();
                try {
                    this.isConnectedMutex.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    this.getLogWriter().convertToLogWriterI18n().warning(LocalizedStrings.InternalDistributedSystem_DISCONNECT_WAIT_INTERRUPTED, e);
                }
                finally {
                    if (!interrupted) continue;
                    Thread.currentThread().interrupt();
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void disconnect(boolean preparingForReconnect, String reason, boolean keepAlive) {
        boolean isShutdownHook;
        boolean bl = isShutdownHook = shutdownHook != null && Thread.currentThread() == shutdownHook;
        if (!preparingForReconnect) {
            List<ReconnectListener> list = reconnectListeners;
            synchronized (list) {
                reconnectListeners.clear();
            }
            this.cancelReconnect();
        }
        boolean isDebugEnabled = logger.isDebugEnabled();
        try {
            HashSet shutdownListeners = null;
            if (isDebugEnabled) {
                logger.debug("DistributedSystem.disconnect invoked on {}", (Object)this);
            }
            Class<GemFireCacheImpl> clazz = GemFireCacheImpl.class;
            synchronized (GemFireCacheImpl.class) {
                GemFireCacheImpl currentCache = GemFireCacheImpl.getInstance();
                if (currentCache != null && !currentCache.isClosed()) {
                    this.disconnectListenerThread.set(Boolean.TRUE);
                    try {
                        currentCache.close(reason, this.dm.getRootCause(), keepAlive, true);
                    }
                    catch (VirtualMachineError e) {
                        SystemFailure.initiateFailure(e);
                        throw e;
                    }
                    catch (Throwable e) {
                        SystemFailure.checkFailure();
                        logger.warn((Message)LocalizedMessage.create(LocalizedStrings.InternalDistributedSystem_EXCEPTION_TRYING_TO_CLOSE_CACHE), e);
                    }
                    finally {
                        this.disconnectListenerThread.set(Boolean.FALSE);
                    }
                }
                InternalDistributedSystem internalDistributedSystem = this;
                synchronized (internalDistributedSystem) {
                    if (this.isDisconnecting) {
                        this.waitDisconnected();
                        // MONITOREXIT @DISABLED, blocks:[64, 1, 2, 24, 25] lbl36 : MonitorExitStatement: MONITOREXIT : var9_12
                        // ** MonitorExit[var7_8] (shouldn't be in output)
                        try {
                            this.dm.close();
                            if (this.startedLocator == null) return;
                            this.startedLocator.stop(this.forcedDisconnect, preparingForReconnect, false);
                            this.startedLocator = null;
                            return;
                        }
                        finally {
                            if (!preparingForReconnect) {
                                SystemTimer.cancelSwarm(this);
                            }
                        }
                    }
                    this.isDisconnecting = true;
                    if (!preparingForReconnect && this.reconnectDS != null) {
                        if (isDebugEnabled) {
                            logger.debug("disconnecting reconnected DS: {}", (Object)this.reconnectDS);
                        }
                        InternalDistributedSystem r = this.reconnectDS;
                        this.reconnectDS = null;
                        r.disconnect(false, null, false);
                    }
                }
                // ** MonitorExit[var7_8] (shouldn't be in output)
                if (!isShutdownHook) {
                    shutdownListeners = this.doDisconnects(this.attemptingToReconnect, reason);
                }
                if (!this.attemptingToReconnect) {
                    if (this.logWriterAppender != null) {
                        LogWriterAppenders.stop(LogWriterAppenders.Identifier.MAIN);
                    }
                    if (this.securityLogWriterAppender != null) {
                        LogWriterAppenders.stop(LogWriterAppenders.Identifier.SECURITY);
                    }
                }
                AlertAppender.getInstance().shuttingDown();
            }
            {
                if (!isShutdownHook) {
                    this.doShutdownListeners(shutdownListeners);
                }
                if (this.functionServiceStats != null) {
                    this.functionServiceStats.close();
                }
                for (FunctionStats functionstats : this.functionExecutionStatsMap.values()) {
                    functionstats.close();
                }
                new FunctionServiceManager().unregisterAllFunctions();
                if (this.sampler != null) {
                    this.sampler.stop();
                    this.sampler = null;
                }
                if (!this.attemptingToReconnect) {
                    if (this.logWriterAppender != null) {
                        LogWriterAppenders.destroy(LogWriterAppenders.Identifier.MAIN);
                    }
                    if (this.securityLogWriterAppender != null) {
                        LogWriterAppenders.destroy(LogWriterAppenders.Identifier.SECURITY);
                    }
                }
                LoggingThreadGroup.cleanUpThreadGroups();
                EventID.unsetDS();
                return;
            }
        }
        finally {
            try {
                if (this.getOffHeapStore() != null) {
                    this.getOffHeapStore().close();
                }
            }
            finally {
                try {
                    InternalDistributedSystem.removeSystem(this);
                    this.config.close();
                }
                finally {
                    this.setDisconnected();
                    SystemFailure.stopThreads();
                }
            }
        }
    }

    public DM getDistributionManager() {
        this.checkConnected();
        return this.dm;
    }

    public final DM getDM() {
        return this.dm;
    }

    public final QuorumChecker getQuorumChecker() {
        return this.quorumChecker;
    }

    public boolean isReconnectCancelled() {
        return this.reconnectCancelled;
    }

    public boolean sameAs(Properties props, boolean isConnected) {
        return this.originalConfig.sameAs(DistributionConfigImpl.produce(props, isConnected));
    }

    public boolean threadOwnsResources() {
        Boolean b = ConnectionTable.getThreadOwnsResourcesRegistration();
        if (b == null) {
            return !this.shareSockets;
        }
        return b;
    }

    public boolean sameSystemAs(Properties props) {
        String otherLocators;
        DistributionConfigImpl other = DistributionConfigImpl.produce(props);
        DistributionConfig me = this.getConfig();
        if (!me.getBindAddress().equals(other.getBindAddress())) {
            return false;
        }
        String myLocators = me.getLocators();
        if (myLocators.equals(otherLocators = other.getLocators())) {
            return true;
        }
        myLocators = InternalDistributedSystem.canonicalizeLocators(myLocators);
        otherLocators = InternalDistributedSystem.canonicalizeLocators(otherLocators);
        return myLocators.equals(otherLocators);
    }

    private static String canonicalizeLocators(String locators) {
        TreeSet<String> sorted = new TreeSet<String>();
        StringTokenizer st = new StringTokenizer(locators, ",");
        while (st.hasMoreTokens()) {
            String l = st.nextToken();
            StringBuffer canonical = new StringBuffer();
            DistributionLocatorId locId = new DistributionLocatorId(l);
            String addr = locId.getBindAddress();
            if (addr != null && addr.trim().length() > 0) {
                canonical.append(addr);
            } else {
                canonical.append(locId.getHost().getHostAddress());
            }
            canonical.append("[");
            canonical.append(String.valueOf(locId.getPort()));
            canonical.append("]");
            sorted.add(canonical.toString());
        }
        StringBuffer sb = new StringBuffer();
        Iterator iter = sorted.iterator();
        while (iter.hasNext()) {
            sb.append((String)iter.next());
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public DistributionConfig getConfig() {
        return this.config;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getMemberId() {
        return String.valueOf(this.dm.getId());
    }

    @Override
    public InternalDistributedMember getDistributedMember() {
        return this.dm.getId();
    }

    @Override
    public Set<DistributedMember> getAllOtherMembers() {
        return this.dm.getAllOtherMembers();
    }

    @Override
    public Set<DistributedMember> getGroupMembers(String group) {
        return this.dm.getGroupMembers(group);
    }

    @Override
    public Set<DistributedMember> findDistributedMembers(InetAddress address) {
        Set allMembers = this.dm.getDistributionManagerIdsIncludingAdmin();
        HashSet<DistributedMember> results = new HashSet<DistributedMember>(2);
        for (InternalDistributedMember member : allMembers) {
            Set<InetAddress> equivalentAddresses = this.dm.getEquivalents(member.getInetAddress());
            if (!address.equals(member.getInetAddress()) && !equivalentAddresses.contains(address)) continue;
            results.add(member);
        }
        return results;
    }

    @Override
    public DistributedMember findDistributedMember(String name) {
        Set allMembers = this.dm.getDistributionManagerIdsIncludingAdmin();
        for (DistributedMember member : allMembers) {
            if (!member.getName().equals(name)) continue;
            return member;
        }
        return null;
    }

    public DistributionConfig getOriginalConfig() {
        return this.originalConfig;
    }

    @Override
    public String getName() {
        return this.getOriginalConfig().getName();
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Connected ");
        String name = this.getName();
        if (name != null && !name.equals("")) {
            sb.append("\"");
            sb.append(name);
            sb.append("\" ");
        }
        sb.append("(id=");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(") ");
        sb.append("to distributed system using ");
        int port = this.config.getMcastPort();
        if (port != 0) {
            sb.append("multicast port ");
            sb.append(port);
            sb.append(" ");
        } else {
            sb.append("locators \"");
            sb.append(this.config.getLocators());
            sb.append("\" ");
        }
        File logFile = this.config.getLogFile();
        sb.append("logging to ");
        if (logFile == null || logFile.equals(new File(""))) {
            sb.append("standard out ");
        } else {
            sb.append(logFile);
            sb.append(" ");
        }
        sb.append(" started at ");
        sb.append(new Date(this.startTime).toString());
        if (!this.isConnected()) {
            sb.append(" (closed)");
        }
        return sb.toString().trim();
    }

    @Override
    public int getStatListModCount() {
        return this.statsListModCount;
    }

    @Override
    public List<Statistics> getStatsList() {
        return this.statsList;
    }

    @Override
    public final int getStatisticsCount() {
        int result = 0;
        CopyOnWriteArrayList<Statistics> statsList = this.statsList;
        if (statsList != null) {
            result = statsList.size();
        }
        return result;
    }

    @Override
    public final Statistics findStatistics(long id) {
        CopyOnWriteArrayList<Statistics> statsList = this.statsList;
        for (Statistics s : statsList) {
            if (s.getUniqueId() != id) continue;
            return s;
        }
        throw new RuntimeException(LocalizedStrings.PureStatSampler_COULD_NOT_FIND_STATISTICS_INSTANCE.toLocalizedString());
    }

    @Override
    public final boolean statisticsExists(long id) {
        CopyOnWriteArrayList<Statistics> statsList = this.statsList;
        for (Statistics s : statsList) {
            if (s.getUniqueId() != id) continue;
            return true;
        }
        return false;
    }

    @Override
    public final Statistics[] getStatistics() {
        CopyOnWriteArrayList<Statistics> statsList = this.statsList;
        return statsList.toArray(new Statistics[0]);
    }

    @Override
    public Statistics createStatistics(StatisticsType type) {
        return this.createOsStatistics(type, null, 0L, 0);
    }

    @Override
    public Statistics createStatistics(StatisticsType type, String textId) {
        return this.createOsStatistics(type, textId, 0L, 0);
    }

    @Override
    public Statistics createStatistics(StatisticsType type, String textId, long numericId) {
        return this.createOsStatistics(type, textId, numericId, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statistics createOsStatistics(StatisticsType type, String textId, long numericId, int osStatFlags) {
        long myUniqueId;
        if (this.statsDisabled) {
            return new DummyStatisticsImpl(type, textId, numericId);
        }
        Object object = this.statsListUniqueIdLock;
        synchronized (object) {
            myUniqueId = this.statsListUniqueId++;
        }
        LocalStatisticsImpl result = new LocalStatisticsImpl(type, textId, numericId, myUniqueId, false, osStatFlags, this);
        CopyOnWriteArrayList<Statistics> copyOnWriteArrayList = this.statsList;
        synchronized (copyOnWriteArrayList) {
            this.statsList.add(result);
            ++this.statsListModCount;
        }
        return result;
    }

    public FunctionStats getFunctionStats(String textId) {
        FunctionStats oldStats;
        FunctionStats stats = this.functionExecutionStatsMap.get(textId);
        if (stats == null && (oldStats = this.functionExecutionStatsMap.putIfAbsent(textId, stats = new FunctionStats(this, textId))) != null) {
            stats.close();
            stats = oldStats;
        }
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FunctionServiceStats getFunctionServiceStats() {
        if (this.functionServiceStats == null) {
            InternalDistributedSystem internalDistributedSystem = this;
            synchronized (internalDistributedSystem) {
                if (this.functionServiceStats == null) {
                    this.functionServiceStats = new FunctionServiceStats(this, "FunctionExecution");
                }
            }
        }
        return this.functionServiceStats;
    }

    public void visitStatistics(StatisticsVisitor visitor) {
        for (Statistics s : this.statsList) {
            visitor.visit(s);
        }
    }

    public Set<String> getAllFunctionExecutionIds() {
        return this.functionExecutionStatsMap.keySet();
    }

    @Override
    public Statistics[] findStatisticsByType(final StatisticsType type) {
        final ArrayList hits = new ArrayList();
        this.visitStatistics(new StatisticsVisitor(){

            @Override
            public void visit(Statistics s) {
                if (type == s.getType()) {
                    hits.add(s);
                }
            }
        });
        Statistics[] result = new Statistics[hits.size()];
        return hits.toArray(result);
    }

    @Override
    public Statistics[] findStatisticsByTextId(final String textId) {
        final ArrayList hits = new ArrayList();
        this.visitStatistics(new StatisticsVisitor(){

            @Override
            public void visit(Statistics s) {
                if (s.getTextId().equals(textId)) {
                    hits.add(s);
                }
            }
        });
        Statistics[] result = new Statistics[hits.size()];
        return hits.toArray(result);
    }

    @Override
    public Statistics[] findStatisticsByNumericId(final long numericId) {
        final ArrayList hits = new ArrayList();
        this.visitStatistics(new StatisticsVisitor(){

            @Override
            public void visit(Statistics s) {
                if (numericId == s.getNumericId()) {
                    hits.add(s);
                }
            }
        });
        Statistics[] result = new Statistics[hits.size()];
        return hits.toArray(result);
    }

    public Statistics findStatisticsByUniqueId(long uniqueId) {
        for (Statistics s : this.statsList) {
            if (uniqueId != s.getUniqueId()) continue;
            return s;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyStatistics(Statistics stats) {
        CopyOnWriteArrayList<Statistics> copyOnWriteArrayList = this.statsList;
        synchronized (copyOnWriteArrayList) {
            if (this.statsList.remove(stats)) {
                ++this.statsListModCount;
            }
        }
    }

    @Override
    public Statistics createAtomicStatistics(StatisticsType type) {
        return this.createAtomicStatistics(type, null, 0L);
    }

    @Override
    public Statistics createAtomicStatistics(StatisticsType type, String textId) {
        return this.createAtomicStatistics(type, textId, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statistics createAtomicStatistics(StatisticsType type, String textId, long numericId) {
        long myUniqueId;
        if (this.statsDisabled) {
            return new DummyStatisticsImpl(type, textId, numericId);
        }
        Object object = this.statsListUniqueIdLock;
        synchronized (object) {
            myUniqueId = this.statsListUniqueId++;
        }
        Statistics result = StatisticsImpl.createAtomicNoOS(type, textId, numericId, myUniqueId, this);
        CopyOnWriteArrayList<Statistics> copyOnWriteArrayList = this.statsList;
        synchronized (copyOnWriteArrayList) {
            this.statsList.add(result);
            ++this.statsListModCount;
        }
        return result;
    }

    @Override
    public StatisticsType createType(String name, String description, StatisticDescriptor[] stats) {
        return tf.createType(name, description, stats);
    }

    @Override
    public StatisticsType findType(String name) {
        return tf.findType(name);
    }

    @Override
    public StatisticsType[] createTypesFromXml(Reader reader) throws IOException {
        return tf.createTypesFromXml(reader);
    }

    @Override
    public StatisticDescriptor createIntCounter(String name, String description, String units) {
        return tf.createIntCounter(name, description, units);
    }

    @Override
    public StatisticDescriptor createLongCounter(String name, String description, String units) {
        return tf.createLongCounter(name, description, units);
    }

    @Override
    public StatisticDescriptor createDoubleCounter(String name, String description, String units) {
        return tf.createDoubleCounter(name, description, units);
    }

    @Override
    public StatisticDescriptor createIntGauge(String name, String description, String units) {
        return tf.createIntGauge(name, description, units);
    }

    @Override
    public StatisticDescriptor createLongGauge(String name, String description, String units) {
        return tf.createLongGauge(name, description, units);
    }

    @Override
    public StatisticDescriptor createDoubleGauge(String name, String description, String units) {
        return tf.createDoubleGauge(name, description, units);
    }

    @Override
    public StatisticDescriptor createIntCounter(String name, String description, String units, boolean largerBetter) {
        return tf.createIntCounter(name, description, units, largerBetter);
    }

    @Override
    public StatisticDescriptor createLongCounter(String name, String description, String units, boolean largerBetter) {
        return tf.createLongCounter(name, description, units, largerBetter);
    }

    @Override
    public StatisticDescriptor createDoubleCounter(String name, String description, String units, boolean largerBetter) {
        return tf.createDoubleCounter(name, description, units, largerBetter);
    }

    @Override
    public StatisticDescriptor createIntGauge(String name, String description, String units, boolean largerBetter) {
        return tf.createIntGauge(name, description, units, largerBetter);
    }

    @Override
    public StatisticDescriptor createLongGauge(String name, String description, String units, boolean largerBetter) {
        return tf.createLongGauge(name, description, units, largerBetter);
    }

    @Override
    public StatisticDescriptor createDoubleGauge(String name, String description, String units, boolean largerBetter) {
        return tf.createDoubleGauge(name, description, units, largerBetter);
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List addConnectListener(ConnectListener listener) {
        Object object = existingSystemsLock;
        synchronized (object) {
            Set set = connectListeners;
            synchronized (set) {
                connectListeners.add(listener);
                return existingSystems;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addReconnectListener(ReconnectListener listener) {
        Object object = existingSystemsLock;
        synchronized (object) {
            List<ReconnectListener> list = reconnectListeners;
            synchronized (list) {
                reconnectListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeConnectListener(ConnectListener listener) {
        Set set = connectListeners;
        synchronized (set) {
            return connectListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyConnectListeners(InternalDistributedSystem sys) {
        Set set = connectListeners;
        synchronized (set) {
            Iterator iter = connectListeners.iterator();
            while (iter.hasNext()) {
                try {
                    ConnectListener listener = (ConnectListener)iter.next();
                    listener.onConnect(sys);
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable t) {
                    SystemFailure.checkFailure();
                    sys.getLogWriter().convertToLogWriterI18n().severe(LocalizedStrings.InternalDistributedSystem_CONNECTLISTENER_THREW, t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeReconnectListener(ReconnectListener listener) {
        List<ReconnectListener> list = reconnectListeners;
        synchronized (list) {
            reconnectListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyReconnectListeners(InternalDistributedSystem oldsys, InternalDistributedSystem newsys, boolean starting) {
        ArrayList<ReconnectListener> listeners;
        List<ReconnectListener> list = reconnectListeners;
        synchronized (list) {
            listeners = new ArrayList<ReconnectListener>(reconnectListeners);
        }
        for (ReconnectListener listener : listeners) {
            try {
                if (starting) {
                    listener.reconnecting(oldsys);
                    continue;
                }
                listener.onReconnect(oldsys, newsys);
            }
            catch (Throwable t) {
                if (t instanceof OutOfMemoryError || t instanceof UnknownError) {
                    Error err = (Error)t;
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                SystemFailure.checkFailure();
                logger.fatal((Message)LocalizedMessage.create(LocalizedStrings.InternalDistributedSystem_CONNECTLISTENER_THREW), t);
            }
        }
    }

    private void notifyResourceEventListeners(ResourceEvent event, Object resource) {
        Iterator<ResourceEventsListener> iter = this.resourceListeners.iterator();
        while (iter.hasNext()) {
            try {
                ResourceEventsListener listener = iter.next();
                listener.handleEvent(event, resource);
            }
            catch (CancelException listener) {
            }
            catch (ManagementException | GemFireSecurityException ex) {
                if (event == ResourceEvent.CACHE_CREATE) {
                    throw ex;
                }
                logger.warn(ex.getMessage(), (Throwable)ex);
            }
            catch (Exception err) {
                logger.warn(err.getMessage(), (Throwable)err);
            }
            catch (VirtualMachineError e) {
                SystemFailure.initiateFailure(e);
                throw e;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                logger.warn(t.getMessage(), t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDisconnectListener(DisconnectListener listener) {
        Set set = this.listeners;
        synchronized (set) {
            String reason;
            this.listeners.add(listener);
            Boolean disconnectListenerThreadBoolean = (Boolean)this.disconnectListenerThread.get();
            if (!(disconnectListenerThreadBoolean != null && disconnectListenerThreadBoolean.booleanValue() || (reason = this.stopper.cancelInProgress()) == null)) {
                this.listeners.remove(listener);
                throw new DistributedSystemDisconnectedException(LocalizedStrings.InternalDistributedSystem_NO_LISTENERS_PERMITTED_AFTER_SHUTDOWN_0.toLocalizedString(reason), this.dm.getRootCause());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeDisconnectListener(DisconnectListener listener) {
        Set set = this.listeners;
        synchronized (set) {
            return this.listeners.remove(listener);
        }
    }

    public static InternalDistributedSystem getAnyInstance() {
        List l = existingSystems;
        if (l.isEmpty()) {
            return null;
        }
        return (InternalDistributedSystem)l.get(0);
    }

    public static List getExistingSystems() {
        return existingSystems;
    }

    @Override
    public Properties getProperties() {
        return this.config.toProperties();
    }

    @Override
    public Properties getSecurityProperties() {
        return this.config.getSecurityProps();
    }

    public void fireInfoEvent(Object callback) {
        throw new UnsupportedOperationException(LocalizedStrings.InternalDistributedSystem_NOT_IMPLEMENTED_YET.toLocalizedString());
    }

    @Override
    public boolean isReconnecting() {
        boolean newDsConnected;
        InternalDistributedSystem rds = this.reconnectDS;
        if (!this.attemptingToReconnect) {
            return false;
        }
        if (this.reconnectCancelled) {
            return false;
        }
        boolean bl = newDsConnected = rds == null || !rds.isConnected();
        return newDsConnected;
    }

    public boolean isReconnectingDS() {
        return this.isReconnectingDS;
    }

    public Object oldDSMembershipInfo() {
        if (this.quorumChecker != null) {
            return this.quorumChecker.getMembershipInfo();
        }
        return null;
    }

    public boolean reconnected() {
        return this.reconnected;
    }

    public boolean forcedDisconnect() {
        return this.forcedDisconnect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelReconnect() {
        this.reconnectCancelled = true;
        if (this.isReconnecting()) {
            Object object = this.reconnectLock;
            synchronized (object) {
                this.reconnectLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryReconnect(boolean forcedDisconnect, String reason, GemFireCacheImpl oldCache) {
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (this.isReconnectingDS && forcedDisconnect) {
            return false;
        }
        Class<CacheFactory> clazz = CacheFactory.class;
        synchronized (CacheFactory.class) {
            Class<GemFireCacheImpl> clazz2 = GemFireCacheImpl.class;
            synchronized (GemFireCacheImpl.class) {
                Object object = this.reconnectLock;
                synchronized (object) {
                    if (!forcedDisconnect && !oldCache.isClosed() && oldCache.getCachePerfStats().getReliableRegionsMissing() == 0) {
                        if (isDebugEnabled) {
                            logger.debug("tryReconnect: No required roles are missing.");
                        }
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 4, 5, 6, 14] lbl16 : MonitorExitStatement: MONITOREXIT : var7_7
                        // ** MonitorExit[var6_6] (shouldn't be in output)
                        // ** MonitorExit[var5_5] (shouldn't be in output)
                        return false;
                    }
                    if (isDebugEnabled) {
                        logger.debug("tryReconnect: forcedDisconnect={}", (Object)forcedDisconnect);
                    }
                    if (forcedDisconnect && this.config.getDisableAutoReconnect()) {
                        if (isDebugEnabled) {
                            logger.debug("tryReconnect: auto reconnect after forced disconnect is disabled");
                        }
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 4, 5, 6, 11] lbl25 : MonitorExitStatement: MONITOREXIT : var7_7
                        // ** MonitorExit[var6_6] (shouldn't be in output)
                        // ** MonitorExit[var5_5] (shouldn't be in output)
                        return false;
                    }
                    this.reconnect(forcedDisconnect, reason);
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 4, 5, 6] lbl30 : MonitorExitStatement: MONITOREXIT : var7_7
                    // ** MonitorExit[var6_6] (shouldn't be in output)
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                    return this.reconnectDS != null && this.reconnectDS.isConnected();
                }
            }
        }
    }

    public static int getReconnectAttemptCounter() {
        return reconnectAttemptCounter;
    }

    /*
     * Exception decompiling
     */
    private void reconnect(boolean forcedDisconnect, String reason) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void createAndStartCacheServers(List<CacheServerCreation> cacheServerCreation, GemFireCacheImpl cache) {
        List servers = cache.getCacheServers();
        if (servers.isEmpty() && cacheServerCreation != null) {
            for (CacheServerCreation bridge : cacheServerCreation) {
                CacheServerImpl impl = (CacheServerImpl)cache.addCacheServer();
                impl.configureFrom(bridge);
            }
        }
        servers = cache.getCacheServers();
        for (CacheServer server : servers) {
            try {
                if (server.isRunning()) continue;
                server.start();
            }
            catch (IOException ex) {
                throw new GemFireIOException(LocalizedStrings.CacheCreation_WHILE_STARTING_CACHE_SERVER_0.toLocalizedString(server), ex);
            }
        }
    }

    public void validateSameProperties(Properties propsToCheck, boolean isConnected) {
        if (!this.sameAs(propsToCheck, isConnected)) {
            StringBuffer sb = new StringBuffer();
            DistributionConfigImpl wanted = DistributionConfigImpl.produce(propsToCheck);
            String[] validAttributeNames = this.originalConfig.getAttributeNames();
            for (int i = 0; i < validAttributeNames.length; ++i) {
                String attName = validAttributeNames[i];
                Object expectedAtt = wanted.getAttributeObject(attName);
                String expectedAttStr = expectedAtt.toString();
                Object actualAtt = this.originalConfig.getAttributeObject(attName);
                String actualAttStr = actualAtt.toString();
                sb.append("  ");
                sb.append(attName);
                sb.append("=\"");
                if (actualAtt.getClass().isArray()) {
                    actualAttStr = InternalDistributedSystem.arrayToString(actualAtt);
                    expectedAttStr = InternalDistributedSystem.arrayToString(expectedAtt);
                }
                sb.append(actualAttStr);
                sb.append("\"");
                if (!expectedAttStr.equals(actualAttStr)) {
                    sb.append(" ***(wanted \"");
                    sb.append(expectedAtt);
                    sb.append("\")***");
                }
                sb.append("\n");
            }
            if (this.creationStack == null) {
                throw new IllegalStateException(LocalizedStrings.InternalDistributedSystem_A_CONNECTION_TO_A_DISTRIBUTED_SYSTEM_ALREADY_EXISTS_IN_THIS_VM_IT_HAS_THE_FOLLOWING_CONFIGURATION_0.toLocalizedString(sb.toString()));
            }
            throw new IllegalStateException(LocalizedStrings.InternalDistributedSystem_A_CONNECTION_TO_A_DISTRIBUTED_SYSTEM_ALREADY_EXISTS_IN_THIS_VM_IT_HAS_THE_FOLLOWING_CONFIGURATION_0.toLocalizedString(sb.toString()), this.creationStack);
        }
    }

    public static String arrayToString(Object obj) {
        if (!obj.getClass().isArray()) {
            return "-not-array-object-";
        }
        StringBuilder buff = new StringBuilder("[");
        int arrayLength = Array.getLength(obj);
        for (int i = 0; i < arrayLength - 1; ++i) {
            buff.append(Array.get(obj, i).toString());
            buff.append(",");
        }
        if (arrayLength > 0) {
            buff.append(Array.get(obj, arrayLength - 1).toString());
        }
        buff.append("]");
        return buff.toString();
    }

    public boolean isShareSockets() {
        return this.shareSockets;
    }

    public void setShareSockets(boolean shareSockets) {
        this.shareSockets = shareSockets;
    }

    public String forceStop() {
        if (this.dm == null) {
            return LocalizedStrings.InternalDistributedSystem_NO_DISTRIBUTION_MANAGER.toLocalizedString();
        }
        String reason = this.dm.getCancelCriterion().cancelInProgress();
        return reason;
    }

    public boolean hasAlertListenerFor(DistributedMember member) {
        return this.hasAlertListenerFor(member, AlertLevel.WARNING.getSeverity());
    }

    public boolean hasAlertListenerFor(DistributedMember member, int severity) {
        return AlertAppender.getInstance().hasAlertListener(member, severity);
    }

    public static void setEnableAdministrationOnly(boolean adminOnly) {
        DistributedSystem.setEnableAdministrationOnly(adminOnly);
    }

    public static void setCommandLineAdmin(boolean adminOnly) {
        DistributedSystem.setEnableAdministrationOnly(adminOnly);
        DistributionManager.isCommandLineAdminVM = adminOnly;
    }

    public boolean isServerLocator() {
        return this.startedLocator.isServerLocator();
    }

    public long systemTimeMillis() {
        return this.dm.cacheTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitUntilReconnected(long time, TimeUnit units) throws InterruptedException {
        int sleepTime = 1000;
        long endTime = System.currentTimeMillis();
        endTime = time < 0L ? Long.MAX_VALUE : (endTime += TimeUnit.MILLISECONDS.convert(time, units));
        Object object = this.reconnectLock;
        synchronized (object) {
            InternalDistributedSystem recon = this.reconnectDS;
            while (this.isReconnecting() && !this.reconnectCancelled) {
                if (time != 0L) {
                    this.reconnectLock.wait(sleepTime);
                }
                if (time != 0L && System.currentTimeMillis() <= endTime) continue;
            }
            recon = this.reconnectDS;
            return !this.attemptingToReconnect && recon != null && recon.isConnected();
        }
    }

    @Override
    public DistributedSystem getReconnectedSystem() {
        return this.reconnectDS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopReconnecting() {
        this.reconnectCancelled = true;
        Object object = this.reconnectLock;
        synchronized (object) {
            this.reconnectLock.notify();
        }
        this.disconnect(false, "stopReconnecting was invoked", false);
        this.attemptingToReconnect = false;
    }

    static {
        DEFAULT_CREATION_STACK_GENERATOR = new CreationStackGenerator(){

            @Override
            public Throwable generateCreationStack(DistributionConfig config) {
                return null;
            }
        };
        TEST_CREATION_STACK_GENERATOR = new AtomicReference<CreationStackGenerator>(DEFAULT_CREATION_STACK_GENERATOR);
        connectListeners = new LinkedHashSet();
        reconnectListeners = new ArrayList<ReconnectListener>();
        MAX_DISCONNECT_WAIT = Long.getLong("DistributionManager.DISCONNECT_WAIT", 10000L);
        emergencyClassesLoaded = false;
        tf = StatisticsTypeFactoryImpl.singleton();
        LoggingThreadGroup tg = LoggingThreadGroup.createThreadGroup(SHUTDOWN_HOOK_NAME);
        Thread tmp_shutdownHook = null;
        try {
            if (!Boolean.getBoolean(DISABLE_SHUTDOWN_HOOK_PROPERTY)) {
                tmp_shutdownHook = new Thread(tg, new Runnable(){

                    @Override
                    public void run() {
                        InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
                        DistributedSystem.setThreadsSocketPolicy(true);
                        if (ds != null && ((DistributedSystem)ds).isConnected()) {
                            InternalLogWriter log = ds.getInternalLogWriter();
                            log.info(LocalizedStrings.InternalDistributedSystem_shutdownHook_shuttingdown);
                            DurableClientAttributes dca = ds.getDistributedMember().getDurableClientAttributes();
                            boolean isDurableClient = false;
                            if (dca != null) {
                                isDurableClient = dca.getId() != null && !dca.getId().isEmpty();
                            }
                            ds.disconnect(false, LocalizedStrings.InternalDistributedSystem_NORMAL_DISCONNECT.toLocalizedString(), isDurableClient);
                        }
                    }
                }, SHUTDOWN_HOOK_NAME);
                Runtime.getRuntime().addShutdownHook(tmp_shutdownHook);
            }
        }
        finally {
            shutdownHook = tmp_shutdownHook;
        }
        reconnectAttemptCounter = 0;
    }

    public static interface CreationStackGenerator {
        public Throwable generateCreationStack(DistributionConfig var1);
    }

    public static interface ConnectListener {
        public void onConnect(InternalDistributedSystem var1);
    }

    public static interface ShutdownListener
    extends DisconnectListener {
        public void onShutdown(InternalDistributedSystem var1);
    }

    public static interface ReconnectListener {
        public void reconnecting(InternalDistributedSystem var1);

        public void onReconnect(InternalDistributedSystem var1, InternalDistributedSystem var2);
    }

    public static interface DisconnectListener {
        public void onDisconnect(InternalDistributedSystem var1);
    }

    public static interface StatisticsVisitor {
        public void visit(Statistics var1);
    }

    protected class Stopper
    extends CancelCriterion {
        protected Stopper() {
        }

        @Override
        public String cancelInProgress() {
            this.checkFailure();
            if (InternalDistributedSystem.this.dm == null) {
                return "No dm";
            }
            return InternalDistributedSystem.this.dm.getCancelCriterion().cancelInProgress();
        }

        @Override
        public RuntimeException generateCancelledException(Throwable e) {
            if (InternalDistributedSystem.this.dm == null) {
                return new DistributedSystemDisconnectedException("no dm", e);
            }
            return InternalDistributedSystem.this.dm.getCancelCriterion().generateCancelledException(e);
        }
    }
}

