/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal.index;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.query.AmbiguousNameException;
import org.apache.geode.cache.query.FunctionDomainException;
import org.apache.geode.cache.query.IndexStatistics;
import org.apache.geode.cache.query.IndexType;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.QueryException;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.CompiledValue;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.cache.query.internal.MapIndexable;
import org.apache.geode.cache.query.internal.RuntimeIterator;
import org.apache.geode.cache.query.internal.index.AbstractIndex;
import org.apache.geode.cache.query.internal.index.IMQException;
import org.apache.geode.cache.query.internal.index.IndexCreationHelper;
import org.apache.geode.cache.query.internal.index.IndexStats;
import org.apache.geode.cache.query.types.ObjectType;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.RegionEntry;

public abstract class AbstractMapIndex
extends AbstractIndex {
    protected final boolean isAllKeys;
    final String[] patternStr;
    protected final Map<Object, AbstractIndex> mapKeyToValueIndex = new ConcurrentHashMap<Object, AbstractIndex>(2, 0.75f, 1);
    protected final Object[] mapKeys;

    AbstractMapIndex(String indexName, Region region, String fromClause, String indexedExpression, String projectionAttributes, String origFromClause, String origIndxExpr, String[] defintions, boolean isAllKeys, String[] multiIndexingKeysPattern, Object[] mapKeys, IndexStatistics stats) {
        super(indexName, region, fromClause, indexedExpression, projectionAttributes, origFromClause, origIndxExpr, defintions, stats);
        RegionAttributes ra = region.getAttributes();
        this.isAllKeys = isAllKeys;
        this.mapKeys = mapKeys;
        this.patternStr = this.isAllKeys ? new String[]{new StringBuilder(indexedExpression).deleteCharAt(indexedExpression.length() - 2).toString()} : multiIndexingKeysPattern;
    }

    @Override
    void addMapping(RegionEntry entry) throws IMQException {
        this.evaluator.evaluate(entry, true);
    }

    @Override
    protected AbstractIndex.InternalIndexStatistics createStats(String indexName) {
        if (!(this.region instanceof BucketRegion)) {
            return new MapIndexStatistics(indexName);
        }
        return new AbstractIndex.InternalIndexStatistics(){};
    }

    @Override
    public ObjectType getResultSetType() {
        return this.evaluator.getIndexResultSetType();
    }

    @Override
    void instantiateEvaluator(IndexCreationHelper ich) {
        this.evaluator = new AbstractIndex.IMQEvaluator(ich);
    }

    @Override
    public void initializeIndex(boolean loadEntries) throws IMQException {
        this.evaluator.initializeIndex(loadEntries);
    }

    @Override
    void lockedQuery(Object key, int operator, Collection results, CompiledValue iterOps, RuntimeIterator runtimeItr, ExecutionContext context, List projAttrib, SelectResults intermediateResults, boolean isIntersection) throws TypeMismatchException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException {
        Object[] mapKeyAndVal = (Object[])key;
        AbstractIndex ri = this.mapKeyToValueIndex.get(mapKeyAndVal[1]);
        if (ri != null) {
            ri.lockedQuery(mapKeyAndVal[0], operator, results, iterOps, runtimeItr, context, projAttrib, intermediateResults, isIntersection);
        }
    }

    @Override
    void lockedQuery(Object lowerBoundKey, int lowerBoundOperator, Object upperBoundKey, int upperBoundOperator, Collection results, Set keysToRemove, ExecutionContext context) throws TypeMismatchException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException {
        throw new UnsupportedOperationException("Range grouping for MapIndex condition is not supported");
    }

    @Override
    void lockedQuery(Object key, int operator, Collection results, Set keysToRemove, ExecutionContext context) throws TypeMismatchException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException {
        Object[] mapKeyAndVal = (Object[])key;
        AbstractIndex ri = this.mapKeyToValueIndex.get(mapKeyAndVal[1]);
        if (ri != null) {
            ri.lockedQuery(mapKeyAndVal[0], operator, results, keysToRemove, context);
        }
    }

    @Override
    abstract void recreateIndexData() throws IMQException;

    @Override
    protected abstract void removeMapping(RegionEntry var1, int var2) throws IMQException;

    @Override
    public boolean clear() throws QueryException {
        throw new UnsupportedOperationException("MapType Index method not supported");
    }

    @Override
    public int getSizeEstimate(Object key, int op, int matchLevel) throws TypeMismatchException {
        Object[] mapKeyAndVal = (Object[])key;
        Object mapKey = mapKeyAndVal[1];
        AbstractIndex ri = this.mapKeyToValueIndex.get(mapKey);
        if (ri != null) {
            return ri.getSizeEstimate(mapKeyAndVal[0], op, matchLevel);
        }
        return 0;
    }

    @Override
    protected boolean isCompactRangeIndex() {
        return false;
    }

    @Override
    public IndexType getType() {
        return IndexType.FUNCTIONAL;
    }

    @Override
    public boolean isMapType() {
        return true;
    }

    @Override
    void addMapping(Object key, Object value, RegionEntry entry) throws IMQException {
        if (key == QueryService.UNDEFINED || !(key instanceof Map)) {
            return;
        }
        if (this.isAllKeys) {
            for (Map.Entry mapEntry : ((Map)key).entrySet()) {
                Object mapKey = mapEntry.getKey();
                Object indexKey = mapEntry.getValue();
                this.doIndexAddition(mapKey, indexKey, value, entry);
            }
        } else {
            for (Object mapKey : this.mapKeys) {
                Object indexKey = ((Map)key).get(mapKey);
                if (indexKey == null) continue;
                this.doIndexAddition(mapKey, indexKey, value, entry);
            }
        }
    }

    @Override
    void saveMapping(Object key, Object value, RegionEntry entry) throws IMQException {
        if (key == QueryService.UNDEFINED || !(key instanceof Map)) {
            return;
        }
        if (this.isAllKeys) {
            for (Map.Entry mapEntry : ((Map)key).entrySet()) {
                Object mapKey = mapEntry.getKey();
                Object indexKey = mapEntry.getValue();
                this.saveIndexAddition(mapKey, indexKey, value, entry);
            }
        } else {
            for (Object mapKey : this.mapKeys) {
                Object indexKey = ((Map)key).get(mapKey);
                if (indexKey == null) continue;
                this.saveIndexAddition(mapKey, indexKey, value, entry);
            }
        }
    }

    protected abstract void doIndexAddition(Object var1, Object var2, Object var3, RegionEntry var4) throws IMQException;

    protected abstract void saveIndexAddition(Object var1, Object var2, Object var3, RegionEntry var4) throws IMQException;

    public Map<Object, AbstractIndex> getRangeIndexHolderForTesting() {
        return Collections.unmodifiableMap(this.mapKeyToValueIndex);
    }

    public String[] getPatternsForTesting() {
        return this.patternStr;
    }

    public Object[] getMapKeysForTesting() {
        return this.mapKeys;
    }

    @Override
    public abstract boolean containsEntry(RegionEntry var1);

    @Override
    public boolean isMatchingWithIndexExpression(CompiledValue condnExpr, String conditionExprStr, ExecutionContext context) throws AmbiguousNameException, TypeMismatchException, NameResolutionException {
        if (this.isAllKeys) {
            if (condnExpr instanceof MapIndexable) {
                MapIndexable mi = (MapIndexable)((Object)condnExpr);
                CompiledValue recvr = mi.getRecieverSansIndexArgs();
                StringBuffer sb = new StringBuffer();
                recvr.generateCanonicalizedExpression(sb, context);
                sb.append('[').append(']');
                return sb.toString().equals(this.patternStr[0]);
            }
            return false;
        }
        for (String expr : this.patternStr) {
            if (!expr.equals(conditionExprStr)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.mapKeyToValueIndex.size() == 0;
    }

    class MapIndexStatistics
    extends AbstractIndex.InternalIndexStatistics {
        private IndexStats vsdStats;

        public MapIndexStatistics(String indexName) {
            this.vsdStats = new IndexStats(AbstractMapIndex.this.getRegion().getCache().getDistributedSystem(), indexName);
        }

        @Override
        public long getNumUpdates() {
            return this.vsdStats.getNumUpdates();
        }

        @Override
        public void incNumValues(int delta) {
            this.vsdStats.incNumValues(delta);
        }

        @Override
        public void incNumUpdates() {
            this.vsdStats.incNumUpdates();
        }

        @Override
        public void incNumUpdates(int delta) {
            this.vsdStats.incNumUpdates(delta);
        }

        @Override
        public void updateNumKeys(long numKeys) {
            this.vsdStats.updateNumKeys(numKeys);
        }

        @Override
        public void incNumMapIndexKeys(long numKeys) {
            this.vsdStats.incNumMapIndexKeys(numKeys);
        }

        @Override
        public void incNumKeys(long numKeys) {
            this.vsdStats.incNumKeys(numKeys);
        }

        @Override
        public void incUpdateTime(long delta) {
            this.vsdStats.incUpdateTime(delta);
        }

        @Override
        public void incUpdatesInProgress(int delta) {
            this.vsdStats.incUpdatesInProgress(delta);
        }

        @Override
        public void incNumUses() {
            this.vsdStats.incNumUses();
        }

        @Override
        public void incUseTime(long delta) {
            this.vsdStats.incUseTime(delta);
        }

        @Override
        public void incUsesInProgress(int delta) {
            this.vsdStats.incUsesInProgress(delta);
        }

        @Override
        public void incReadLockCount(int delta) {
            this.vsdStats.incReadLockCount(delta);
        }

        @Override
        public long getTotalUpdateTime() {
            return this.vsdStats.getTotalUpdateTime();
        }

        @Override
        public long getTotalUses() {
            return this.vsdStats.getTotalUses();
        }

        @Override
        public long getNumberOfMapIndexKeys() {
            return this.vsdStats.getNumberOfMapIndexKeys();
        }

        @Override
        public long getNumberOfKeys() {
            return this.vsdStats.getNumberOfKeys();
        }

        @Override
        public long getNumberOfValues() {
            return this.vsdStats.getNumberOfValues();
        }

        @Override
        public long getNumberOfValues(Object key) {
            long numValues = 0L;
            for (AbstractIndex ind : AbstractMapIndex.this.mapKeyToValueIndex.values()) {
                numValues += ind.getStatistics().getNumberOfValues(key);
            }
            return numValues;
        }

        @Override
        public int getReadLockCount() {
            return this.vsdStats.getReadLockCount();
        }

        @Override
        public void close() {
            this.vsdStats.close();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("No Keys = ").append(this.getNumberOfKeys()).append("\n");
            sb.append("No Map Index Keys = ").append(this.getNumberOfMapIndexKeys()).append("\n");
            sb.append("No Values = ").append(this.getNumberOfValues()).append("\n");
            sb.append("No Uses = ").append(this.getTotalUses()).append("\n");
            sb.append("No Updates = ").append(this.getNumUpdates()).append("\n");
            sb.append("Total Update time = ").append(this.getTotalUpdateTime()).append("\n");
            return sb.toString();
        }
    }
}

