/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.geode.cache.query.AmbiguousNameException;
import org.apache.geode.cache.query.FunctionDomainException;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.AbstractCompiledValue;
import org.apache.geode.cache.query.internal.CompiledValue;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.cache.query.internal.Filter;
import org.apache.geode.cache.query.internal.IndexInfo;
import org.apache.geode.cache.query.internal.Indexable;
import org.apache.geode.cache.query.internal.Negatable;
import org.apache.geode.cache.query.internal.PlanInfo;
import org.apache.geode.cache.query.internal.QueryExecutionContext;
import org.apache.geode.cache.query.internal.QueryObserver;
import org.apache.geode.cache.query.internal.QueryObserverHolder;
import org.apache.geode.cache.query.internal.QueryUtils;
import org.apache.geode.cache.query.internal.RuntimeIterator;
import org.apache.geode.cache.query.internal.Support;
import org.apache.geode.cache.query.internal.index.IndexData;
import org.apache.geode.cache.query.internal.index.IndexProtocol;
import org.apache.geode.cache.query.internal.index.IndexUtils;
import org.apache.geode.cache.query.internal.types.StructTypeImpl;
import org.apache.geode.cache.query.types.ObjectType;
import org.apache.geode.cache.query.types.StructType;

public class CompiledUndefined
extends AbstractCompiledValue
implements Negatable,
Indexable {
    private CompiledValue _value;
    private boolean _is_defined;

    public CompiledUndefined(CompiledValue value, boolean is_defined) {
        this._value = value;
        this._is_defined = is_defined;
    }

    @Override
    public List getChildren() {
        return Collections.singletonList(this._value);
    }

    @Override
    public int getType() {
        return -2;
    }

    @Override
    public Object evaluate(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        boolean b;
        boolean bl = b = this._value.evaluate(context) == QueryService.UNDEFINED;
        return this._is_defined ? !b : b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SelectResults filterEvaluate(ExecutionContext context, SelectResults intermediateResults, boolean completeExpansionNeeded, CompiledValue iterOperands, RuntimeIterator[] indpndntItrs, boolean isIntersection, boolean conditioningNeeded, boolean evaluateProjAttrib) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        Support.Assert(this._value.isDependentOnCurrentScope(context), "For a condition which does not depend on any RuntimeIterator of current scope , we should not have been in this function");
        IndexInfo[] idxInfo = this.getIndexInfo(context);
        ObjectType resultType = idxInfo[0]._index.getResultSetType();
        int indexFieldsSize = -1;
        SelectResults set = null;
        if (resultType instanceof StructType) {
            set = QueryUtils.createStructCollection(context, (StructTypeImpl)resultType);
            indexFieldsSize = ((StructTypeImpl)resultType).getFieldNames().length;
        } else {
            set = QueryUtils.createResultCollection(context, resultType);
            indexFieldsSize = 1;
        }
        int op = this._is_defined ? 20 : 13;
        Object key = QueryService.UNDEFINED;
        QueryObserver observer = QueryObserverHolder.getInstance();
        try {
            observer.beforeIndexLookup(idxInfo[0]._index, op, key);
            context.cachePut("index_info", idxInfo[0]);
            idxInfo[0]._index.query(key, op, set, context);
        }
        finally {
            observer.afterIndexLookup(set);
        }
        return QueryUtils.getconditionedIndexResults(set, idxInfo[0], context, indexFieldsSize, completeExpansionNeeded, iterOperands, indpndntItrs);
    }

    @Override
    public int getSizeEstimate(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        QueryExecutionContext qcontext;
        IndexInfo[] idxInfo = this.getIndexInfo(context);
        assert (idxInfo.length == 1);
        if (context instanceof QueryExecutionContext && (qcontext = (QueryExecutionContext)context).isHinted(idxInfo[0]._index.getName())) {
            return qcontext.getHintSize(idxInfo[0]._index.getName());
        }
        int op = this._is_defined ? 20 : 13;
        return idxInfo[0]._index.getSizeEstimate(QueryService.UNDEFINED, op, idxInfo[0]._matchLevel);
    }

    @Override
    public int getOperator() {
        return this._is_defined ? 20 : 13;
    }

    @Override
    public SelectResults filterEvaluate(ExecutionContext context, SelectResults iterationLimit) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        return this.filterEvaluate(context, iterationLimit, true, null, null, true, this.isConditioningNeededForIndex(null, context, true), false);
    }

    @Override
    public SelectResults auxFilterEvaluate(ExecutionContext context, SelectResults intermediateResults) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        Support.assertionFailed(" This auxFilterEvaluate of CompiledComparison should never have got invoked.");
        return null;
    }

    @Override
    public Set computeDependencies(ExecutionContext context) throws TypeMismatchException, AmbiguousNameException, NameResolutionException {
        return context.addDependencies(this, this._value.computeDependencies(context));
    }

    @Override
    public void negate() {
        this._is_defined = !this._is_defined;
    }

    @Override
    protected PlanInfo protGetPlanInfo(ExecutionContext context) throws TypeMismatchException, AmbiguousNameException, NameResolutionException {
        PlanInfo result = new PlanInfo();
        IndexInfo[] indexInfo = this.getIndexInfo(context);
        if (indexInfo == null) {
            return result;
        }
        Support.Assert(indexInfo.length == 1, "For a CompiledUndefined  we cannot have a join of two indexes. There should be only a single index to use");
        result.indexes.add(indexInfo[0]._index);
        result.evalAsFilter = true;
        return result;
    }

    @Override
    public IndexInfo[] getIndexInfo(ExecutionContext context) throws TypeMismatchException, AmbiguousNameException, NameResolutionException {
        IndexInfo[] indexInfo = this.privGetIndexInfo(context);
        if (indexInfo != null) {
            if (indexInfo == NO_INDEXES_IDENTIFIER) {
                return null;
            }
            return indexInfo;
        }
        if (!IndexUtils.indexesEnabled) {
            return null;
        }
        IndexData indexData = QueryUtils.getAvailableIndexIfAny(this._value, context, this._is_defined ? 20 : 13);
        IndexProtocol index = null;
        IndexInfo[] newIndexInfo = null;
        if (indexData != null) {
            index = indexData.getIndex();
        }
        if (index != null && index.isValid()) {
            newIndexInfo = new IndexInfo[]{new IndexInfo(null, this._value, index, indexData.getMatchLevel(), indexData.getMapping(), this._is_defined ? 20 : 13)};
        }
        if (newIndexInfo != null) {
            this.privSetIndexInfo(newIndexInfo, context);
        } else {
            this.privSetIndexInfo(NO_INDEXES_IDENTIFIER, context);
        }
        return newIndexInfo;
    }

    @Override
    public void generateCanonicalizedExpression(StringBuffer clauseBuffer, ExecutionContext context) throws AmbiguousNameException, TypeMismatchException, NameResolutionException {
        clauseBuffer.insert(0, ')');
        this._value.generateCanonicalizedExpression(clauseBuffer, context);
        if (this._is_defined) {
            clauseBuffer.insert(0, "IS_DEFINED(");
        } else {
            clauseBuffer.insert(0, "IS_UNDEFINED(");
        }
    }

    private IndexInfo[] privGetIndexInfo(ExecutionContext context) {
        return (IndexInfo[])context.cacheGet(this);
    }

    private void privSetIndexInfo(IndexInfo[] indexInfo, ExecutionContext context) {
        context.cachePut(this, indexInfo);
    }

    @Override
    public boolean isRangeEvaluatable() {
        return false;
    }

    @Override
    public boolean isProjectionEvaluationAPossibility(ExecutionContext context) {
        return true;
    }

    @Override
    public boolean isConditioningNeededForIndex(RuntimeIterator independentIter, ExecutionContext context, boolean completeExpnsNeeded) throws AmbiguousNameException, TypeMismatchException, NameResolutionException {
        return true;
    }

    @Override
    public boolean isBetterFilter(Filter comparedTo, ExecutionContext context, int thisSize) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        boolean isThisBetter = true;
        int thisOperator = this.getOperator();
        int thatSize = comparedTo.getSizeEstimate(context);
        int thatOperator = comparedTo.getOperator();
        if (context instanceof QueryExecutionContext && ((QueryExecutionContext)context).hasHints()) {
            return thisSize <= thatSize;
        }
        switch (thatOperator) {
            case 13: 
            case 20: 
            case 21: {
                isThisBetter = thisSize <= thatSize;
                break;
            }
            case 90: {
                if (thisOperator != 20 && thisOperator != 21) break;
                isThisBetter = false;
                break;
            }
            case 18: 
            case 19: 
            case 22: 
            case 23: {
                break;
            }
            default: {
                throw new IllegalArgumentException("The operator type =" + thatOperator + " is unknown");
            }
        }
        return isThisBetter;
    }
}

