/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.geode.admin.RegionNotFoundException;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.HeapDataOutputStream;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.ObjToByteArraySerializer;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.CachedDeserializable;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.OldClientSupportService;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.offheap.StoredObject;
import org.apache.geode.pdx.PdxInstance;
import org.apache.logging.log4j.Logger;

public abstract class DataSerializer {
    private static final Logger logger = LogService.getLogger();
    private EventID eventId;
    private ClientProxyMembershipID context;
    protected static final boolean TRACE_SERIALIZABLE = Boolean.getBoolean("DataSerializer.TRACE_SERIALIZABLE");
    protected static final ThreadLocal<Boolean> DISALLOW_JAVA_SERIALIZATION = new ThreadLocal();
    private static final ConcurrentMap knownEnums = new ConcurrentHashMap();

    public static void writeClass(Class<?> c, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Writing Class {}", c);
        }
        if (c == null || c.isPrimitive()) {
            InternalDataSerializer.writePrimitiveClass(c, out);
        } else {
            out.writeByte(43);
            String cname = c.getName();
            cname = DataSerializer.swizzleClassNameForWrite(cname, out);
            DataSerializer.writeString(cname, out);
        }
    }

    public static void writeNonPrimitiveClassName(String className, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Writing Class name {}", (Object)className);
        }
        DataSerializer.writeString(DataSerializer.swizzleClassNameForWrite(className, out), out);
    }

    public static Class<?> readClass(DataInput in) throws IOException, ClassNotFoundException {
        InternalDataSerializer.checkIn(in);
        byte typeCode = in.readByte();
        if (typeCode == 43) {
            String className = DataSerializer.readString(in);
            className = DataSerializer.swizzleClassNameForRead(className, in);
            Class<?> c = InternalDataSerializer.getCachedClass(className);
            return c;
        }
        return InternalDataSerializer.decodePrimitiveClass(typeCode);
    }

    private static String swizzleClassNameForRead(String name, DataInput in) {
        String oldPackage = "com.gemstone.org.jgroups.stack.tcpserver";
        String newPackage = "org.apache.geode.distributed.internal.tcpserver";
        if (name.startsWith(oldPackage)) {
            return newPackage + name.substring(oldPackage.length());
        }
        OldClientSupportService svc = InternalDataSerializer.getOldClientSupportService();
        if (svc != null) {
            return svc.processIncomingClassName(name, in);
        }
        return name;
    }

    private static String swizzleClassNameForWrite(String name, DataOutput out) {
        String oldPackage = "com.gemstone.org.jgroups.stack.tcpserver";
        String newPackage = "org.apache.geode.distributed.internal.tcpserver";
        if (name.startsWith(newPackage)) {
            return oldPackage + name.substring(newPackage.length());
        }
        OldClientSupportService svc = InternalDataSerializer.getOldClientSupportService();
        if (svc != null) {
            return svc.processOutgoingClassName(name, out);
        }
        return name;
    }

    public static String readNonPrimitiveClassName(DataInput in) throws IOException {
        InternalDataSerializer.checkIn(in);
        return DataSerializer.swizzleClassNameForRead(DataSerializer.readString(in), in);
    }

    public static void writeRegion(Region<?, ?> rgn, DataOutput out) throws IOException {
        DataSerializer.writeString(rgn != null ? rgn.getFullPath() : null, out);
    }

    public static <K, V> Region<K, V> readRegion(DataInput in) throws IOException, ClassNotFoundException {
        String fullPath = DataSerializer.readString(in);
        Region rgn = null;
        if (fullPath != null && (rgn = GemFireCacheImpl.getExisting("Needed cache to find region.").getRegion(fullPath)) == null) {
            throw new RegionNotFoundException(LocalizedStrings.DataSerializer_REGION_0_COULD_NOT_BE_FOUND_WHILE_READING_A_DATASERIALIZER_STREAM.toLocalizedString(fullPath));
        }
        return rgn;
    }

    public static void writeDate(Date date, DataOutput out) throws IOException {
        long v;
        InternalDataSerializer.checkOut(out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Writing Date {}", (Object)date);
        }
        if (date == null) {
            v = -1L;
        } else {
            v = date.getTime();
            if (v == -1L) {
                throw new IllegalArgumentException("Dates whose getTime returns -1 can not be DataSerialized.");
            }
        }
        out.writeLong(v);
    }

    public static Date readDate(DataInput in) throws IOException {
        InternalDataSerializer.checkIn(in);
        long time = in.readLong();
        Date date = null;
        if (time != -1L) {
            date = new Date(time);
        }
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Read Date {}", (Object)date);
        }
        return date;
    }

    public static void writeFile(File file, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Writing File {}", (Object)file);
        }
        DataSerializer.writeString(file != null ? file.getCanonicalPath() : null, out);
    }

    public static File readFile(DataInput in) throws IOException {
        InternalDataSerializer.checkIn(in);
        String s = DataSerializer.readString(in);
        File file = null;
        if (s != null) {
            file = new File(s);
        }
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Read File {}", (Object)file);
        }
        return file;
    }

    public static void writeInetAddress(InetAddress address, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Writing InetAddress {}", (Object)address);
        }
        DataSerializer.writeByteArray(address != null ? address.getAddress() : null, out);
    }

    public static InetAddress readInetAddress(DataInput in) throws IOException {
        InternalDataSerializer.checkIn(in);
        byte[] address = DataSerializer.readByteArray(in);
        if (address == null) {
            return null;
        }
        try {
            InetAddress addr = InetAddress.getByAddress(address);
            if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
                logger.trace(LogMarker.SERIALIZER, "Read InetAddress {}", (Object)addr);
            }
            return addr;
        }
        catch (UnknownHostException ex) {
            IOException ex2 = new IOException(LocalizedStrings.DataSerializer_WHILE_READING_AN_INETADDRESS.toLocalizedString());
            ex2.initCause(ex);
            throw ex2;
        }
    }

    public static void writeString(String value, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        boolean isDebugEnabled = logger.isTraceEnabled(LogMarker.SERIALIZER);
        if (isDebugEnabled) {
            logger.trace(LogMarker.SERIALIZER, "Writing String \"{}\"", (Object)value);
        }
        if (value == null) {
            if (isDebugEnabled) {
                logger.trace(LogMarker.SERIALIZER, "Writing NULL_STRING");
            }
            out.writeByte(69);
        } else {
            boolean writeUTF;
            int len;
            int utfLen = len = value.length();
            for (int i = 0; i < len; ++i) {
                char c = value.charAt(i);
                if (c <= '\u007f' && c >= '\u0001') continue;
                if (c > '\u07ff') {
                    utfLen += 2;
                    continue;
                }
                ++utfLen;
            }
            boolean bl = writeUTF = utfLen > len;
            if (writeUTF) {
                if (utfLen > 65535) {
                    if (isDebugEnabled) {
                        logger.trace(LogMarker.SERIALIZER, "Writing utf HUGE_STRING of len={}", (Object)len);
                    }
                    out.writeByte(89);
                    out.writeInt(len);
                    out.writeChars(value);
                } else {
                    if (isDebugEnabled) {
                        logger.trace(LogMarker.SERIALIZER, "Writing utf STRING of len={}", (Object)len);
                    }
                    out.writeByte(42);
                    out.writeUTF(value);
                }
            } else if (len > 65535) {
                if (isDebugEnabled) {
                    logger.trace(LogMarker.SERIALIZER, "Writing HUGE_STRING_BYTES of len={}", (Object)len);
                }
                out.writeByte(88);
                out.writeInt(len);
                out.writeBytes(value);
            } else {
                if (isDebugEnabled) {
                    logger.trace(LogMarker.SERIALIZER, "Writing STRING_BYTES of len={}", (Object)len);
                }
                out.writeByte(87);
                out.writeShort(len);
                out.writeBytes(value);
            }
        }
    }

    public static String readString(DataInput in) throws IOException {
        return InternalDataSerializer.readString(in, in.readByte());
    }

    public static void writeBoolean(Boolean value, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Writing Boolean {}", (Object)value);
        }
        out.writeBoolean(value);
    }

    public static Boolean readBoolean(DataInput in) throws IOException {
        InternalDataSerializer.checkIn(in);
        Boolean value = in.readBoolean();
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Read Boolean {}", (Object)value);
        }
        return value;
    }

    public static void writeCharacter(Character value, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Writing Character {}", (Object)value);
        }
        out.writeChar(value.charValue());
    }

    public static Character readCharacter(DataInput in) throws IOException {
        InternalDataSerializer.checkIn(in);
        Character value = Character.valueOf(in.readChar());
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Read Character {}", (Object)value);
        }
        return value;
    }

    public static void writeByte(Byte value, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Writing Byte {}", (Object)value);
        }
        out.writeByte(value.byteValue());
    }

    public static Byte readByte(DataInput in) throws IOException {
        InternalDataSerializer.checkIn(in);
        Byte value = in.readByte();
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Read Byte {}", (Object)value);
        }
        return value;
    }

    public static void writeShort(Short value, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Writing Short {}", (Object)value);
        }
        out.writeShort(value.shortValue());
    }

    public static Short readShort(DataInput in) throws IOException {
        InternalDataSerializer.checkIn(in);
        Short value = in.readShort();
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Read Short {}", (Object)value);
        }
        return value;
    }

    public static void writeInteger(Integer value, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Writing Integer {}", (Object)value);
        }
        out.writeInt(value);
    }

    public static Integer readInteger(DataInput in) throws IOException {
        InternalDataSerializer.checkIn(in);
        Integer value = in.readInt();
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Read Integer {}", (Object)value);
        }
        return value;
    }

    public static void writeLong(Long value, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Writing Long {}", (Object)value);
        }
        out.writeLong(value);
    }

    public static Long readLong(DataInput in) throws IOException {
        InternalDataSerializer.checkIn(in);
        Long value = in.readLong();
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Read Long {}", (Object)value);
        }
        return value;
    }

    public static void writeFloat(Float value, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Writing Float {}", (Object)value);
        }
        out.writeFloat(value.floatValue());
    }

    public static Float readFloat(DataInput in) throws IOException {
        InternalDataSerializer.checkIn(in);
        Float value = Float.valueOf(in.readFloat());
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Read Float {}", (Object)value);
        }
        return value;
    }

    public static void writeDouble(Double value, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Writing Double {}", (Object)value);
        }
        out.writeDouble(value);
    }

    public static Double readDouble(DataInput in) throws IOException {
        InternalDataSerializer.checkIn(in);
        Double value = in.readDouble();
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Read Double {}", (Object)value);
        }
        return value;
    }

    public static void writePrimitiveBoolean(boolean value, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Writing Boolean {}", (Object)value);
        }
        out.writeBoolean(value);
    }

    public static boolean readPrimitiveBoolean(DataInput in) throws IOException {
        InternalDataSerializer.checkIn(in);
        boolean value = in.readBoolean();
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Read Boolean {}", (Object)value);
        }
        return value;
    }

    public static void writePrimitiveByte(byte value, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Writing Byte {}", (Object)value);
        }
        out.writeByte(value);
    }

    public static byte readPrimitiveByte(DataInput in) throws IOException {
        InternalDataSerializer.checkIn(in);
        byte value = in.readByte();
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Read Byte {}", (Object)value);
        }
        return value;
    }

    public static void writePrimitiveChar(char value, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Writing Char {}", (Object)Character.valueOf(value));
        }
        out.writeChar(value);
    }

    public static char readPrimitiveChar(DataInput in) throws IOException {
        InternalDataSerializer.checkIn(in);
        char value = in.readChar();
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Read Char {}", (Object)Character.valueOf(value));
        }
        return value;
    }

    public static void writePrimitiveShort(short value, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Writing Short {}", (Object)value);
        }
        out.writeShort(value);
    }

    public static short readPrimitiveShort(DataInput in) throws IOException {
        InternalDataSerializer.checkIn(in);
        short value = in.readShort();
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Read Short {}", (Object)value);
        }
        return value;
    }

    public static void writeUnsignedByte(int value, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Writing Unsigned Byte {}", (Object)value);
        }
        out.writeByte(value);
    }

    public static int readUnsignedByte(DataInput in) throws IOException {
        InternalDataSerializer.checkIn(in);
        int value = in.readUnsignedByte();
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Read Unsigned Byte {}", (Object)value);
        }
        return value;
    }

    public static void writeUnsignedShort(int value, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Writing Unsigned Short {}", (Object)value);
        }
        out.writeShort(value);
    }

    public static int readUnsignedShort(DataInput in) throws IOException {
        InternalDataSerializer.checkIn(in);
        int value = in.readUnsignedShort();
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Read Unsigned Short {}", (Object)value);
        }
        return value;
    }

    public static void writePrimitiveInt(int value, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Writing Integer {}", (Object)value);
        }
        out.writeInt(value);
    }

    public static int readPrimitiveInt(DataInput in) throws IOException {
        InternalDataSerializer.checkIn(in);
        int value = in.readInt();
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Read Integer {}", (Object)value);
        }
        return value;
    }

    public static void writePrimitiveLong(long value, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Writing Long {}", (Object)value);
        }
        out.writeLong(value);
    }

    public static long readPrimitiveLong(DataInput in) throws IOException {
        InternalDataSerializer.checkIn(in);
        long value = in.readLong();
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Read Long {}", (Object)value);
        }
        return value;
    }

    public static void writePrimitiveFloat(float value, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Writing Float {}", (Object)Float.valueOf(value));
        }
        out.writeFloat(value);
    }

    public static float readPrimitiveFloat(DataInput in) throws IOException {
        InternalDataSerializer.checkIn(in);
        float value = in.readFloat();
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Read Float {}", (Object)Float.valueOf(value));
        }
        return value;
    }

    public static void writePrimitiveDouble(double value, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Writing Double {}", (Object)value);
        }
        out.writeDouble(value);
    }

    public static double readPrimitiveDouble(DataInput in) throws IOException {
        InternalDataSerializer.checkIn(in);
        double value = in.readDouble();
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Read Double {}", (Object)value);
        }
        return value;
    }

    public static void writeByteArray(byte[] array, DataOutput out) throws IOException {
        int len = 0;
        if (array != null) {
            len = array.length;
        }
        DataSerializer.writeByteArray(array, len, out);
    }

    public static void writeByteArray(byte[] array, int len, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        int length = len;
        if (array == null) {
            length = -1;
        } else if (length > array.length) {
            length = array.length;
        }
        InternalDataSerializer.writeArrayLength(length, out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Writing byte array of length {}", (Object)length);
        }
        if (length > 0) {
            out.write(array, 0, length);
        }
    }

    public static void writeObjectAsByteArray(Object obj, DataOutput out) throws IOException {
        Object object = obj;
        if (obj instanceof CachedDeserializable) {
            if (obj instanceof StoredObject) {
                StoredObject so = (StoredObject)obj;
                if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
                    logger.trace(LogMarker.SERIALIZER, "writeObjectAsByteArray StoredObject");
                }
                so.sendAsByteArray(out);
                return;
            }
            object = ((CachedDeserializable)obj).getSerializedValue();
        }
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            if (object == null) {
                logger.trace(LogMarker.SERIALIZER, "writeObjectAsByteArray null");
            } else {
                logger.trace(LogMarker.SERIALIZER, "writeObjectAsByteArray obj.getClass={}", object.getClass());
            }
        }
        if (object instanceof byte[] || object == null) {
            DataSerializer.writeByteArray((byte[])object, out);
        } else if (out instanceof ObjToByteArraySerializer) {
            ((ObjToByteArraySerializer)out).writeAsSerializedByteArray(object);
        } else {
            HeapDataOutputStream hdos;
            if (object instanceof HeapDataOutputStream) {
                hdos = (HeapDataOutputStream)object;
            } else {
                Version v = InternalDataSerializer.getVersionForDataStreamOrNull(out);
                if (v == null) {
                    v = Version.CURRENT;
                }
                hdos = new HeapDataOutputStream(v);
                try {
                    DataSerializer.writeObject(object, hdos);
                }
                catch (IOException e) {
                    IllegalArgumentException e2 = new IllegalArgumentException(LocalizedStrings.DataSerializer_PROBELM_WHILE_SERIALIZING.toLocalizedString());
                    e2.initCause(e);
                    throw e2;
                }
            }
            InternalDataSerializer.writeArrayLength(hdos.size(), out);
            hdos.sendTo(out);
        }
    }

    public static byte[] readByteArray(DataInput in) throws IOException {
        InternalDataSerializer.checkIn(in);
        int length = InternalDataSerializer.readArrayLength(in);
        if (length == -1) {
            return null;
        }
        byte[] array = new byte[length];
        in.readFully(array, 0, length);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Read byte array of length {}", (Object)length);
        }
        return array;
    }

    public static void writeStringArray(String[] array, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        int length = array == null ? -1 : array.length;
        InternalDataSerializer.writeArrayLength(length, out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Writing String array of length {}", (Object)length);
        }
        if (length > 0) {
            for (int i = 0; i < length; ++i) {
                DataSerializer.writeString(array[i], out);
            }
        }
    }

    public static String[] readStringArray(DataInput in) throws IOException {
        InternalDataSerializer.checkIn(in);
        int length = InternalDataSerializer.readArrayLength(in);
        if (length == -1) {
            return null;
        }
        String[] array = new String[length];
        for (int i = 0; i < length; ++i) {
            array[i] = DataSerializer.readString(in);
        }
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Read String array of length {}", (Object)length);
        }
        return array;
    }

    public static void writeShortArray(short[] array, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        int length = array == null ? -1 : array.length;
        InternalDataSerializer.writeArrayLength(length, out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Writing short array of length {}", (Object)length);
        }
        if (length > 0) {
            for (int i = 0; i < length; ++i) {
                out.writeShort(array[i]);
            }
        }
    }

    public static short[] readShortArray(DataInput in) throws IOException {
        InternalDataSerializer.checkIn(in);
        int length = InternalDataSerializer.readArrayLength(in);
        if (length == -1) {
            return null;
        }
        short[] array = new short[length];
        for (int i = 0; i < length; ++i) {
            array[i] = in.readShort();
        }
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Read short array of length {}", (Object)length);
        }
        return array;
    }

    public static void writeCharArray(char[] array, DataOutput out) throws IOException {
        InternalDataSerializer.writeCharArray(array, array != null ? array.length : -1, out);
    }

    public static char[] readCharArray(DataInput in) throws IOException {
        InternalDataSerializer.checkIn(in);
        int length = InternalDataSerializer.readArrayLength(in);
        if (length == -1) {
            return null;
        }
        char[] array = new char[length];
        for (int i = 0; i < length; ++i) {
            array[i] = in.readChar();
        }
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Read char array of length {}", (Object)length);
        }
        return array;
    }

    public static void writeBooleanArray(boolean[] array, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        int length = array == null ? -1 : array.length;
        InternalDataSerializer.writeArrayLength(length, out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Writing boolean array of length {}", (Object)length);
        }
        if (length > 0) {
            for (int i = 0; i < length; ++i) {
                out.writeBoolean(array[i]);
            }
        }
    }

    public static boolean[] readBooleanArray(DataInput in) throws IOException {
        InternalDataSerializer.checkIn(in);
        int length = InternalDataSerializer.readArrayLength(in);
        if (length == -1) {
            return null;
        }
        boolean[] array = new boolean[length];
        for (int i = 0; i < length; ++i) {
            array[i] = in.readBoolean();
        }
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Read boolean array of length {}", (Object)length);
        }
        return array;
    }

    public static void writeIntArray(int[] array, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        int length = array == null ? -1 : array.length;
        InternalDataSerializer.writeArrayLength(length, out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Writing int array of length {}", (Object)length);
        }
        if (length > 0) {
            for (int i = 0; i < length; ++i) {
                out.writeInt(array[i]);
            }
        }
    }

    public static int[] readIntArray(DataInput in) throws IOException {
        InternalDataSerializer.checkIn(in);
        int length = InternalDataSerializer.readArrayLength(in);
        if (length == -1) {
            return null;
        }
        int[] array = new int[length];
        for (int i = 0; i < length; ++i) {
            array[i] = in.readInt();
        }
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Read int array of length {}", (Object)length);
        }
        return array;
    }

    public static void writeLongArray(long[] array, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        int length = array == null ? -1 : array.length;
        InternalDataSerializer.writeArrayLength(length, out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Writing long array of length {}", (Object)length);
        }
        if (length > 0) {
            for (int i = 0; i < length; ++i) {
                out.writeLong(array[i]);
            }
        }
    }

    public static long[] readLongArray(DataInput in) throws IOException {
        InternalDataSerializer.checkIn(in);
        int length = InternalDataSerializer.readArrayLength(in);
        if (length == -1) {
            return null;
        }
        long[] array = new long[length];
        for (int i = 0; i < length; ++i) {
            array[i] = in.readLong();
        }
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Read long array of length {}", (Object)length);
        }
        return array;
    }

    public static void writeFloatArray(float[] array, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        int length = array == null ? -1 : array.length;
        InternalDataSerializer.writeArrayLength(length, out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Writing float array of length {}", (Object)length);
        }
        if (length > 0) {
            for (int i = 0; i < length; ++i) {
                out.writeFloat(array[i]);
            }
        }
    }

    public static float[] readFloatArray(DataInput in) throws IOException {
        InternalDataSerializer.checkIn(in);
        int length = InternalDataSerializer.readArrayLength(in);
        if (length == -1) {
            return null;
        }
        float[] array = new float[length];
        for (int i = 0; i < length; ++i) {
            array[i] = in.readFloat();
        }
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Read float array of length {}", (Object)length);
        }
        return array;
    }

    public static void writeDoubleArray(double[] array, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        int length = array == null ? -1 : array.length;
        InternalDataSerializer.writeArrayLength(length, out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Writing double array of length {}", (Object)length);
        }
        if (length > 0) {
            for (int i = 0; i < length; ++i) {
                out.writeDouble(array[i]);
            }
        }
    }

    public static double[] readDoubleArray(DataInput in) throws IOException {
        InternalDataSerializer.checkIn(in);
        int length = InternalDataSerializer.readArrayLength(in);
        if (length == -1) {
            return null;
        }
        double[] array = new double[length];
        for (int i = 0; i < length; ++i) {
            array[i] = in.readDouble();
        }
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Read double array of length {}", (Object)length);
        }
        return array;
    }

    public static void writeObjectArray(Object[] array, DataOutput out) throws IOException {
        InternalDataSerializer.writeObjectArray(array, out, false);
    }

    public static Object[] readObjectArray(DataInput in) throws IOException, ClassNotFoundException {
        InternalDataSerializer.checkIn(in);
        int length = InternalDataSerializer.readArrayLength(in);
        if (length == -1) {
            return null;
        }
        Class<Object> c = null;
        byte typeCode = in.readByte();
        String typeString = null;
        if (typeCode == 43) {
            typeString = DataSerializer.readString(in);
        }
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        boolean lookForPdxInstance = false;
        ClassNotFoundException cnfEx = null;
        if (typeCode == 43 && cache != null && cache.getPdxReadSerializedByAnyGemFireServices()) {
            try {
                c = InternalDataSerializer.getCachedClass(typeString);
                lookForPdxInstance = true;
            }
            catch (ClassNotFoundException ignore) {
                c = Object.class;
                cnfEx = ignore;
            }
        } else {
            c = typeCode == 43 ? InternalDataSerializer.getCachedClass(typeString) : InternalDataSerializer.decodePrimitiveClass(typeCode);
        }
        Object o = null;
        if (length > 0) {
            o = DataSerializer.readObject(in);
            if (lookForPdxInstance && o instanceof PdxInstance) {
                lookForPdxInstance = false;
                c = Object.class;
            }
        }
        Object[] array = (Object[])Array.newInstance(c, length);
        if (length > 0) {
            array[0] = o;
        }
        for (int i = 1; i < length; ++i) {
            o = DataSerializer.readObject(in);
            if (lookForPdxInstance && o instanceof PdxInstance) {
                lookForPdxInstance = false;
                c = Object.class;
                Object[] newArray = (Object[])Array.newInstance(c, length);
                System.arraycopy(array, 0, newArray, 0, i);
                array = newArray;
            }
            array[i] = o;
        }
        if (lookForPdxInstance && cnfEx != null && length > 0) {
            throw cnfEx;
        }
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Read Object array of length {}", (Object)length);
        }
        return array;
    }

    public static void writeArrayOfByteArrays(byte[][] array, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        int length = array == null ? -1 : array.length;
        InternalDataSerializer.writeArrayLength(length, out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Writing byte[][] of length {}", (Object)length);
        }
        if (length >= 0) {
            for (int i = 0; i < length; ++i) {
                DataSerializer.writeByteArray(array[i], out);
            }
        }
    }

    public static byte[][] readArrayOfByteArrays(DataInput in) throws IOException, ClassNotFoundException {
        InternalDataSerializer.checkIn(in);
        int length = InternalDataSerializer.readArrayLength(in);
        if (length == -1) {
            return null;
        }
        byte[][] array = new byte[length][];
        for (int i = 0; i < length; ++i) {
            array[i] = DataSerializer.readByteArray(in);
        }
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Read byte[][] of length {}", (Object)length);
        }
        return array;
    }

    public static void writeArrayList(ArrayList<?> list, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        int size = list == null ? -1 : list.size();
        InternalDataSerializer.writeArrayLength(size, out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Writing ArrayList with {} elements: {}", (Object)size, list);
        }
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                DataSerializer.writeObject(list.get(i), out);
            }
        }
    }

    public static <E> ArrayList<E> readArrayList(DataInput in) throws IOException, ClassNotFoundException {
        InternalDataSerializer.checkIn(in);
        int size = InternalDataSerializer.readArrayLength(in);
        if (size == -1) {
            return null;
        }
        ArrayList list = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            Object element = DataSerializer.readObject(in);
            list.add(element);
        }
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Read ArrayList with {} elements: {}", (Object)size, list);
        }
        return list;
    }

    public static void writeVector(Vector<?> list, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        int size = list == null ? -1 : list.size();
        InternalDataSerializer.writeArrayLength(size, out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Writing Vector with {} elements: {}", (Object)size, list);
        }
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                DataSerializer.writeObject(list.get(i), out);
            }
        }
    }

    public static <E> Vector<E> readVector(DataInput in) throws IOException, ClassNotFoundException {
        InternalDataSerializer.checkIn(in);
        int size = InternalDataSerializer.readArrayLength(in);
        if (size == -1) {
            return null;
        }
        Vector list = new Vector(size);
        for (int i = 0; i < size; ++i) {
            Object element = DataSerializer.readObject(in);
            list.add(element);
        }
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Read Vector with {} elements: {}", (Object)size, list);
        }
        return list;
    }

    public static void writeStack(Stack<?> list, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        int size = list == null ? -1 : list.size();
        InternalDataSerializer.writeArrayLength(size, out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Writing Stack with {} elements: {}", (Object)size, list);
        }
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                DataSerializer.writeObject(list.get(i), out);
            }
        }
    }

    public static <E> Stack<E> readStack(DataInput in) throws IOException, ClassNotFoundException {
        InternalDataSerializer.checkIn(in);
        int size = InternalDataSerializer.readArrayLength(in);
        if (size == -1) {
            return null;
        }
        Stack list = new Stack();
        for (int i = 0; i < size; ++i) {
            Object element = DataSerializer.readObject(in);
            list.add(element);
        }
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Read Stack with {} elements: {}", (Object)size, list);
        }
        return list;
    }

    public static void writeLinkedList(LinkedList<?> list, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        int size = list == null ? -1 : list.size();
        InternalDataSerializer.writeArrayLength(size, out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Writing LinkedList with {} elements: {}", (Object)size, list);
        }
        if (size > 0) {
            for (Object e : list) {
                DataSerializer.writeObject(e, out);
            }
        }
    }

    public static <E> LinkedList<E> readLinkedList(DataInput in) throws IOException, ClassNotFoundException {
        InternalDataSerializer.checkIn(in);
        int size = InternalDataSerializer.readArrayLength(in);
        if (size == -1) {
            return null;
        }
        LinkedList list = new LinkedList();
        for (int i = 0; i < size; ++i) {
            Object element = DataSerializer.readObject(in);
            list.add(element);
        }
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Read LinkedList with {} elements: {}", (Object)size, list);
        }
        return list;
    }

    public static void writeHashSet(HashSet<?> set, DataOutput out) throws IOException {
        InternalDataSerializer.writeSet(set, out);
    }

    public static <E> HashSet<E> readHashSet(DataInput in) throws IOException, ClassNotFoundException {
        InternalDataSerializer.checkIn(in);
        int size = InternalDataSerializer.readArrayLength(in);
        if (size == -1) {
            return null;
        }
        HashSet set = new HashSet(size);
        for (int i = 0; i < size; ++i) {
            Object element = DataSerializer.readObject(in);
            set.add(element);
        }
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Read HashSet with {} elements: {}", (Object)size, set);
        }
        return set;
    }

    public static void writeLinkedHashSet(LinkedHashSet<?> set, DataOutput out) throws IOException {
        InternalDataSerializer.writeSet(set, out);
    }

    public static <E> LinkedHashSet<E> readLinkedHashSet(DataInput in) throws IOException, ClassNotFoundException {
        InternalDataSerializer.checkIn(in);
        int size = InternalDataSerializer.readArrayLength(in);
        if (size == -1) {
            return null;
        }
        LinkedHashSet set = new LinkedHashSet(size);
        for (int i = 0; i < size; ++i) {
            Object element = DataSerializer.readObject(in);
            set.add(element);
        }
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Read LinkedHashSet with {} elements: {}", (Object)size, set);
        }
        return set;
    }

    public static void writeHashMap(Map<?, ?> map, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        int size = map == null ? -1 : map.size();
        InternalDataSerializer.writeArrayLength(size, out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Writing HashMap with {} elements: {}", (Object)size, map);
        }
        if (size > 0) {
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                DataSerializer.writeObject(entry.getKey(), out);
                DataSerializer.writeObject(entry.getValue(), out);
            }
        }
    }

    public static <K, V> HashMap<K, V> readHashMap(DataInput in) throws IOException, ClassNotFoundException {
        InternalDataSerializer.checkIn(in);
        int size = InternalDataSerializer.readArrayLength(in);
        if (size == -1) {
            return null;
        }
        HashMap map = new HashMap(size);
        for (int i = 0; i < size; ++i) {
            Object key = DataSerializer.readObject(in);
            Object value = DataSerializer.readObject(in);
            map.put(key, value);
        }
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Read HashMap with {} elements: {}", (Object)size, map);
        }
        return map;
    }

    public static void writeIdentityHashMap(IdentityHashMap<?, ?> map, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        int size = map == null ? -1 : map.size();
        InternalDataSerializer.writeArrayLength(size, out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Writing IdentityHashMap with {} elements: {}", (Object)size, map);
        }
        if (size > 0) {
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                DataSerializer.writeObject(entry.getKey(), out);
                DataSerializer.writeObject(entry.getValue(), out);
            }
        }
    }

    public static <K, V> IdentityHashMap<K, V> readIdentityHashMap(DataInput in) throws IOException, ClassNotFoundException {
        InternalDataSerializer.checkIn(in);
        int size = InternalDataSerializer.readArrayLength(in);
        if (size == -1) {
            return null;
        }
        IdentityHashMap map = new IdentityHashMap(size);
        for (int i = 0; i < size; ++i) {
            Object key = DataSerializer.readObject(in);
            Object value = DataSerializer.readObject(in);
            map.put(key, value);
        }
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Read IdentityHashMap with {} elements: {}", (Object)size, map);
        }
        return map;
    }

    public static void writeConcurrentHashMap(ConcurrentHashMap<?, ?> map, DataOutput out) throws IOException {
        int size;
        InternalDataSerializer.checkOut(out);
        ArrayList entrySnapshot = null;
        if (map == null) {
            size = -1;
        } else {
            entrySnapshot = new ArrayList(map.entrySet());
            size = entrySnapshot.size();
        }
        InternalDataSerializer.writeArrayLength(size, out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Writing ConcurrentHashMap with {} elements: {}", (Object)size, entrySnapshot);
        }
        if (size > 0) {
            for (Map.Entry entry : entrySnapshot) {
                DataSerializer.writeObject(entry.getKey(), out);
                DataSerializer.writeObject(entry.getValue(), out);
            }
        }
    }

    public static <K, V> ConcurrentHashMap<K, V> readConcurrentHashMap(DataInput in) throws IOException, ClassNotFoundException {
        InternalDataSerializer.checkIn(in);
        int size = InternalDataSerializer.readArrayLength(in);
        if (size == -1) {
            return null;
        }
        ConcurrentHashMap map = new ConcurrentHashMap(size);
        for (int i = 0; i < size; ++i) {
            Object key = DataSerializer.readObject(in);
            Object value = DataSerializer.readObject(in);
            map.put(key, value);
        }
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Read ConcurrentHashMap with {} elements: {}", (Object)size, map);
        }
        return map;
    }

    public static void writeHashtable(Hashtable<?, ?> map, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        int size = map == null ? -1 : map.size();
        InternalDataSerializer.writeArrayLength(size, out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Writing Hashtable with {} elements: {}", (Object)size, map);
        }
        if (size > 0) {
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                DataSerializer.writeObject(entry.getKey(), out);
                DataSerializer.writeObject(entry.getValue(), out);
            }
        }
    }

    public static <K, V> Hashtable<K, V> readHashtable(DataInput in) throws IOException, ClassNotFoundException {
        InternalDataSerializer.checkIn(in);
        int size = InternalDataSerializer.readArrayLength(in);
        if (size == -1) {
            return null;
        }
        Hashtable map = new Hashtable(size);
        for (int i = 0; i < size; ++i) {
            Object key = DataSerializer.readObject(in);
            Object value = DataSerializer.readObject(in);
            map.put(key, value);
        }
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Read Hashtable with {} elements: {}", (Object)size, map);
        }
        return map;
    }

    public static void writeTreeMap(TreeMap<?, ?> map, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        int size = map == null ? -1 : map.size();
        InternalDataSerializer.writeArrayLength(size, out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Writing TreeMap with {} elements: {}", (Object)size, map);
        }
        if (size >= 0) {
            DataSerializer.writeObject(map.comparator(), out);
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                DataSerializer.writeObject(entry.getKey(), out);
                DataSerializer.writeObject(entry.getValue(), out);
            }
        }
    }

    public static <K, V> TreeMap<K, V> readTreeMap(DataInput in) throws IOException, ClassNotFoundException {
        InternalDataSerializer.checkIn(in);
        int size = InternalDataSerializer.readArrayLength(in);
        if (size == -1) {
            return null;
        }
        Comparator c = (Comparator)InternalDataSerializer.readNonPdxInstanceObject(in);
        TreeMap map = new TreeMap(c);
        for (int i = 0; i < size; ++i) {
            Object key = DataSerializer.readObject(in);
            Object value = DataSerializer.readObject(in);
            map.put(key, value);
        }
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Read TreeMap with {} elements: {}", (Object)size, map);
        }
        return map;
    }

    public static void writeTreeSet(TreeSet<?> set, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        int size = set == null ? -1 : set.size();
        InternalDataSerializer.writeArrayLength(size, out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Writing TreeSet with {} elements: {}", (Object)size, set);
        }
        if (size >= 0) {
            DataSerializer.writeObject(set.comparator(), out);
            for (Object e : set) {
                DataSerializer.writeObject(e, out);
            }
        }
    }

    public static <E> TreeSet<E> readTreeSet(DataInput in) throws IOException, ClassNotFoundException {
        InternalDataSerializer.checkIn(in);
        int size = InternalDataSerializer.readArrayLength(in);
        if (size == -1) {
            return null;
        }
        Comparator c = (Comparator)InternalDataSerializer.readNonPdxInstanceObject(in);
        TreeSet set = new TreeSet(c);
        for (int i = 0; i < size; ++i) {
            Object element = DataSerializer.readObject(in);
            set.add(element);
        }
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Read TreeSet with {} elements: {}", (Object)size, set);
        }
        return set;
    }

    public static void writeProperties(Properties props, DataOutput out) throws IOException {
        int size;
        Set<Map.Entry<Object, Object>> s;
        InternalDataSerializer.checkOut(out);
        if (props == null) {
            s = null;
            size = -1;
        } else {
            s = props.entrySet();
            size = s.size();
        }
        InternalDataSerializer.writeArrayLength(size, out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Writing Properties with {} elements: {}", (Object)size, (Object)props);
        }
        if (size > 0) {
            for (Map.Entry<Object, Object> entry : s) {
                Object key = entry.getKey();
                Object val = entry.getValue();
                DataSerializer.writeObject(key, out);
                DataSerializer.writeObject(val, out);
            }
        }
    }

    public static Properties readProperties(DataInput in) throws IOException, ClassNotFoundException {
        InternalDataSerializer.checkIn(in);
        int size = InternalDataSerializer.readArrayLength(in);
        if (size == -1) {
            return null;
        }
        Properties props = new Properties();
        for (int index = 0; index < size; ++index) {
            Object key = DataSerializer.readObject(in);
            Object value = DataSerializer.readObject(in);
            props.put(key, value);
        }
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Read Properties with {} elements: {}", (Object)size, (Object)props);
        }
        return props;
    }

    public static final void writeObject(Object o, DataOutput out, boolean allowJavaSerialization) throws IOException {
        if (allowJavaSerialization) {
            DataSerializer.writeObject(o, out);
            return;
        }
        DISALLOW_JAVA_SERIALIZATION.set(Boolean.TRUE);
        try {
            DataSerializer.writeObject(o, out);
        }
        finally {
            DISALLOW_JAVA_SERIALIZATION.set(Boolean.FALSE);
        }
    }

    public static final void writeObject(Object o, DataOutput out) throws IOException {
        InternalDataSerializer.basicWriteObject(o, out, false);
    }

    public static final <T> T readObject(DataInput in) throws IOException, ClassNotFoundException {
        return (T)InternalDataSerializer.basicReadObject(in);
    }

    public static final DataSerializer register(Class<?> c) {
        return InternalDataSerializer.register(c, true);
    }

    @Deprecated
    public static final DataSerializer register(Class<?> c, byte b) {
        return DataSerializer.register(c);
    }

    public abstract Class<?>[] getSupportedClasses();

    public abstract boolean toData(Object var1, DataOutput var2) throws IOException;

    public abstract Object fromData(DataInput var1) throws IOException, ClassNotFoundException;

    public abstract int getId();

    public boolean equals(Object o) {
        if (o instanceof DataSerializer) {
            DataSerializer oDS = (DataSerializer)o;
            return oDS.getId() == this.getId() && this.getClass().equals(oDS.getClass());
        }
        return false;
    }

    public int hashCode() {
        return this.getId();
    }

    public final void setEventId(Object eventId) {
        this.eventId = (EventID)eventId;
    }

    public final Object getEventId() {
        return this.eventId;
    }

    public final void setContext(Object context) {
        this.context = (ClientProxyMembershipID)context;
    }

    public final Object getContext() {
        return this.context;
    }

    private static <E extends Enum> E[] getEnumConstantsForClass(Class<E> clazz) {
        Enum[] returnVal = (Enum[])knownEnums.get(clazz);
        if (returnVal == null) {
            returnVal = (Enum[])clazz.getEnumConstants();
            knownEnums.put(clazz, returnVal);
        }
        return returnVal;
    }

    public static void writeEnum(Enum e, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        if (e == null) {
            throw new NullPointerException(LocalizedStrings.DataSerializer_ENUM_TO_SERIALIZE_IS_NULL.toLocalizedString());
        }
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Writing enum {}", (Object)e);
        }
        InternalDataSerializer.writeArrayLength(e.ordinal(), out);
    }

    public static <E extends Enum<E>> E readEnum(Class<E> clazz, DataInput in) throws IOException {
        InternalDataSerializer.checkIn(in);
        if (clazz == null) {
            throw new NullPointerException(LocalizedStrings.DataSerializer_ENUM_CLASS_TO_DESERIALIZE_IS_NULL.toLocalizedString());
        }
        if (!clazz.isEnum()) {
            throw new IllegalArgumentException(LocalizedStrings.DataSerializer_CLASS_0_NOT_ENUM.toLocalizedString(clazz.getName()));
        }
        int ordinal = InternalDataSerializer.readArrayLength(in);
        return (E)DataSerializer.getEnumConstantsForClass(clazz)[ordinal];
    }
}

