/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal.repository.serializer;

import java.util.Arrays;
import java.util.Map;
import org.apache.geode.cache.lucene.internal.repository.serializer.LuceneSerializer;
import org.apache.geode.cache.lucene.internal.repository.serializer.PdxLuceneSerializer;
import org.apache.geode.cache.lucene.internal.repository.serializer.PrimitiveSerializer;
import org.apache.geode.cache.lucene.internal.repository.serializer.ReflectionLuceneSerializer;
import org.apache.geode.cache.lucene.internal.repository.serializer.SerializerUtil;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.util.concurrent.CopyOnWriteWeakHashMap;
import org.apache.geode.pdx.PdxInstance;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.document.Document;

public class HeterogeneousLuceneSerializer
implements LuceneSerializer {
    private String[] indexedFields;
    private LuceneSerializer pdxMapper;
    private Map<Class<?>, LuceneSerializer> mappers = new CopyOnWriteWeakHashMap();
    private static final Logger logger = LogService.getLogger();

    public HeterogeneousLuceneSerializer(String[] indexedFields) {
        this.indexedFields = indexedFields;
        this.pdxMapper = new PdxLuceneSerializer(indexedFields);
        this.addSerializersForPrimitiveValues();
    }

    private void addSerializersForPrimitiveValues() {
        if (Arrays.asList(this.indexedFields).contains("__REGION_VALUE_FIELD")) {
            PrimitiveSerializer primitiveSerializer = new PrimitiveSerializer();
            SerializerUtil.supportedPrimitiveTypes().stream().forEach(type -> this.mappers.put((Class<?>)type, primitiveSerializer));
        }
    }

    @Override
    public void toDocument(Object value, Document doc) {
        LuceneSerializer mapper = this.getFieldMapper(value);
        mapper.toDocument(value, doc);
        if (logger.isDebugEnabled()) {
            logger.debug("HeterogeneousLuceneSerializer.toDocument:" + doc);
        }
    }

    private LuceneSerializer getFieldMapper(Object value) {
        if (value instanceof PdxInstance) {
            return this.pdxMapper;
        }
        Class<?> clazz = value.getClass();
        LuceneSerializer mapper = this.mappers.get(clazz);
        if (mapper == null) {
            mapper = new ReflectionLuceneSerializer(clazz, this.indexedFields);
            this.mappers.put(clazz, mapper);
        }
        return mapper;
    }
}

