/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal.filesystem;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import org.apache.geode.cache.lucene.internal.filesystem.ChunkKey;
import org.apache.geode.cache.lucene.internal.filesystem.File;
import org.apache.geode.cache.lucene.internal.filesystem.FileSystemStats;

public class FileSystem {
    private final ConcurrentMap<String, File> fileRegion;
    private final ConcurrentMap<ChunkKey, byte[]> chunkRegion;
    static final int CHUNK_SIZE = 0x100000;
    private final FileSystemStats stats;

    public FileSystem(ConcurrentMap<String, File> fileRegion, ConcurrentMap<ChunkKey, byte[]> chunkRegion, FileSystemStats stats) {
        this.fileRegion = fileRegion;
        this.chunkRegion = chunkRegion;
        this.stats = stats;
    }

    public Collection<String> listFileNames() {
        return this.fileRegion.keySet();
    }

    public File createFile(String name) throws IOException {
        File file = new File(this, name);
        if (null != this.fileRegion.putIfAbsent(name, file)) {
            throw new IOException("File exists.");
        }
        this.stats.incFileCreates(1);
        return file;
    }

    public File createTemporaryFile(String name) throws IOException {
        File file = new File(this, name);
        this.stats.incTemporaryFileCreates(1);
        return file;
    }

    public File getFile(String name) throws FileNotFoundException {
        File file = (File)this.fileRegion.get(name);
        if (null == file) {
            throw new FileNotFoundException(name);
        }
        file.setFileSystem(this);
        return file;
    }

    public void deleteFile(String name) throws FileNotFoundException {
        File file = (File)this.fileRegion.remove(name);
        if (file == null) {
            throw new FileNotFoundException(name);
        }
        ChunkKey key = new ChunkKey(file.id, 0);
        while (null != this.chunkRegion.remove(key)) {
            ++key.chunkId;
        }
        this.stats.incFileDeletes(1);
    }

    public void renameFile(String source, String dest) throws IOException {
        File sourceFile = (File)this.fileRegion.get(source);
        if (null == sourceFile) {
            throw new FileNotFoundException(source);
        }
        File destFile = this.createFile(dest);
        destFile.chunks = sourceFile.chunks;
        destFile.created = sourceFile.created;
        destFile.length = sourceFile.length;
        destFile.modified = sourceFile.modified;
        destFile.id = sourceFile.id;
        this.updateFile(destFile);
        this.fileRegion.remove(source);
        this.stats.incFileRenames(1);
    }

    byte[] getChunk(File file, int id) {
        ChunkKey key = new ChunkKey(file.id, id);
        if (id >= file.chunks) {
            while (this.chunkRegion.containsKey(key)) {
                this.chunkRegion.remove(key);
                ++key.chunkId;
            }
            return null;
        }
        byte[] chunk = (byte[])this.chunkRegion.get(key);
        this.stats.incReadBytes(chunk.length);
        return chunk;
    }

    public void putChunk(File file, int id, byte[] chunk) {
        ChunkKey key = new ChunkKey(file.id, id);
        this.chunkRegion.put(key, chunk);
        this.stats.incWrittenBytes(chunk.length);
    }

    void updateFile(File file) {
        this.fileRegion.put(file.getName(), file);
    }

    public ConcurrentMap<String, File> getFileRegion() {
        return this.fileRegion;
    }

    public ConcurrentMap<ChunkKey, byte[]> getChunkRegion() {
        return this.chunkRegion;
    }

    public void export(java.io.File exportLocation) {
        this.listFileNames().stream().forEach(fileName -> {
            try {
                this.getFile((String)fileName).export(exportLocation);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        });
    }
}

