/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal.cli;

import java.io.Serializable;

public class LuceneSearchResults<K, V>
implements Comparable<LuceneSearchResults>,
Serializable {
    private String key;
    private String value;
    private float score;
    private boolean exceptionFlag = false;
    private String exceptionMessage;

    public LuceneSearchResults(String key, String value, float score) {
        this.key = key;
        this.value = value;
        this.score = score;
    }

    public LuceneSearchResults(String key) {
        this.key = key;
    }

    public LuceneSearchResults(boolean exceptionFlag, String exceptionMessage) {
        this.exceptionFlag = exceptionFlag;
        this.exceptionMessage = exceptionMessage;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public float getScore() {
        return this.score;
    }

    @Override
    public int compareTo(LuceneSearchResults searchResults) {
        return Float.compare(this.getScore(), searchResults.getScore());
    }

    public boolean getExeptionFlag() {
        return this.exceptionFlag;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public String toString() {
        return "LuceneSearchResults{key='" + this.key + '\'' + ", value='" + this.value + '\'' + ", score=" + this.score + ", exceptionFlag=" + this.exceptionFlag + ", exceptionMessage='" + this.exceptionMessage + '\'' + '}';
    }
}

