/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import java.util.HashSet;
import org.apache.geode.cache.query.CqException;
import org.apache.geode.cache.query.internal.cq.CqQueryImpl;
import org.apache.geode.cache.query.internal.cq.CqService;
import org.apache.geode.cache.query.internal.cq.InternalCqQuery;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.internal.cache.tier.CachedRegionHelper;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.cache.tier.sockets.command.BaseCQCommand;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.security.AuthorizeRequest;

public class StopCQ
extends BaseCQCommand {
    private static final StopCQ singleton = new StopCQ();

    public static Command getCommand() {
        return singleton;
    }

    private StopCQ() {
    }

    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException {
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        ClientProxyMembershipID id = servConn.getProxyID();
        CacheServerStats stats = servConn.getCacheServerStats();
        servConn.setAsTrue(2);
        servConn.setAsTrue(3);
        start = DistributionStats.getStatTime();
        String cqName = msg.getPart(0).getString();
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received stop CQ request from {} cqName: {}", (Object)servConn.getName(), (Object)servConn.getSocketString(), (Object)cqName);
        }
        if (cqName == null) {
            String err = LocalizedStrings.StopCQ_THE_CQNAME_FOR_THE_CQ_STOP_REQUEST_IS_NULL.toLocalizedString();
            this.sendCqResponse(47, err, msg.getTransactionId(), null, servConn);
            return;
        }
        try {
            CqService cqService = crHelper.getCache().getCqService();
            cqService.start();
            String serverCqName = cqName;
            if (id != null) {
                serverCqName = cqService.constructServerCqName(cqName, id);
            }
            InternalCqQuery cqQuery = cqService.getCq(serverCqName);
            this.securityService.authorizeDataManage();
            AuthorizeRequest authzRequest = servConn.getAuthzRequest();
            if (authzRequest != null) {
                String queryStr = null;
                HashSet<String> cqRegionNames = null;
                if (cqQuery != null) {
                    queryStr = cqQuery.getQueryString();
                    cqRegionNames = new HashSet<String>();
                    cqRegionNames.add(((CqQueryImpl)cqQuery).getRegionName());
                }
                authzRequest.stopCQAuthorize(cqName, queryStr, cqRegionNames);
            }
            cqService.stopCq(cqName, id);
            if (cqQuery != null) {
                servConn.removeCq(cqName, cqQuery.isDurable());
            }
        }
        catch (CqException cqe) {
            this.sendCqResponse(50, "", msg.getTransactionId(), cqe, servConn);
            return;
        }
        catch (Exception e) {
            String err = LocalizedStrings.StopCQ_EXCEPTION_WHILE_STOPPING_CQ_NAMED_0.toLocalizedString(new Object[]{cqName});
            this.sendCqResponse(50, err, msg.getTransactionId(), e, servConn);
            return;
        }
        this.sendCqResponse(6, LocalizedStrings.StopCQ_CQ_STOPPED_SUCCESSFULLY.toLocalizedString(), msg.getTransactionId(), null, servConn);
        servConn.setAsTrue(1);
        long oldStart = start;
        start = DistributionStats.getStatTime();
        stats.incProcessStopCqTime(start - oldStart);
    }
}

