% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scalar.R
\docType{class}
\name{Scalar}
\alias{Scalar}
\title{Arrow scalars}
\description{
A \code{Scalar} holds a single value of an Arrow type.
}
\section{Factory}{

The \code{Scalar$create()} factory method instantiates a \code{Scalar} and takes the following arguments:
\itemize{
\item \code{x}: an R vector, list, or \code{data.frame}
\item \code{type}: an optional \link[=data-type]{data type} for \code{x}. If omitted, the type will be inferred from the data.
}
}

\section{Usage}{
\preformatted{a <- Scalar$create(x)
length(a)

print(a)
a == a
}
}

\section{Methods}{

\itemize{
\item \verb{$ToString()}: convert to a string
\item \verb{$as_vector()}: convert to an R vector
\item \verb{$as_array()}: convert to an Arrow \code{Array}
\item \verb{$Equals(other)}: is this Scalar equal to \code{other}
\item \verb{$ApproxEquals(other)}: is this Scalar approximately equal to \code{other}
\item \verb{$is_valid}: is this Scalar valid
\item \verb{$null_count}: number of invalid values - 1 or 0
\item \verb{$type}: Scalar type
\item \verb{$cast(target_type, safe = TRUE, options = cast_options(safe))}: cast value
to a different type
}
}

\examples{
\dontshow{if (arrow_available()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
Scalar$create(pi)
Scalar$create(404)
# If you pass a vector into Scalar$create, you get a list containing your items
Scalar$create(c(1, 2, 3))

# Comparisons
my_scalar <- Scalar$create(99)
my_scalar$ApproxEquals(Scalar$create(99.00001)) # FALSE
my_scalar$ApproxEquals(Scalar$create(99.000009)) # TRUE
my_scalar$Equals(Scalar$create(99.000009)) # FALSE
my_scalar$Equals(Scalar$create(99L)) # FALSE (types don't match)

my_scalar$ToString()
\dontshow{\}) # examplesIf}
}
