/*
 *      search.c from Access Point SNMP Utils for Linux
 *
 * Copyright (c) 2002 Roman Festchook <roma at polesye dot net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2 from
 * June 1991 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
#include <string.h>
#include <stdio.h>
#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#if defined (__GLIBC__)
#include <libgen.h>
#endif
#include <ncurses.h>
#include "ap-utils.h"
#include <time.h>
#include <signal.h>
#include <setjmp.h>
#include <errno.h>

sigjmp_buf position;
extern char *community;
extern short ap_type;
extern int sockfd;
int retries, i;

static void alarm_handler()
{
    retries--;
    siglongjmp(position, 1);
}

void ap_search()
{
    extern WINDOW *main_sub;
    unsigned char message[1024], *comm = community, *start;
    char Wireless[3][12] = {
      {0x2B, 0x06, 0x01, 0x04, 0x01, 0x83, 0x1a, 0x01, 0x01, 0x01, 0x01, 0x00},
      {0x2b, 0x06, 0x01, 0x02, 0x01, 0x01, 0x01, 0x00},
      {0x2B, 0x06, 0x01, 0x04, 0x01, 0xE0, 0x3E, 0x01, 0x01, 0x01, 0x01, 0x00},
    };
    varbind varbinds[1];
    int len, client_len = SIZE;
    int errno, ap_type_reserv = ap_type;
    struct sockaddr_in from, to;
    struct sopts {
	int broad;
    } opts = {
    1};
    struct ip_mreq mult = { {0}, {INADDR_ANY} };
    int sockfd_reserv = sockfd;
    extern char *ap_types[];

    struct faps {
	struct in_addr ip;
	int type; 
    } fapsa[10];
	
    errno = 0;
    memset(&from, 0, sizeof from);
    from.sin_family = PF_INET;
    from.sin_port = INADDR_ANY;
    from.sin_addr.s_addr = INADDR_ANY;
    memset(&to, 0, sizeof to);
    to.sin_family = PF_INET;
    to.sin_port = htons(161);

    if ((sockfd = socket(PF_INET, SOCK_DGRAM, 0)) == -1) {
	print_helperr(CREATE_SOCKET_ERROR);
	goto exit;
    }
    if (bind(sockfd, (struct sockaddr *) &from, SIZE) == -1) {
	print_helperr(BIND_SOCKET_ERROR);
	goto exit;
    }
	mvwaddstr(main_sub, 0, 0, "#       Type              IP          Description");
	i=0;
for(ap_type = ATMEL12350; ap_type >= ATMEL410; ap_type--) {
    if (ap_type == ATMEL410 || ap_type == ATMEL12350)
	to.sin_addr.s_addr = -1;	/* 255.255.255.255 */
    else {
	if (inet_aton("224.0.1.43", &mult.imr_multiaddr) == 0) {
	    print_helperr(_("Invalid multicast address. Press any key."));
	    getch();
	    continue;
	}
	to.sin_addr = mult.imr_multiaddr;
    }




    if (ap_type == ATMEL410 || ap_type == ATMEL12350) {
	if (setsockopt
	    (sockfd, SOL_SOCKET, SO_BROADCAST, &opts,
	     sizeof(struct sopts)) == -1) {
	    print_helperr(_
		       ("Can't set broadcast option on socket. Press any key."));
	    getch();
	continue;
	}
	community = "public";
    } else {
	if (setsockopt(sockfd, IPPROTO_IP, IP_ADD_MEMBERSHIP, &mult, sizeof(struct ip_mreq)) == -1) {
	print_helperr(_("Can't set multicast membership on socket. Press any key."));
	    getch();
	continue;
    }

    }
    varbinds[0].oid = Wireless[ap_type];
    varbinds[0].len_oid =
	(ap_type == ATMEL410 || ap_type == ATMEL12350) ? sizeof(Wireless[ap_type]) : 8;
    varbinds[0].len_val = 0;
    varbinds[0].type = NULL_VALUE;
    print_title(_("Access Points Search"));
    print_help(_("Searching please wait..."));
    len = ber(message, varbinds, 1, GET);

    if (sendto(sockfd, message, len, 0, (struct sockaddr *) &to, SIZE) ==
	-1) {
	sprintf(message, _("Invalid sendto: %s. Press any key."),
		strerror(errno));
	print_helperr(message);
	getch();
    	continue;
    }

    retries = 1;
    signal(SIGALRM, alarm_handler);
    sigsetjmp(position, 1);
    if (!retries) {
	continue;
    }
    alarm(2);
    while (1) {
	if ((len =
	     recvfrom(sockfd, message, 512, 0, (struct sockaddr *) &from,
		      &client_len)) == -1)
	    continue;
	    
	    start = message;
	    if (*start != ASN_HEADER)
		continue;

	    start += (start[1] & 0x80) ? (start[1] & 0x7F) + 2 : 2;
	    start += *(start + 4) + 5;

	    if (*(start) != RESPONSE)
		continue;

	    start += (start[1] & 0x80) ? (start[1] & 0x7F) + 2 : 2;

	    if (*(start + 5) || *(start + 9) != ASN_HEADER)
		continue;

	    start += (start[10] & 0x80) ? (start[10] & 0x7F) + 11 : 11;

	    if (*(start) != ASN_HEADER)
		continue;

	    start += (start[1] & 0x80) ? (start[1] & 0x7F) + 2 : 2;
	    start += *(start + 1) + 2;

	    if (start[1] & 0x80) {
		varbinds[0].len_val = start[2];
		start += (start[1] & 0x7F) + 2;
	    } else {
		varbinds[0].len_val = start[1];
		start += 2;
	    }
	    fapsa[i].ip=from.sin_addr;
	    fapsa[i].type=ap_type;
	    sprintf(message, "%X %10s %15s", i, ap_types[fapsa[i].type], inet_ntoa(fapsa[i].ip));
	    mvwaddstr(main_sub, i+1, 0, message);
	    for (len = 0; len < varbinds[0].len_val && start[len]; len++) {
		mvwaddch(main_sub, i+1, len + 29, start[len]);
	    }
	    
	i++;
    }

}
    if (!i) {
	mvwaddstr(main_sub, i+2, 5, _("No Access Points found."));
	wrefresh(main_sub);
	print_help(ANY_KEY);
    }
    else {
	len = i;
	wrefresh(main_sub);
	print_help(_("# - connect to AP; Q - quit"));
	while (1)
              switch (i = getch()) {
	                 case 'Q':
	                 case 'q':
				    community = comm;
				    ap_type = ap_type_reserv;
				    close(sockfd);
				    sockfd = sockfd_reserv;
	                         goto quit;
                         case '0':
			 case '1':
	                 case '2':
	                 case '3':
                         case '4':
                         case '5':
                         case '6':
                         case '7':
                         case '8':
                         case '9':
				    community = comm;
				    ap_type = ap_type_reserv;
				    close(sockfd);
				    sockfd = sockfd_reserv;
				 print_title("");
				 clear_main(0);
				 if (i-'0' <= len) {
				    connect_options(fapsa[i-'0'].ip.s_addr, fapsa[i-'0'].type);
				} else {
				    connect_options((unsigned long) NULL, (int) NULL);
				}				
				 return;
	      }
    }

  exit:
    getch();
 quit:
    print_help("");
    print_title("");
    clear_main(0);
}

