
'\"
'\" The contents of this file are subject to the AOLserver Public License
'\" Version 1.1 (the "License"); you may not use this file except in
'\" compliance with the License. You may obtain a copy of the License at
'\" http://aolserver.com/.
'\"
'\" Software distributed under the License is distributed on an "AS IS"
'\" basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
'\" the License for the specific language governing rights and limitations
'\" under the License.
'\"
'\" The Original Code is AOLserver Code and related documentation
'\" distributed by AOL.
'\" 
'\" The Initial Developer of the Original Code is America Online,
'\" Inc. Portions created by AOL are Copyright (C) 1999 America Online,
'\" Inc. All Rights Reserved.
'\"
'\" Alternatively, the contents of this file may be used under the terms
'\" of the GNU General Public License (the "GPL"), in which case the
'\" provisions of GPL are applicable instead of those above.  If you wish
'\" to allow use of your version of this file only under the terms of the
'\" GPL and not to allow others to use your version of this file under the
'\" License, indicate your decision by deleting the provisions above and
'\" replace them with the notice and other provisions required by the GPL.
'\" If you do not delete the provisions above, a recipient may use your
'\" version of this file under either the License or the GPL.
'\" 
'\"
'\" $Header: /Users/dossy/Desktop/cvs/aolserver/doc/ns_adp.n,v 1.7 2006/04/13 19:05:47 jgdavidson Exp $
'\"
'\" 
.so man.macros
.TH ns_adp n 4.5 AOLserver "AOLserver Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
ns_adp \- ADP introduction and operation

.SH DESCRIPTION
.PP
Several commands, normally beginning with the \fBns_adp\fR prefix,
are used to support \fBAOLserver Dynamic Pages\fR, or \fBADP's\fR.
ADP's are a server-side environment for embedding Tcl code within
static text blocks (typically HTML or XML).  The Tcl code is normally
delimited within \fI<%\fR and \fI%>\fR or \fI<%=\fR and \fI%>\fR
tags and can be used to generate additional text or for any other
purpose, e.g., updating a database.  The \fI<% ...script... %>\fR
is used for cases where the result of the Tcl script is ignored
while the \fI<%= ...script %>\fR syntax is used to append the script
result to the output buffer.  In either case, the \fBns_adp_puts\fR
command can be used to add content to the output buffer.  A simple
ADP file could contain:

.CS
<html>
<head><title>Hello from <%=[ns_info hostname]%></title></head>
<body>
Time is: <%=[clock format [clock seconds]]%>
Four links:
<%
for {set i 0} {$i < 4} {incr i} {
	ns_adp_puts "<a href=/link/$i.htm>Link $i</a><br>"
}
%>
</body></html>
.CE

.PP
Accessing this page would generate output similar to:

.CS
<html>
<head><title>Hello from jgdavidson.local</title></head>
<body> 
Time is: Mon Aug 01 22:15:18 EDT 2005
Ten links:
<a href=/link/0.htm>Link 0</a><br>
<a href=/link/1.htm>Link 1</a><br>
<a href=/link/2.htm>Link 2</a><br>
<a href=/link/3.htm>Link 3</a><br>
</body></html>
.CE

.PP
ADP processing normally occurs in the context of an HTTP transaction
when an URL request is mapped to an ADP file in the server's page
root.  (see \fBADP CONFIGURATION\fR below for details on configuring
this mapping).  The ADP request processing code allocates a Tcl
interpreter and includes the cooresponding ADP file.  Output generated
during execution of the ADP is sent as a normal HTTP response, using
default status code of "200 OK" and the mime type which corresponds
to the ADP file extensions, normally .adp and text/html (commands
such as \fBns_adp_mimetype\fR can be used to control the eventual
response type).

.PP
An ADP can include additional ADP files with the \fBns_adp_include\fR
command or evaluate ADP text/script code directly with \fBns_adp_eval\fR.
This capability enables are large degree of reuse of presentation
and code between applications.  Each such included file or ADP
string evaluation is performed in it's own \fIcall frame\fR similar
to a Tcl procedure with a local variable namespace.  Arguments can
be passed to new call frames and then accessed with commands such
as \fBns_adp_argv\fR.  When necessary, commands such as \fBns_adp_abort\fR
provide limited support to interrupt and/or return from within an
ADP, unwinding the ADP call stack to the underyling C-level request
processing code.

.SH CONFIGURATION
.PP
AOLserver can be configured to execute ADP's placed with other
static files within a virtual server's pages directory via the
\fImap\fR parameter in the \fIadp\fR server config section, for
example:

.CS
ns_section ns/server/server1/adp
ns_param map /*.adp
ns_param map {/stories/*.adp 60}
.CE
.sp

.PP
The first map will evaluate all files which end in \fI.adp\fR and
do not have more specific mappings (such as the second map).  The
second config map will execute files which end with \fI.adp\fR
located under the \fI/stories\fR directly and also specifies a cache
timeout in seconds. In this case, results will be retained and
returned to subsequent requests without re-executing the ADP for
up to 60 seconds (see the \fI-cache\fR paramter to the \fBns_adp_include\fR
command for more details).

.PP
Alternatively, arbitrary URL's may be mapped to individual ADP files
using the \fBns_register_adp\fR command.  This command would normally
be included in a virtual-server initialization scripts within the
\fImodules/tcl/\fR server subdirectory.

.SH "ERROR HANDLING AND EXCEPTIONS"
.PP
By default, errors within an ADP script block are reported in the
server log and interrupt execution of the current block only;
subsequent text and script blocks continue to be processed and and
no error message is included in the output.  This approach is highly
defensive and has the benefit of generating a valid, if partial,
responses after minor errors.  A negative aspect of this approach
is that, without careful monitoring of the server log, such errors
can easily be ignored.

.PP
The default error handling behavior can be modified by settings one
or more virtual-server configuration flags:

.CS
ns_section ns/server/server1/adp
ns_param stricterror false;  # Interrupt execution on any error.
ns_param displayerror false; # Include error message in output.
ns_param detailerror true;   # Include connection details messages.
.CE

These flags, along with other options, can be queried or modified
for an individual ADP execution stream via the \fBns_adp_ctl\fR.

.SH "SCRIPT BLOCK SCOPE"
.PP
By default, each Tcl block is independent of other blocks and must
be a complete script.  In particular, this means that conditional
code cannot span blocks, e.g., the following does not work by default:

.CS
<% foreach elem $list { %>
	Here is an <%=$elem%> element.
<% } %>
.CE

.PP
This behavior can be changed with the \fIsinglescript\fR config
option or via the \fBns_adp_ctl\fR command which instructs the ADP
parser to converts all text/code blocks within an ADP into a single
Tcl script block:

.CS
ns_section ns/server/server1/adp
ns_param singlescript false;  # Combine code blocks into one scripts.
.CE

.PP
Setting this option would covert the script above into the following
equivalent:

.CS
<% foreach elem $list {
	ns_adp_puts -nonewline "\\n    Here is an "
	ns_adp_puts -nonewline $elem
	ns_adp_puts -nonewline " element.\\n"
} %>
.CE

.PP
Note that this option combines scripts within a particular ADP file,
it does not combine scripts which span multiple included ADP's.  In
addition, error semantics described above apply to the combined
script and any error within any block combined into a single script
will stop execution of the entire included page.

.SH "BUFFER MANAGEMENT"
.PP
Output including accumulated text blocks and output generated by
Tcl script blocks is normally buffered internally until the end of
the connection.  Once complete, a single response is generated which
follows HTTP response headers indicating the resulting content
length.  The content may optionally be gzip compressed first.

.PP
Alternatively, an incremental response can be be generated either
in response to calling the \fBns_adp_stream\fR or \fBns_adp_flush\fR
commands or automatically due to buffer overflow.  In this case,
an HTTP response will be generated on the first flush which specifies
incremental content using HTTP/1.1 chunked-encoding.  Forcing a
connection into streaming mode can be useful for certain long running
requests where it's reasonable to expect the browser can render
incremental respnoses.

.PP
The size of the internal buffer and gzip compression options can
be set with corresponding server and ADP config options. Note both
the virtual-server wide gzip and ADP gzip options must be enabled
to support compression of ADP output.

.CS
ns_section ns/server/server1
ns_param gzip true;	 # Enable compression.
ns_param gziplevel 4;	 # Compression level.
ns_param gzipmin 4096;	 # Minimum size before gzip.

ns_section ns/server/server1/adp
ns_param gzip true;	 # Enable ADP output compression.
ns_param bufsize 102400; # Buffer size, 1meg default.
.CE

.SH "CHARACTER ENCODING"
.PP
The ADP interface uses the server's mimetype configuration to map
file extensions to charsets and cooresponding encoding.  This
configuration is necessary to ensure the file text and script blocks
are properly coverted to UTF-8 for use internally.  This mimetype
is also used to set the character output encoding although the
\fBns_conn encoding\fR option can be used to override the encoding
if necessary.

.SH "SEE ALSO"
ns_adp_include(n), ns_adp_puts(n), ns_adp_ctl(n)

.SH KEYWORDS
ADP, dynamic pages
