/* angst - enable.c
 * by Patroklos Argyroudis <argp@bsd.gr>
 *
 * Functions for enabling IP forwarding on the local host.
 *
 * $Id: enable.c,v 1.7 2001/02/04 20:22:47 argp Exp $
 */ 

#include "angst.h"

#ifdef LINUX

/* originally by charon, slightly modified by me,
 * is there a sysctl(3)-like function for Linux?
 */
void
linux_enable_ip_forwarding(void)
{
 u_char *proc_node = "/proc/sys/net/ipv4/ip_forward";
 FILE *fp;
 
 if((fp = fopen(proc_node, "w")) == NULL)
  xprintf("fopen error: %s\n", strerror(errno));
  
 if((fputs("1", fp)) == EOF)
  xprintf("fputs error: %s\n", strerror(errno));
  
#ifdef DEBUG
 fprintf(stderr, "IP forwarding enabled successfully\n");
#endif /* DEBUG */
}

#else /* {Free,Net,Open}BSD */

/* enable IP forwarding on the local host,
 * works on {Free,Net,Open}BSD..
 */
void
bsd_enable_ip_forwarding(void)
{
 int mib[MIBLEN];	/* for sysctl() */
 int val = 1;		/* for sysctl() */
 
 mib[0] = CTL_NET;
 mib[1] = PF_INET;
 mib[2] = IPPROTO_IP;
 mib[3] = IPCTL_FORWARDING;
 
 if((sysctl(mib, MIBLEN, NULL, NULL, &val, sizeof(val))) == -1)
  xprintf("sysctl error: %s\n", strerror(errno));

#ifdef DEBUG
 fprintf(stderr, "net.inet.ip.forwarding = %d\n", val);
#endif /* DEBUG */
}

#endif /* LINUX */

/* EOF */
