/**
 * \file list-mon-race-flags.h
 * \brief monster race flags
 *
 * Changing flag order will break savefiles. There was a hard-coded limit of
 * 96 flags, due to 12 bytes of storage for lore flags in the savefile; this 
 * should be fixed now. Flags below start from 1 on line 13, so a flag's 
 * sequence number is its line number minus 12. Column 2 (descr) is currently 
 * used for lore descriptions.
 */
/* symbol       descr */
RF(NONE,       "", "")
RF(UNIQUE,     "", "")
RF(QUESTOR,    "", "")
RF(MALE,       "", "")
RF(FEMALE,     "", "")
RF(CHAR_CLEAR, "", "")
RF(ATTR_RAND,	"","")
RF(ATTR_CLEAR, "", "")
RF(ATTR_MULTI, "", "")
RF(FORCE_DEPTH,"", "")
RF(UNAWARE,		"","")
RF(FORCE_SLEEP,"", "")
RF(FORCE_EXTRA,"", "")
RF(GROUP_AI,      "", "")
RF(SEASONAL,    "", "")
RF(NEVER_BLOW, "", "")
RF(NEVER_MOVE, "", "")
RF(RAND_25,    "", "")
RF(RAND_50,    "", "")
RF(ONLY_GOLD,  "", "")
RF(ONLY_ITEM,  "", "")
RF(DROP_40,    "", "")
RF(DROP_60,    "", "")
RF(DROP_1,     "", "")
RF(DROP_2,     "", "")
RF(DROP_3,     "", "")
RF(DROP_4,     "", "")
RF(DROP_GOOD,  "", "")
RF(DROP_GREAT, "", "")
RF(DROP_20,    "", "")
RF(MIMIC_INV,  "", "")
RF(STUPID,     "", "")
RF(SMART,      "", "")
RF(HAS_LIGHT,  "", "")
RF(ATTR_FLICKER,"","")
RF(INVISIBLE,  "", "invisible")
RF(COLD_BLOOD, "", "cold blooded")
RF(EMPTY_MIND, "", "not detected by telepathy")
RF(WEIRD_MIND, "", "rarely detected by telepathy")
RF(MULTIPLY,   "", "")
RF(REGENERATE, "", "")
RF(POWERFUL,   "", "")
RF(OPEN_DOOR,  "", "open doors")
RF(BASH_DOOR,  "", "bash down doors")
RF(PASS_WALL,  "", "pass through walls")
RF(KILL_WALL,  "", "bore through walls")
RF(MOVE_BODY,  "", "push past weaker monsters")
RF(KILL_BODY,  "", "destroy weaker monsters")
RF(TAKE_ITEM,  "", "pick up objects")
RF(KILL_ITEM,  "", "destroy objects")
RF(ORC,        "orcs", "orc")
RF(TROLL,      "trolls", "troll")
RF(GIANT,      "giants", "giant")
RF(DRAGON,     "dragons", "dragon")
RF(DEMON,      "demons", "demon")
RF(UNDEAD,     "undead", "undead")
RF(EVIL,       "evil creatures", "evil")
RF(ANIMAL,     "animals", "natural")
RF(METAL,      "", "metal")
RF(NONLIVING,	"","nonliving")
RF(HURT_LIGHT, "", "bright light")
RF(HURT_ROCK,  "", "rock remover")
RF(HURT_FIRE,  "", "fire")
RF(HURT_COLD,  "", "cold")
RF(IM_ACID,    "", "acid")
RF(IM_ELEC,    "", "lightning")
RF(IM_FIRE,    "", "fire")
RF(IM_COLD,    "", "cold")
RF(IM_POIS,    "", "poison")
RF(IM_NETHER,  "", "nether")
RF(IM_WATER,   "", "water")
RF(IM_PLASMA,  "", "plasma")
RF(IM_NEXUS,   "", "nexus")
RF(IM_DISEN,   "", "disenchantment")
RF(NO_FEAR,    "", "frightened")
RF(NO_STUN,    "", "stunned")
RF(NO_CONF,    "", "confused")
RF(NO_SLEEP,   "", "slept")
/* end flags */
