/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository;

import com.android.annotations.NonNull;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FullRevision
implements Comparable<FullRevision> {
    public static final int MISSING_MAJOR_REV = 0;
    public static final int IMPLICIT_MINOR_REV = 0;
    public static final int IMPLICIT_MICRO_REV = 0;
    public static final int NOT_A_PREVIEW = 0;
    public static final FullRevision NOT_SPECIFIED = new FullRevision(0);
    private static final Pattern FULL_REVISION_PATTERN = Pattern.compile("\\s*([0-9]+)(?:\\.([0-9]+)(?:\\.([0-9]+))?)?\\s*(?:rc([0-9]+))?\\s*");
    private final int mMajor;
    private final int mMinor;
    private final int mMicro;
    private final int mPreview;

    public FullRevision(int major) {
        this(major, 0, 0);
    }

    public FullRevision(int major, int minor, int micro) {
        this(major, minor, micro, 0);
    }

    public FullRevision(int major, int minor, int micro, int preview) {
        this.mMajor = major;
        this.mMinor = minor;
        this.mMicro = micro;
        this.mPreview = preview;
    }

    public int getMajor() {
        return this.mMajor;
    }

    public int getMinor() {
        return this.mMinor;
    }

    public int getMicro() {
        return this.mMicro;
    }

    public boolean isPreview() {
        return this.mPreview > 0;
    }

    public int getPreview() {
        return this.mPreview;
    }

    @NonNull
    public static FullRevision parseRevision(@NonNull String revision) throws NumberFormatException {
        return FullRevision.parseRevisionImpl(revision, true, true);
    }

    @NonNull
    protected static FullRevision parseRevisionImpl(@NonNull String revision, boolean supportMinorMicro, boolean supportPreview) throws NumberFormatException {
        if (revision == null) {
            throw new NumberFormatException("revision is <null>");
        }
        Throwable cause = null;
        String error = null;
        try {
            Matcher m = FULL_REVISION_PATTERN.matcher(revision);
            if (m != null && m.matches()) {
                int major = Integer.parseInt(m.group(1));
                int minor = 0;
                int micro = 0;
                int preview = 0;
                String s = m.group(2);
                if (s != null) {
                    if (!supportMinorMicro) {
                        error = " -- Minor number not supported";
                    } else {
                        minor = Integer.parseInt(s);
                    }
                }
                if ((s = m.group(3)) != null) {
                    if (!supportMinorMicro) {
                        error = " -- Micro number not supported";
                    } else {
                        micro = Integer.parseInt(s);
                    }
                }
                if ((s = m.group(4)) != null) {
                    if (!supportPreview) {
                        error = " -- Preview number not supported";
                    } else {
                        preview = Integer.parseInt(s);
                    }
                }
                if (error == null) {
                    return new FullRevision(major, minor, micro, preview);
                }
            }
        }
        catch (Throwable t) {
            cause = t;
        }
        NumberFormatException n = new NumberFormatException("Invalid revision: " + revision + (error == null ? "" : error));
        if (cause != null) {
            n.initCause(cause);
        }
        throw n;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.mMajor).append('.').append(this.mMinor).append('.').append(this.mMicro);
        if (this.mPreview != 0) {
            sb.append(" rc").append(this.mPreview);
        }
        return sb.toString();
    }

    public String toShortString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.mMajor);
        if (this.mMinor > 0 || this.mMicro > 0) {
            sb.append('.').append(this.mMinor);
        }
        if (this.mMicro > 0) {
            sb.append('.').append(this.mMicro);
        }
        if (this.mPreview != 0) {
            sb.append(" rc").append(this.mPreview);
        }
        return sb.toString();
    }

    public int[] toIntArray(boolean includePreview) {
        int size = includePreview ? 4 : 3;
        int[] result = new int[size];
        result[0] = this.mMajor;
        result[1] = this.mMinor;
        result[2] = this.mMicro;
        if (result.length > 3) {
            result[3] = this.mPreview;
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.mMajor;
        result = 31 * result + this.mMinor;
        result = 31 * result + this.mMicro;
        result = 31 * result + this.mPreview;
        return result;
    }

    public boolean equals(Object rhs) {
        if (this == rhs) {
            return true;
        }
        if (rhs == null) {
            return false;
        }
        if (!(rhs instanceof FullRevision)) {
            return false;
        }
        FullRevision other = (FullRevision)rhs;
        if (this.mMajor != other.mMajor) {
            return false;
        }
        if (this.mMinor != other.mMinor) {
            return false;
        }
        if (this.mMicro != other.mMicro) {
            return false;
        }
        return this.mPreview == other.mPreview;
    }

    @Override
    public int compareTo(FullRevision rhs) {
        return this.compareTo(rhs, PreviewComparison.COMPARE_NUMBER);
    }

    public int compareTo(FullRevision rhs, PreviewComparison comparePreview) {
        int delta = this.mMajor - rhs.mMajor;
        if (delta != 0) {
            return delta;
        }
        delta = this.mMinor - rhs.mMinor;
        if (delta != 0) {
            return delta;
        }
        delta = this.mMicro - rhs.mMicro;
        if (delta != 0) {
            return delta;
        }
        switch (comparePreview) {
            case IGNORE: {
                break;
            }
            case COMPARE_NUMBER: {
                int p1 = this.mPreview == 0 ? Integer.MAX_VALUE : this.mPreview;
                int p2 = rhs.mPreview == 0 ? Integer.MAX_VALUE : rhs.mPreview;
                delta = p1 - p2;
                break;
            }
            case COMPARE_TYPE: {
                int p1 = this.mPreview == 0 ? 1 : 0;
                int p2 = rhs.mPreview == 0 ? 1 : 0;
                delta = p1 - p2;
            }
        }
        return delta;
    }

    public static enum PreviewComparison {
        COMPARE_NUMBER,
        COMPARE_TYPE,
        IGNORE;

    }
}

