/*
 * Decompiled with CFR 0.152.
 */
package jnr.netdb;

import com.kenai.jaffl.CallingConvention;
import com.kenai.jaffl.Library;
import com.kenai.jaffl.LibraryOption;
import com.kenai.jaffl.Platform;
import com.kenai.jaffl.Pointer;
import com.kenai.jaffl.struct.Struct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import jnr.netdb.Protocol;
import jnr.netdb.ProtocolsDB;
import jnr.netdb.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NativeProtocolsDB
implements ProtocolsDB {
    private final LibProto lib;

    public static final NativeProtocolsDB getInstance() {
        return SingletonHolder.INSTANCE;
    }

    NativeProtocolsDB(LibProto lib) {
        this.lib = lib;
    }

    private static final NativeProtocolsDB load() {
        try {
            LibProto libProto;
            Platform.OS os2 = Platform.getPlatform().getOS();
            if (!(os2.equals((Object)Platform.OS.DARWIN) || os2.equals((Object)Platform.OS.WINDOWS) && Platform.getPlatform().getCPU() == Platform.CPU.I386 || os2.equals((Object)Platform.OS.LINUX) || os2.equals((Object)Platform.OS.SOLARIS) || os2.equals((Object)Platform.OS.FREEBSD) || os2.equals((Object)Platform.OS.NETBSD))) {
                return null;
            }
            if (os2.equals((Object)Platform.OS.WINDOWS)) {
                HashMap<LibraryOption, CallingConvention> hashMap = new HashMap<LibraryOption, CallingConvention>();
                hashMap.put(LibraryOption.CallingConvention, CallingConvention.STDCALL);
                LibProto options = Library.loadLibrary(LibProto.class, hashMap, "Ws2_32");
            } else {
                String[] stringArray;
                if (os2.equals((Object)Platform.OS.SOLARIS)) {
                    String[] stringArray2 = new String[3];
                    stringArray2[0] = "socket";
                    stringArray2[1] = "nsl";
                    stringArray = stringArray2;
                    stringArray2[2] = "c";
                } else {
                    String[] stringArray3 = new String[1];
                    stringArray = stringArray3;
                    stringArray3[0] = "c";
                }
                String[] lib = stringArray;
                libProto = Library.loadLibrary(LibProto.class, lib);
            }
            libProto.getprotobyname("ip");
            libProto.getprotobynumber(0);
            return new NativeProtocolsDB(libProto);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private final Protocol protocolFromNative(UnixProtoent p) {
        if (p == null) {
            return null;
        }
        List emptyAliases = Collections.emptyList();
        Pointer ptr = p.aliases.get();
        List<String> aliases2 = ptr != null ? StringUtil.getNullTerminatedStringArray(ptr) : emptyAliases;
        return new Protocol(p.name.get(), (short)p.proto.get(), aliases2);
    }

    @Override
    public Protocol getProtocolByName(String name) {
        return this.protocolFromNative(this.lib.getprotobyname(name));
    }

    @Override
    public Protocol getProtocolByNumber(Integer proto) {
        return this.protocolFromNative(this.lib.getprotobynumber(proto));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public Collection<Protocol> getAllProtocols() {
        void p;
        ArrayList arrayList = new ArrayList();
        try {
            UnixProtoent allProtocols;
            while ((allProtocols = this.lib.getprotoent()) != null) {
                p.add(this.protocolFromNative(allProtocols));
            }
        }
        finally {
            this.lib.endprotoent();
        }
        return p;
    }

    static /* synthetic */ NativeProtocolsDB access$000() {
        return NativeProtocolsDB.load();
    }

    public static interface LibProto {
        public UnixProtoent getprotobyname(String var1);

        public UnixProtoent getprotobynumber(int var1);

        public UnixProtoent getprotoent();

        public void endprotoent();
    }

    public static class UnixProtoent
    extends Struct {
        public final Struct.String name = new Struct.UTF8StringRef();
        public final Struct.Pointer aliases = new Struct.Pointer();
        public final Struct.Signed32 proto = new Struct.Signed32();
    }

    private static final class SingletonHolder {
        public static final NativeProtocolsDB INSTANCE = NativeProtocolsDB.access$000();

        private SingletonHolder() {
        }
    }
}

