/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository;

import com.android.annotations.NonNull;
import com.android.sdklib.repository.RepoConstants;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SdkRepoConstants
extends RepoConstants {
    public static final int NS_LATEST_VERSION = 8;
    public static final int NS_SERVER_MIN_VERSION = 5;
    public static final String URL_GOOGLE_SDK_SITE = "https://dl-ssl.google.com/android/repository/";
    public static final String URL_DEFAULT_FILENAME = "repository.xml";
    public static final String URL_FILENAME_PATTERN = "repository-%1$d.xml";
    private static final String NS_BASE = "http://schemas.android.com/sdk/android/repository/";
    public static final String NS_PATTERN = "http://schemas.android.com/sdk/android/repository/([1-9][0-9]*)";
    public static final String NS_URI = SdkRepoConstants.getSchemaUri(8);
    public static final String NODE_SDK_REPOSITORY = "sdk-repository";
    public static final String NODE_MAJOR_REV = "major";
    public static final String NODE_MINOR_REV = "minor";
    public static final String NODE_MICRO_REV = "micro";
    public static final String NODE_PREVIEW = "preview";
    public static final String NODE_PLATFORM = "platform";
    public static final String NODE_TOOL = "tool";
    public static final String NODE_PLATFORM_TOOL = "platform-tool";
    public static final String NODE_BUILD_TOOL = "build-tool";
    public static final String NODE_DOC = "doc";
    public static final String NODE_SAMPLE = "sample";
    public static final String NODE_SOURCE = "source";
    public static final String[] NODES = new String[]{"platform", "system-image", "tool", "platform-tool", "doc", "sample", "source"};

    public static InputStream getXsdStream(int version) {
        return SdkRepoConstants.getXsdStream(NODE_SDK_REPOSITORY, version);
    }

    public static String getSchemaUri(int version) {
        return String.format("http://schemas.android.com/sdk/android/repository/%d", version);
    }

    public static boolean versionGreaterOrEqualThan(@NonNull String nsUri, int minVersion) {
        Pattern nsPattern = Pattern.compile(NS_PATTERN);
        Matcher m = nsPattern.matcher(nsUri);
        if (m.matches()) {
            String version = m.group(1);
            try {
                return Integer.parseInt(version) >= minVersion;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return false;
    }
}

