/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.devices;

import com.android.annotations.NonNull;
import com.android.sdklib.devices.CameraLocation;

public class Camera {
    @NonNull
    private CameraLocation mLocation;
    private boolean mAutofocus;
    private boolean mFlash;

    public Camera() {
        this(CameraLocation.BACK, true, true);
    }

    public Camera(@NonNull CameraLocation location, boolean autofocus, boolean flash) {
        this.mLocation = location;
        this.mAutofocus = autofocus;
        this.mFlash = flash;
    }

    @NonNull
    public CameraLocation getLocation() {
        return this.mLocation;
    }

    public void setLocation(@NonNull CameraLocation location) {
        this.mLocation = location;
    }

    public boolean hasAutofocus() {
        return this.mAutofocus;
    }

    public void setAutofocus(boolean hasAutofocus) {
        this.mAutofocus = hasAutofocus;
    }

    public boolean hasFlash() {
        return this.mFlash;
    }

    public void setFlash(boolean flash) {
        this.mFlash = flash;
    }

    @NonNull
    public Camera deepCopy() {
        Camera c = new Camera();
        c.mLocation = this.mLocation;
        c.mAutofocus = this.mAutofocus;
        c.mFlash = this.mFlash;
        return c;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Camera)) {
            return false;
        }
        Camera c = (Camera)o;
        return this.mLocation == c.mLocation && this.mAutofocus == c.hasAutofocus() && this.mFlash == c.hasFlash();
    }

    public int hashCode() {
        int hash = 17;
        hash = 31 * hash + this.mLocation.ordinal();
        hash = 31 * hash + (this.mAutofocus ? 1 : 0);
        hash = 31 * hash + (this.mFlash ? 1 : 0);
        return hash;
    }
}

