/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.monitor;

import com.android.SdkConstants;
import java.io.File;
import java.util.Arrays;
import java.util.List;

public class SdkToolsLocator {
    public static final String PLATFORM_EXECUTABLE_EXTENSION = SdkConstants.CURRENT_PLATFORM == 2 ? ".exe" : "";
    public static final String PLATFORM_SCRIPT_EXTENSION = SdkConstants.CURRENT_PLATFORM == 2 ? ".bat" : "";
    public static final String FN_HPROF_CONV = "hprof-conv" + PLATFORM_EXECUTABLE_EXTENSION;
    public static final String FN_TRACEVIEW = "traceview" + PLATFORM_SCRIPT_EXTENSION;
    private final File mSdkFolder;

    public SdkToolsLocator(File file) {
        this.mSdkFolder = file;
    }

    public String getAdbLocation() {
        return new File(this.getSdkPlatformToolsFolder(), SdkConstants.FN_ADB).getAbsolutePath();
    }

    public String getTraceViewLocation() {
        return new File(this.getSdkToolsFolder(), FN_TRACEVIEW).getAbsolutePath();
    }

    public String getHprofConvLocation() {
        return new File(this.getSdkToolsFolder(), FN_HPROF_CONV).getAbsolutePath();
    }

    private String getSdkToolsFolder() {
        return new File(this.mSdkFolder, "tools").getAbsolutePath();
    }

    private String getSdkPlatformToolsFolder() {
        return new File(this.mSdkFolder, "platform-tools").getAbsolutePath();
    }

    public SdkInstallStatus isValidInstallation() {
        List<String> list = Arrays.asList(this.getTraceViewLocation(), this.getHprofConvLocation());
        for (String string : list) {
            File file = new File(string);
            if (!file.exists()) {
                return SdkInstallStatus.invalidInstallation(String.valueOf(string) + " not present.");
            }
            if (file.canExecute()) continue;
            return SdkInstallStatus.invalidInstallation(String.valueOf(string) + " is not executable.");
        }
        return SdkInstallStatus.VALID;
    }

    public static class SdkInstallStatus {
        private boolean mValid;
        private String mCause;
        public static final SdkInstallStatus VALID = new SdkInstallStatus(true, "");

        private SdkInstallStatus(boolean bl, String string) {
            this.mValid = bl;
            this.mCause = string;
        }

        public boolean isValid() {
            return this.mValid;
        }

        public String getErrorMessage() {
            return this.mCause;
        }

        public static SdkInstallStatus invalidInstallation(String string) {
            return new SdkInstallStatus(false, string);
        }
    }
}

