/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.tasks;

import com.android.sdklib.internal.repository.ITask;
import com.android.sdkuilib.internal.tasks.ProgressTaskDialog;
import com.android.sdkuilib.internal.tasks.TaskMonitorImpl;
import org.eclipse.swt.widgets.Shell;

public final class ProgressTask
extends TaskMonitorImpl {
    private final String mTitle;
    private final ProgressTaskDialog mDialog;
    private volatile boolean mAutoClose = true;

    public ProgressTask(Shell parent, String title) {
        super(new ProgressTaskDialog(parent));
        this.mTitle = title;
        this.mDialog = (ProgressTaskDialog)this.getUiProvider();
        this.mDialog.setText(this.mTitle);
    }

    public void start(ITask task) {
        assert (this.mDialog != null);
        this.mDialog.open(this.createTaskThread(this.mTitle, task));
    }

    public void setAutoClose(boolean autoClose) {
        if (autoClose != this.mAutoClose) {
            if (autoClose) {
                this.mDialog.setAutoCloseRequested();
            } else {
                this.mDialog.setManualCloseRequested();
            }
            this.mAutoClose = autoClose;
        }
    }

    private Thread createTaskThread(String title, final ITask task) {
        if (task != null) {
            return new Thread(title){

                @Override
                public void run() {
                    task.run(ProgressTask.this);
                    if (ProgressTask.this.mAutoClose) {
                        ProgressTask.this.mDialog.setAutoCloseRequested();
                    } else {
                        ProgressTask.this.mDialog.setManualCloseRequested();
                    }
                }
            };
        }
        return null;
    }

    @Override
    public void logError(String format, Object ... args) {
        this.setAutoClose(false);
        super.logError(format, args);
    }
}

