/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.syntaxChecks;

import lombok.ast.Block;
import lombok.ast.Break;
import lombok.ast.Continue;
import lombok.ast.Message;
import lombok.ast.Node;
import lombok.ast.Return;
import lombok.ast.Statement;
import lombok.ast.syntaxChecks.MessageKey;

public class UnreachableStatementsChecks {
    public void unreachablesAfterBreak(Break statement) {
        this.checkForUnreachables(statement);
    }

    public void unreachablesAfterContinue(Continue statement) {
        this.checkForUnreachables(statement);
    }

    public void unreachableAfterReturn(Return statement) {
        this.checkForUnreachables(statement);
    }

    private void checkForUnreachables(Statement n) {
        Block b = n.upToBlock();
        if (b == null) {
            return;
        }
        boolean found = false;
        for (Node s : b.rawContents()) {
            if (found) {
                s.addMessage(Message.error(MessageKey.STATEMENT_UNREACHABLE, "Unreachable code"));
                return;
            }
            if (s != n) continue;
            found = true;
        }
    }
}

