/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.libs.org.parboiled.support;

import lombok.ast.libs.org.parboiled.Node;
import lombok.ast.libs.org.parboiled.common.Formatter;
import lombok.ast.libs.org.parboiled.common.StringUtils;
import lombok.ast.libs.org.parboiled.support.InputBuffer;
import lombok.ast.libs.org.parboiled.support.ParseTreeUtils;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeFormatter<V>
implements Formatter<Node<V>> {
    private final InputBuffer inputBuffer;

    public NodeFormatter(@NotNull InputBuffer inputBuffer) {
        if (inputBuffer == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.support.NodeFormatter.<init>(...) corresponds to @NotNull parameter and must not be null");
        }
        this.inputBuffer = inputBuffer;
    }

    @Override
    public String format(Node<V> node) {
        String nodeLabel = node.toString();
        String nodeText = StringUtils.escape(ParseTreeUtils.getNodeText(node, this.inputBuffer));
        return StringUtils.isEmpty(nodeText) ? nodeLabel : nodeLabel + " '" + nodeText + '\'';
    }
}

