/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.libs.org.parboiled.matchers;

import lombok.ast.libs.org.parboiled.MatcherContext;
import lombok.ast.libs.org.parboiled.Rule;
import lombok.ast.libs.org.parboiled.google.collect.ImmutableList;
import lombok.ast.libs.org.parboiled.matchers.Matcher;
import lombok.ast.libs.org.parboiled.trees.ImmutableGraphNode;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMatcher<V>
extends ImmutableGraphNode<Matcher<V>>
implements Matcher<V>,
Cloneable {
    private String label;
    private boolean nodeSuppressed;
    private boolean subnodesSuppressed;
    private boolean nodeSkipped;

    AbstractMatcher() {
        this(new Rule[0]);
    }

    AbstractMatcher(@NotNull Rule subRule) {
        if (subRule == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.matchers.AbstractMatcher.<init>(...) corresponds to @NotNull parameter and must not be null");
        }
        this(new Rule[]{subRule});
    }

    AbstractMatcher(@NotNull Rule[] subRules) {
        if (subRules == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.matchers.AbstractMatcher.<init>(...) corresponds to @NotNull parameter and must not be null");
        }
        super(ImmutableList.of(AbstractMatcher.toMatchers(subRules)));
    }

    private static Matcher[] toMatchers(@NotNull Rule[] subRules) {
        if (subRules == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.matchers.AbstractMatcher.toMatchers(...) corresponds to @NotNull parameter and must not be null");
        }
        Matcher[] matchers = new Matcher[subRules.length];
        for (int i = 0; i < subRules.length; ++i) {
            matchers[i] = (Matcher)subRules[i];
        }
        return matchers;
    }

    @Override
    public boolean isNodeSuppressed() {
        return this.nodeSuppressed;
    }

    @Override
    public boolean areSubnodesSuppressed() {
        return this.subnodesSuppressed;
    }

    @Override
    public boolean isNodeSkipped() {
        return this.nodeSkipped;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public String toString() {
        return this.getLabel();
    }

    @Override
    public AbstractMatcher<V> label(@NotNull String label) {
        if (label == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.matchers.AbstractMatcher.label(...) corresponds to @NotNull parameter and must not be null");
        }
        if (label.equals(this.label)) {
            return this;
        }
        AbstractMatcher<V> clone = this.createClone();
        clone.label = label;
        return clone;
    }

    @Override
    public Rule suppressNode() {
        if (this.nodeSuppressed) {
            return this;
        }
        AbstractMatcher<V> clone = this.createClone();
        clone.nodeSuppressed = true;
        return clone;
    }

    @Override
    public Rule suppressSubnodes() {
        if (this.subnodesSuppressed) {
            return this;
        }
        AbstractMatcher<V> clone = this.createClone();
        clone.subnodesSuppressed = true;
        return clone;
    }

    @Override
    public Rule skipNode() {
        if (this.nodeSkipped) {
            return this;
        }
        AbstractMatcher<V> clone = this.createClone();
        clone.nodeSkipped = true;
        return clone;
    }

    @Override
    public MatcherContext<V> getSubContext(MatcherContext<V> context) {
        return context.getSubContext(this);
    }

    private AbstractMatcher<V> createClone() {
        try {
            return (AbstractMatcher)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }
}

