/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.libs.org.parboiled.common;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import lombok.ast.libs.org.parboiled.errors.GrammarException;
import lombok.ast.libs.org.parboiled.google.collect.ImmutableList;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Utils {
    public static final Character[] EMPTY_CHARACTER_OBJECT_ARRAY = new Character[0];
    public static final Integer[] EMPTY_INTEGER_OBJECT_ARRAY = new Integer[0];
    public static final Long[] EMPTY_LONG_OBJECT_ARRAY = new Long[0];
    public static final Short[] EMPTY_SHORT_OBJECT_ARRAY = new Short[0];
    public static final Byte[] EMPTY_BYTE_OBJECT_ARRAY = new Byte[0];
    public static final Float[] EMPTY_FLOAT_OBJECT_ARRAY = new Float[0];
    public static final Double[] EMPTY_DOUBLE_OBJECT_ARRAY = new Double[0];
    public static final Boolean[] EMPTY_BOOLEAN_OBJECT_ARRAY = new Boolean[0];

    private Utils() {
    }

    public static Character[] toObjectArray(char[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_CHARACTER_OBJECT_ARRAY;
        }
        Character[] result = new Character[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = Character.valueOf(array[i]);
        }
        return result;
    }

    public static Integer[] toObjectArray(int[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_INTEGER_OBJECT_ARRAY;
        }
        Integer[] result = new Integer[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static Long[] toObjectArray(long[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_LONG_OBJECT_ARRAY;
        }
        Long[] result = new Long[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static Short[] toObjectArray(short[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_SHORT_OBJECT_ARRAY;
        }
        Short[] result = new Short[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static Byte[] toObjectArray(byte[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_BYTE_OBJECT_ARRAY;
        }
        Byte[] result = new Byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static Float[] toObjectArray(float[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_FLOAT_OBJECT_ARRAY;
        }
        Float[] result = new Float[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = Float.valueOf(array[i]);
        }
        return result;
    }

    public static Double[] toObjectArray(double[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_DOUBLE_OBJECT_ARRAY;
        }
        Double[] result = new Double[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static Boolean[] toObjectArray(boolean[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_BOOLEAN_OBJECT_ARRAY;
        }
        Boolean[] result = new Boolean[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static String toString(Object obj) {
        return obj == null ? "" : obj.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static List<Class<?>> getTypeArguments(@NotNull Class<?> base, @NotNull Class<?> implementation) {
        Type[] actualTypeArguments;
        List<Class<Object>> list;
        HashMap resolvedTypes;
        block19: {
            Type type;
            block18: {
                if (base == null) {
                    throw new IllegalArgumentException("1st argument of method org.parboiled.common.Utils.getTypeArguments(...) corresponds to @NotNull parameter and must not be null");
                }
                if (implementation == null) {
                    throw new IllegalArgumentException("2nd argument of method org.parboiled.common.Utils.getTypeArguments(...) corresponds to @NotNull parameter and must not be null");
                }
                resolvedTypes = new HashMap();
                LinkedList<Type> toCheck = new LinkedList<Type>();
                toCheck.add(implementation);
                while (true) {
                    Class clazz;
                    if (toCheck.isEmpty()) {
                        list = ImmutableList.of();
                        if (list == null) throw new IllegalStateException("@NotNull method org.parboiled.common.Utils.getTypeArguments must not return null");
                        return list;
                    }
                    type = (Type)toCheck.remove();
                    if (type instanceof Class) {
                        clazz = (Class)type;
                        if (base.isInterface()) {
                            toCheck.addAll(Arrays.asList(clazz.getGenericInterfaces()));
                        }
                    } else {
                        if (!(type instanceof ParameterizedType)) {
                            list = ImmutableList.of();
                            if (list == null) throw new IllegalStateException("@NotNull method org.parboiled.common.Utils.getTypeArguments must not return null");
                            return list;
                        }
                        ParameterizedType parameterizedType = (ParameterizedType)type;
                        clazz = (Class)parameterizedType.getRawType();
                        TypeVariable<Class<T>>[] typeParameters = clazz.getTypeParameters();
                        Type[] actualTypeArguments2 = parameterizedType.getActualTypeArguments();
                        for (int i = 0; i < actualTypeArguments2.length; ++i) {
                            resolvedTypes.put(typeParameters[i], actualTypeArguments2[i]);
                        }
                    }
                    if (base.equals(Utils.getClass(type))) {
                        if (type instanceof Class) {
                            break;
                        }
                        break block18;
                    }
                    toCheck.add(clazz.getGenericSuperclass());
                }
                actualTypeArguments = ((Class)type).getTypeParameters();
                break block19;
            }
            actualTypeArguments = ((ParameterizedType)type).getActualTypeArguments();
        }
        ArrayList typeArgumentsAsClasses = new ArrayList();
        for (Type baseType : actualTypeArguments) {
            while (resolvedTypes.containsKey(baseType)) {
                baseType = (Type)resolvedTypes.get(baseType);
            }
            typeArgumentsAsClasses.add(Utils.getClass(baseType));
        }
        list = typeArgumentsAsClasses;
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method org.parboiled.common.Utils.getTypeArguments must not return null");
    }

    public static Class<?> getClass(Type type) {
        Type componentType;
        Class<?> componentClass;
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return Utils.getClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType && (componentClass = Utils.getClass(componentType = ((GenericArrayType)type).getGenericComponentType())) != null) {
            return Array.newInstance(componentClass, 0).getClass();
        }
        return null;
    }

    public static Constructor findConstructor(Class<?> clazz, Object[] objectArray) {
        block0: for (Constructor<?> constructor : clazz.getConstructors()) {
            Class<?>[] classArray = constructor.getParameterTypes();
            if (classArray.length != objectArray.length) continue;
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                if (object != null && !classArray[i].isAssignableFrom(object.getClass()) || object == null && classArray[i].isPrimitive()) continue block0;
            }
            return constructor;
        }
        throw new GrammarException("No constructor found for %s and the given %s arguments", clazz, objectArray.length);
    }

    public static <K, V> Iterable<Map.Entry<K, V>> zip(final Iterable<K> keys, final Iterable<V> values) {
        return new Iterable<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    private final Iterator<K> keyIterator;
                    private final Iterator<V> valueIterator;
                    {
                        this.keyIterator = keys.iterator();
                        this.valueIterator = values.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.keyIterator.hasNext() && this.valueIterator.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        final Object key = this.keyIterator.next();
                        final Object value = this.valueIterator.next();
                        return new Map.Entry<K, V>(){

                            @Override
                            public K getKey() {
                                return key;
                            }

                            @Override
                            public V getValue() {
                                return value;
                            }

                            @Override
                            public V setValue(V value2) {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }
}

