/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.libs.org.parboiled;

import java.util.List;
import lombok.ast.libs.org.parboiled.BasicParseRunner;
import lombok.ast.libs.org.parboiled.MatchHandler;
import lombok.ast.libs.org.parboiled.MatcherContext;
import lombok.ast.libs.org.parboiled.RecordingParseRunner;
import lombok.ast.libs.org.parboiled.ReportingParseRunner;
import lombok.ast.libs.org.parboiled.Rule;
import lombok.ast.libs.org.parboiled.errors.InvalidInputError;
import lombok.ast.libs.org.parboiled.google.base.Preconditions;
import lombok.ast.libs.org.parboiled.matchers.Matcher;
import lombok.ast.libs.org.parboiled.matchers.SequenceMatcher;
import lombok.ast.libs.org.parboiled.matchers.TestMatcher;
import lombok.ast.libs.org.parboiled.support.DefaultInputBuffer;
import lombok.ast.libs.org.parboiled.support.FollowMatchersVisitor;
import lombok.ast.libs.org.parboiled.support.GetAStarterCharVisitor;
import lombok.ast.libs.org.parboiled.support.InputBuffer;
import lombok.ast.libs.org.parboiled.support.IsSingleCharMatcherVisitor;
import lombok.ast.libs.org.parboiled.support.IsStarterCharVisitor;
import lombok.ast.libs.org.parboiled.support.MatcherPath;
import lombok.ast.libs.org.parboiled.support.MutableInputBuffer;
import lombok.ast.libs.org.parboiled.support.ParsingResult;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecoveringParseRunner<V>
extends BasicParseRunner<V> {
    private int errorIndex;
    private InvalidInputError<V> currentError;
    private MutableInputBuffer buffer;

    public static <V> ParsingResult<V> run(@NotNull Rule rule, @NotNull String input) {
        if (rule == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.RecoveringParseRunner.run(...) corresponds to @NotNull parameter and must not be null");
        }
        if (input == null) {
            throw new IllegalArgumentException("2nd argument of method org.parboiled.RecoveringParseRunner.run(...) corresponds to @NotNull parameter and must not be null");
        }
        return new RecoveringParseRunner<V>(rule, input).run();
    }

    public RecoveringParseRunner(@NotNull Rule rule, @NotNull String input) {
        if (rule == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.RecoveringParseRunner.<init>(...) corresponds to @NotNull parameter and must not be null");
        }
        if (input == null) {
            throw new IllegalArgumentException("2nd argument of method org.parboiled.RecoveringParseRunner.<init>(...) corresponds to @NotNull parameter and must not be null");
        }
        super(rule, input);
    }

    @Override
    protected InputBuffer createInputBuffer(String input) {
        this.buffer = new MutableInputBuffer(new DefaultInputBuffer(input));
        return this.buffer;
    }

    @Override
    protected boolean runRootContext() {
        BasicParseRunner.Handler handler = new BasicParseRunner.Handler();
        if (this.runRootContext(handler)) {
            return true;
        }
        if (this.attemptRecordingMatch()) {
            throw new IllegalStateException();
        }
        do {
            this.performErrorReportingRun();
            if (this.fixError(this.errorIndex)) continue;
            return false;
        } while (this.errorIndex >= 0);
        return true;
    }

    protected boolean attemptRecordingMatch() {
        RecordingParseRunner.Handler<V> handler = new RecordingParseRunner.Handler<V>(this.getInnerHandler());
        boolean matched = this.runRootContext(handler);
        this.errorIndex = handler.getErrorIndex();
        return matched;
    }

    protected void performErrorReportingRun() {
        ReportingParseRunner.Handler<V> handler = new ReportingParseRunner.Handler<V>(this.errorIndex, this.getInnerHandler());
        this.runRootContext(handler);
        this.currentError = handler.getParseError();
    }

    protected MatchHandler<V> getInnerHandler() {
        return this.errorIndex >= 0 ? new Handler<V>(this.currentError) : new BasicParseRunner.Handler();
    }

    protected boolean fixError(int fixIndex) {
        if (this.tryFixBySingleCharDeletion(fixIndex)) {
            return true;
        }
        int nextErrorAfterDeletion = this.errorIndex;
        Character bestInsertionCharacter = this.findBestSingleCharInsertion(fixIndex);
        if (bestInsertionCharacter == null) {
            return true;
        }
        int nextErrorAfterBestInsertion = this.errorIndex;
        int nextErrorAfterBestSingleCharFix = Math.max(nextErrorAfterDeletion, nextErrorAfterBestInsertion);
        if (nextErrorAfterBestSingleCharFix > fixIndex) {
            if (nextErrorAfterDeletion >= nextErrorAfterBestInsertion) {
                this.buffer.insertChar(fixIndex, '\ufdef');
                this.errorIndex = nextErrorAfterDeletion + 1;
                this.shiftCurrentErrorIndicesBy(1);
            } else {
                this.buffer.insertChar(fixIndex, bestInsertionCharacter.charValue());
                this.buffer.insertChar(fixIndex, '\ufdee');
                this.errorIndex = nextErrorAfterBestInsertion + 2;
                this.shiftCurrentErrorIndicesBy(2);
            }
        } else {
            this.buffer.insertChar(fixIndex, '\ufded');
            this.shiftCurrentErrorIndicesBy(1);
            this.attemptRecordingMatch();
        }
        return true;
    }

    protected boolean tryFixBySingleCharDeletion(int fixIndex) {
        this.buffer.insertChar(fixIndex, '\ufdef');
        boolean nowErrorFree = this.attemptRecordingMatch();
        if (nowErrorFree) {
            this.shiftCurrentErrorIndicesBy(1);
        } else {
            this.buffer.undoCharInsertion(fixIndex);
            this.errorIndex = Math.max(this.errorIndex - 1, 0);
        }
        return nowErrorFree;
    }

    protected Character findBestSingleCharInsertion(int fixIndex) {
        GetAStarterCharVisitor getAStarterCharVisitor = new GetAStarterCharVisitor();
        int bestNextErrorIndex = -1;
        Character bestChar = null;
        for (MatcherPath<V> failedMatcherPath : this.currentError.getFailedMatchers()) {
            Character starterChar = (Character)failedMatcherPath.getHead().accept(getAStarterCharVisitor);
            Preconditions.checkState(starterChar != null);
            if (starterChar.charValue() == '\uffff') continue;
            this.buffer.insertChar(fixIndex, starterChar.charValue());
            this.buffer.insertChar(fixIndex, '\ufdee');
            if (this.attemptRecordingMatch()) {
                this.shiftCurrentErrorIndicesBy(2);
                return null;
            }
            this.buffer.undoCharInsertion(fixIndex);
            this.buffer.undoCharInsertion(fixIndex);
            this.errorIndex = Math.max(this.errorIndex - 2, 0);
            if (bestNextErrorIndex >= this.errorIndex) continue;
            bestNextErrorIndex = this.errorIndex;
            bestChar = starterChar;
        }
        this.errorIndex = bestNextErrorIndex;
        return bestChar;
    }

    private void shiftCurrentErrorIndicesBy(int delta) {
        this.currentError.setStartIndex(this.currentError.getStartIndex() + delta);
        this.currentError.setEndIndex(this.currentError.getEndIndex() + delta);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Handler<V>
    implements MatchHandler<V> {
        private final IsSingleCharMatcherVisitor<V> isSingleCharMatcherVisitor = new IsSingleCharMatcherVisitor();
        private final InvalidInputError<V> currentError;
        private int fringeIndex;
        private MatcherPath<V> lastMatchPath;

        public Handler(InvalidInputError<V> currentError) {
            this.currentError = currentError;
        }

        @Override
        public boolean matchRoot(MatcherContext<V> rootContext) {
            return rootContext.runMatcher();
        }

        @Override
        public boolean match(MatcherContext<V> context) {
            Matcher<V> matcher = context.getMatcher();
            if (((Boolean)matcher.accept(this.isSingleCharMatcherVisitor)).booleanValue()) {
                if (this.prepareErrorLocation(context) && matcher.match(context)) {
                    if (this.fringeIndex < context.getCurrentIndex()) {
                        this.fringeIndex = context.getCurrentIndex();
                        this.lastMatchPath = context.getPath();
                    }
                    return true;
                }
                return false;
            }
            if (matcher.match(context)) {
                return true;
            }
            return context.getInputBuffer().charAt(this.fringeIndex) == '\ufded' && this.qualifiesForResync(context, matcher) && this.resynchronize(context);
        }

        private boolean qualifiesForResync(MatcherContext<V> context, Matcher<V> matcher) {
            if (matcher instanceof SequenceMatcher && context.getCurrentIndex() > context.getStartIndex() && context.getPath().isPrefixOf(this.lastMatchPath)) {
                return true;
            }
            return context.getParent() == null;
        }

        protected boolean prepareErrorLocation(MatcherContext<V> context) {
            switch (context.getCurrentChar()) {
                case '\ufdef': {
                    return this.willMatchDelError(context);
                }
                case '\ufdee': {
                    return this.willMatchInsError(context);
                }
            }
            return true;
        }

        protected boolean willMatchDelError(MatcherContext<V> context) {
            int preSkipIndex = context.getCurrentIndex();
            context.advanceIndex();
            context.advanceIndex();
            if (!this.runTestMatch(context)) {
                context.setCurrentIndex(preSkipIndex);
                return false;
            }
            context.setStartIndex(context.getCurrentIndex());
            context.clearNodeSuppression();
            if (context.getParent() != null) {
                ((MatcherContext)context.getParent()).markError();
            }
            return true;
        }

        protected boolean willMatchInsError(MatcherContext<V> context) {
            int preSkipIndex = context.getCurrentIndex();
            context.advanceIndex();
            if (!this.runTestMatch(context)) {
                context.setCurrentIndex(preSkipIndex);
                return false;
            }
            context.setStartIndex(context.getCurrentIndex());
            context.clearNodeSuppression();
            context.markError();
            return true;
        }

        protected boolean runTestMatch(MatcherContext<V> context) {
            TestMatcher<V> testMatcher = new TestMatcher<V>(context.getMatcher());
            return testMatcher.getSubContext(context).runMatcher();
        }

        protected boolean resynchronize(MatcherContext<V> context) {
            context.clearNodeSuppression();
            context.markError();
            context.createNode();
            context.advanceIndex();
            ++this.fringeIndex;
            List followMatchers = new FollowMatchersVisitor<V>().getFollowMatchers(context);
            int endIndex = this.gobbleIllegalCharacters(context, followMatchers);
            if (this.currentError != null && this.currentError.getStartIndex() == this.fringeIndex && endIndex - this.fringeIndex > 1) {
                this.currentError.setEndIndex(endIndex);
            }
            return true;
        }

        protected int gobbleIllegalCharacters(MatcherContext<V> context, List<Matcher<V>> followMatchers) {
            char currentChar;
            block0: while ((currentChar = context.getCurrentChar()) != '\uffff') {
                for (Matcher<V> followMatcher : followMatchers) {
                    if (!((Boolean)followMatcher.accept(new IsStarterCharVisitor(currentChar))).booleanValue()) continue;
                    break block0;
                }
                context.advanceIndex();
            }
            return context.getCurrentIndex();
        }
    }
}

