/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.ast.AbstractNode;
import lombok.ast.AstException;
import lombok.ast.AstVisitor;
import lombok.ast.Block;
import lombok.ast.Expression;
import lombok.ast.ListAccessor;
import lombok.ast.Node;
import lombok.ast.RawListAccessor;
import lombok.ast.Statement;
import lombok.ast.StrictListAccessor;
import lombok.ast.TypeReference;

public class SuperConstructorInvocation
extends AbstractNode
implements Statement {
    private AbstractNode qualifier = null;
    ListAccessor<TypeReference, SuperConstructorInvocation> constructorTypeArguments = ListAccessor.of(this, TypeReference.class, "SuperConstructorInvocation.constructorTypeArguments");
    ListAccessor<Expression, SuperConstructorInvocation> arguments = ListAccessor.of(this, Expression.class, "SuperConstructorInvocation.arguments");

    @Override
    public Block upToBlock() {
        if (!(this.getParent() instanceof Block)) {
            return null;
        }
        Block out = (Block)this.getParent();
        if (!out.rawContents().contains(this)) {
            return null;
        }
        return out;
    }

    public Expression astQualifier() {
        if (!(this.qualifier instanceof Expression)) {
            return null;
        }
        return (Expression)((Object)this.qualifier);
    }

    public SuperConstructorInvocation astQualifier(Expression qualifier) {
        return this.rawQualifier(qualifier);
    }

    public Node rawQualifier() {
        return this.qualifier;
    }

    public SuperConstructorInvocation rawQualifier(Node qualifier) {
        if (qualifier == this.qualifier) {
            return this;
        }
        if (qualifier != null) {
            this.adopt((AbstractNode)qualifier);
        }
        if (this.qualifier != null) {
            this.disown(this.qualifier);
        }
        this.qualifier = (AbstractNode)qualifier;
        return this;
    }

    public RawListAccessor<TypeReference, SuperConstructorInvocation> rawConstructorTypeArguments() {
        return this.constructorTypeArguments.asRaw();
    }

    public StrictListAccessor<TypeReference, SuperConstructorInvocation> astConstructorTypeArguments() {
        return this.constructorTypeArguments.asStrict();
    }

    public RawListAccessor<Expression, SuperConstructorInvocation> rawArguments() {
        return this.arguments.asRaw();
    }

    public StrictListAccessor<Expression, SuperConstructorInvocation> astArguments() {
        return this.arguments.asStrict();
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        if (this.qualifier != null) {
            result.add(this.qualifier);
        }
        result.addAll(this.constructorTypeArguments.backingList());
        result.addAll(this.arguments.backingList());
        return result;
    }

    @Override
    public boolean replaceChild(Node original, Node replacement) throws AstException {
        if (this.qualifier == original) {
            this.rawQualifier(replacement);
            return true;
        }
        if (this.rawConstructorTypeArguments().replace(original, replacement)) {
            return true;
        }
        return this.rawArguments().replace(original, replacement);
    }

    @Override
    public boolean detach(Node child) {
        if (this.qualifier == child) {
            this.disown((AbstractNode)child);
            this.qualifier = null;
            return true;
        }
        if (this.rawConstructorTypeArguments().remove(child)) {
            return true;
        }
        return this.rawArguments().remove(child);
    }

    @Override
    public void accept(AstVisitor visitor) {
        if (visitor.visitSuperConstructorInvocation(this)) {
            return;
        }
        if (this.qualifier != null) {
            this.qualifier.accept(visitor);
        }
        for (AbstractNode child : this.constructorTypeArguments.asIterable()) {
            child.accept(visitor);
        }
        for (AbstractNode child : this.arguments.asIterable()) {
            child.accept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public SuperConstructorInvocation copy() {
        SuperConstructorInvocation result = new SuperConstructorInvocation();
        if (this.qualifier != null) {
            result.rawQualifier(this.qualifier.copy());
        }
        for (AbstractNode n : this.constructorTypeArguments.backingList()) {
            result.rawConstructorTypeArguments().addToEnd(n == null ? null : n.copy());
        }
        for (AbstractNode n : this.arguments.backingList()) {
            result.rawArguments().addToEnd(n == null ? null : n.copy());
        }
        return result;
    }
}

